/*
 * Decompiled with CFR 0.152.
 */
package xyz.danoz.recyclerviewfastscroller.calculation.progress;

import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import xyz.danoz.recyclerviewfastscroller.calculation.VerticalScrollBoundsProvider;
import xyz.danoz.recyclerviewfastscroller.calculation.progress.VerticalScrollProgressCalculator;

public class VerticalLinearLayoutManagerScrollProgressCalculator
extends VerticalScrollProgressCalculator {
    public VerticalLinearLayoutManagerScrollProgressCalculator(VerticalScrollBoundsProvider scrollBoundsProvider) {
        super(scrollBoundsProvider);
    }

    @Override
    public float calculateScrollProgress(RecyclerView recyclerView) {
        LinearLayoutManager layoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
        int lastFullyVisiblePosition = layoutManager.findLastCompletelyVisibleItemPosition();
        View visibleChild = recyclerView.getChildAt(0);
        if (visibleChild == null) {
            return 0.0f;
        }
        RecyclerView.ViewHolder holder = recyclerView.getChildViewHolder(visibleChild);
        int itemHeight = holder.itemView.getHeight();
        int recyclerHeight = recyclerView.getHeight();
        int itemsInWindow = recyclerHeight / itemHeight;
        int numItemsInList = recyclerView.getAdapter().getItemCount();
        int numScrollableSectionsInList = numItemsInList - itemsInWindow;
        int indexOfLastFullyVisibleItemInFirstSection = numItemsInList - numScrollableSectionsInList - 1;
        int currentSection = lastFullyVisiblePosition - indexOfLastFullyVisibleItemInFirstSection;
        return (float)currentSection / (float)numScrollableSectionsInList;
    }
}

