/*
 * Decompiled with CFR 0.152.
 */
package xyz.cssxsh.selenium;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.Response;
import org.asynchttpclient.uri.Uri;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.Platform;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.chromium.ChromiumOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.RemoteWebDriver;
import xyz.cssxsh.selenium.AllIgnoredOutputStream;
import xyz.cssxsh.selenium.DriverCache;
import xyz.cssxsh.selenium.GitHubRelease;
import xyz.cssxsh.selenium.RemoteWebDriverConfig;
import xyz.cssxsh.selenium.SeleniumInitKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0000\u001a$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00122\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0012H\u0000\u001a7\u0010\u001a\u001a!\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 0\u001bj\u0002`!2\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020#H\u0000\u001a\u0018\u0010$\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0001H\u0000\u001a/\u0010&\u001a!\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 0\u001bj\u0002`!2\u0006\u0010\u0015\u001a\u00020\u0012H\u0000\u001a\u0018\u0010'\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0001H\u0000\u001a/\u0010(\u001a!\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 0\u001bj\u0002`!2\u0006\u0010\u0015\u001a\u00020\u0012H\u0000\u001a1\u0010)\u001a!\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 0\u001bj\u0002`!2\b\b\u0002\u0010*\u001a\u00020\u0001H\u0000\u001a\u0010\u0010+\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0000\u001a\u001c\u0010,\u001a\u0012\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0\u001bj\u0002`/*\u00020\u001cH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"\u000e\u0010\n\u001a\u00020\u000bX\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000*\"\u00100\"\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0\u001b2\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020.0\u001b*B\b\u0000\u00101\"\u001d\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 0\u001b2\u001d\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020 0\u001b\u00a8\u00062"}, d2={"CHROME_BROWSER_BINARY", "", "CHROME_DRIVER_MIRRORS", "EDGE_BROWSER_BINARY", "FIREFOX_BROWSER_BINARY", "FIREFOX_DRIVER_MIRRORS", "IgnoreJson", "Lkotlinx/serialization/json/Json;", "getIgnoreJson", "()Lkotlinx/serialization/json/Json;", "SELENIUM_DEFAULT_PORT", "", "SELENIUM_DOWNLOAD_EXPIRES", "SELENIUM_FOLDER", "SEVEN7Z_MIRRORS", "WEBDRIVER_HTTP_FACTORY", "clearWebDriver", "", "Ljava/io/File;", "download", "urlString", "folder", "filename", "queryRegister", "key", "queryVersion", "setupChromeDriver", "Lkotlin/Function1;", "Lxyz/cssxsh/selenium/RemoteWebDriverConfig;", "Lkotlin/ParameterName;", "name", "config", "Lorg/openqa/selenium/remote/RemoteWebDriver;", "Lxyz/cssxsh/selenium/RemoteWebDriverSupplier;", "chromium", "", "setupChromium", "version", "setupEdgeDriver", "setupFirefox", "setupFirefoxDriver", "setupWebDriver", "browser", "sevenZA", "toConsumer", "Lorg/openqa/selenium/Capabilities;", "", "Lxyz/cssxsh/selenium/DriverOptionsConsumer;", "DriverOptionsConsumer", "RemoteWebDriverSupplier", "mirai-selenium-plugin"})
public final class SeleniumInitKt {
    @NotNull
    public static final String SELENIUM_FOLDER = "xyz.cssxsh.selenium.folder";
    @NotNull
    public static final String SELENIUM_DOWNLOAD_EXPIRES = "xyz.cssxsh.selenium.download.expires";
    public static final int SELENIUM_DEFAULT_PORT = 9515;
    @NotNull
    public static final String WEBDRIVER_HTTP_FACTORY = "webdriver.http.factory";
    @NotNull
    public static final String CHROME_BROWSER_BINARY = "webdriver.chrome.bin";
    @NotNull
    public static final String CHROME_DRIVER_MIRRORS = "webdriver.chrome.mirrors";
    @NotNull
    public static final String FIREFOX_DRIVER_MIRRORS = "webdriver.firefox.mirrors";
    @NotNull
    public static final String EDGE_BROWSER_BINARY = "webdriver.edge.bin";
    @NotNull
    public static final String FIREFOX_BROWSER_BINARY = "webdriver.firefox.bin";
    @NotNull
    public static final String SEVEN7Z_MIRRORS = "seven7z.mirrors";
    @NotNull
    private static final Json IgnoreJson = JsonKt.Json$default(null, (Function1)IgnoreJson.1.INSTANCE, (int)1, null);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final String queryRegister(@NotNull String key) {
        CharSequence charSequence;
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        char[] cArray = new char[]{'|'};
        List list = StringsKt.split$default((CharSequence)key, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        String path = (String)list.get(0);
        String name = (String)list.get(1);
        String[] stringArray = new String[]{"reg", "query", path, "/v", name};
        Closeable closeable = new ProcessBuilder(stringArray).start().getInputStream();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            InputStream inputStream = it;
            Charset charset = Charsets.UTF_8;
            string = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String value = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)string, (String)"REG_SZ", null, (int)2, null))).toString();
        CharSequence charSequence2 = value;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)value, (String)"HKEY_CURRENT_USER", (boolean)false, (int)2, null)) throw new UnsupportedOperationException("\u6ce8\u518c\u8868 " + key + " \u83b7\u53d6\u5931\u8d25 \n" + value);
            charSequence = SeleniumInitKt.queryRegister(StringsKt.replaceFirst$default((String)key, (String)"HKEY_CURRENT_USER", (String)"HKEY_LOCAL_MACHINE", (boolean)false, (int)4, null));
            return (String)charSequence;
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    @NotNull
    public static final String queryVersion(@NotNull File folder) {
        Object object;
        block9: {
            block8: {
                String string;
                block7: {
                    Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
                    Regex regex = new Regex("^[\\d.]+");
                    object = folder.list();
                    if (object == null || (object = ArraysKt.reversed((Object[])object)) == null) break block8;
                    for (String it : (Iterable)object) {
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)it, (int)0, (int)2, null);
                        string = matchResult != null ? matchResult.getValue() : null;
                        if (string == null) {
                            continue;
                        }
                        break block7;
                    }
                    string = null;
                }
                if (string == null) {
                    throw new NoSuchElementException("No element of the collection was transformed to a non-null value.");
                }
                object = string;
                if (string != null) break block9;
            }
            throw new UnsupportedOperationException("\u65e0\u6cd5\u5728 " + folder.getAbsolutePath() + " \u627e\u5230\u7248\u672c\u4fe1\u606f");
        }
        return object;
    }

    @NotNull
    public static final Json getIgnoreJson() {
        return IgnoreJson;
    }

    @NotNull
    public static final File download(@NotNull String urlString, @NotNull File folder, @Nullable String filename) {
        File current;
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        if (filename != null && (current = FilesKt.resolve((File)folder, (String)filename)).exists()) {
            return current;
        }
        AsyncHttpClient client = Dsl.asyncHttpClient((DefaultAsyncHttpClientConfig.Builder)new DefaultAsyncHttpClientConfig.Builder().setFollowRedirect(true).setUserAgent("curl/7.61.0").setRequestTimeout(180000));
        BoundRequestBuilder $this$download_u24lambda_u2d3 = client.prepareGet(urlString);
        boolean bl = false;
        String token = System.getenv("GITHUB_TOKEN");
        if (StringsKt.contains$default((CharSequence)urlString, (CharSequence)"api.github.com", (boolean)false, (int)2, null) && token != null) {
            $this$download_u24lambda_u2d3.addHeader((CharSequence)"Authorization", token);
        }
        Response response = (Response)$this$download_u24lambda_u2d3.execute().get();
        if (response.getStatusCode() != 200) {
            throw new IllegalStateException("status " + response.getStatusCode() + " download " + urlString + ' ');
        }
        String string = filename;
        if (string == null) {
            String string2;
            String string3 = response.getHeader((CharSequence)"Content-Disposition");
            if (string3 != null) {
                String text = string3;
                boolean bl2 = false;
                Object object = Regex.find$default((Regex)new Regex("filename=\"[^\"]+\""), (CharSequence)text, (int)0, (int)2, null);
                string2 = object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
            } else {
                string2 = string = null;
            }
            if (string2 == null) {
                String string4 = response.getUri().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"response.uri.path");
                String value = StringsKt.substringAfterLast$default((String)string4, (char)'/', null, (int)2, null);
                boolean bl3 = false;
                string = URLDecoder.decode(value, Charset.defaultCharset());
            }
        }
        String relative = string;
        Intrinsics.checkNotNullExpressionValue((Object)relative, (String)"relative");
        File file = FilesKt.resolve((File)folder, (String)relative);
        byte[] byArray = response.getResponseBodyAsBytes();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"response.responseBodyAsBytes");
        FilesKt.writeBytes((File)file, (byte[])byArray);
        return file;
    }

    public static /* synthetic */ File download$default(String string, File file, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return SeleniumInitKt.download(string, file, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final Function1<RemoteWebDriverConfig, RemoteWebDriver> setupWebDriver(@NotNull String browser) {
        Function1<RemoteWebDriverConfig, RemoteWebDriver> function1;
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        File folder = new File(System.getProperty(SELENIUM_FOLDER, "."));
        folder.mkdirs();
        if (StringsKt.isBlank((CharSequence)browser) || StringsKt.contains((CharSequence)browser, (CharSequence)"Default", (boolean)true)) {
            Object object;
            Object object2;
            Platform platform = Platform.getCurrent();
            if (platform.is(Platform.WINDOWS)) {
                try {
                    object2 = SeleniumInitKt.queryRegister("HKEY_CURRENT_USER\\SOFTWARE\\Microsoft\\Windows\\Shell\\Associations\\URLAssociations\\https\\UserChoice|ProgId");
                }
                catch (Throwable cause) {
                    throw new UnsupportedOperationException("UserChoice \u67e5\u8be2\u5931\u8d25", cause);
                }
                object = object2;
            } else if (platform.is(Platform.LINUX)) {
                try {
                    object2 = new String[]{"xdg-settings", "get", "default-web-browser"};
                    object2 = new ProcessBuilder((String)object2).start().getInputStream();
                    Throwable cause = null;
                    try {
                        Object it = (InputStream)object2;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        InputStream inputStream = it;
                        Charset charset = Charsets.UTF_8;
                        it = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
                    }
                    catch (Throwable it) {
                        cause = it;
                        throw it;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)cause);
                    }
                    object2 = it;
                }
                catch (Throwable cause) {
                    throw new UnsupportedOperationException("xdg-settings \u6267\u884c\u5931\u8d25\uff0c\u53ef\u80fd\u9700\u8981\u5b89\u88c5 xdg-utils", cause);
                }
                object = object2;
            } else if (platform.is(Platform.MAC)) {
                Object v4;
                block32: {
                    void $this$firstOrNull$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    boolean $i$f$emptyArray;
                    Object $this$orEmpty$iv = new File("/Applications").list();
                    boolean $i$f$orEmpty = false;
                    Object[] objectArray = $this$orEmpty$iv;
                    if ($this$orEmpty$iv == null) {
                        $i$f$emptyArray = false;
                        objectArray = new String[0];
                    }
                    Collection collection = ArraysKt.asList((Object[])objectArray);
                    $this$orEmpty$iv = new File(System.getProperty("user.home") + "/Applications").list();
                    $i$f$orEmpty = false;
                    Object[] objectArray2 = $this$orEmpty$iv;
                    if ($this$orEmpty$iv == null) {
                        $i$f$emptyArray = false;
                        objectArray2 = new String[0];
                    }
                    $this$orEmpty$iv = CollectionsKt.plus((Collection)collection, (Object[])objectArray2);
                    boolean $i$f$filter = false;
                    void $i$f$emptyArray2 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!StringsKt.endsWith$default((String)it, (String)".app", (boolean)false, (int)2, null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        CharSequence charSequence = it;
                        if (!new Regex("(?i)Chrome|Chromium|Firefox").containsMatchIn(charSequence)) continue;
                        v4 = element$iv;
                        break block32;
                    }
                    v4 = null;
                }
                if ((object = (String)v4) == null) {
                    throw new UnsupportedOperationException("\u672a\u627e\u5230\u53d7\u652f\u6301\u7684\u6d4f\u89c8\u5668");
                }
            } else {
                throw new UnsupportedOperationException("\u4e0d\u53d7\u652f\u6301\u7684\u5e73\u53f0 " + platform);
            }
            String[] stringArray = object;
            if (StringsKt.isBlank((CharSequence)((CharSequence)stringArray))) {
                throw new UnsupportedOperationException("\u9ed8\u8ba4\u6d4f\u89c8\u5668\u4e3a\u7a7a");
            }
            function1 = SeleniumInitKt.setupWebDriver((String)stringArray);
        } else if (StringsKt.contains((CharSequence)browser, (CharSequence)"Edge", (boolean)true)) {
            function1 = SeleniumInitKt.setupEdgeDriver(folder);
        } else if (StringsKt.contains((CharSequence)browser, (CharSequence)"Chrome", (boolean)true)) {
            function1 = SeleniumInitKt.setupChromeDriver(folder, false);
        } else if (StringsKt.contains((CharSequence)browser, (CharSequence)"Chromium", (boolean)true)) {
            function1 = SeleniumInitKt.setupChromeDriver(folder, true);
        } else if (StringsKt.contains((CharSequence)browser, (CharSequence)"Firefox", (boolean)true)) {
            function1 = SeleniumInitKt.setupFirefoxDriver(folder);
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u6d4f\u89c8\u5668 " + browser);
        }
        return function1;
    }

    public static /* synthetic */ Function1 setupWebDriver$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return SeleniumInitKt.setupWebDriver(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final Function1<RemoteWebDriverConfig, RemoteWebDriver> setupEdgeDriver(@NotNull File folder) {
        Object element$iv2;
        String version;
        File binary;
        block15: {
            void $this$first$iv;
            String string;
            File file;
            Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
            if (!Platform.getCurrent().is(Platform.WINDOWS)) {
                throw new UnsupportedOperationException("Edge only supported Windows/Edge");
            }
            String string2 = System.getProperty(EDGE_BROWSER_BINARY);
            if (string2 != null) {
                String p0 = string2;
                boolean bl = false;
                file = new File(p0);
            } else {
                file = null;
            }
            binary = file;
            try {
                String string3;
                if (binary != null) {
                    File file2 = binary.getParentFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"binary.parentFile");
                    string3 = SeleniumInitKt.queryVersion(file2);
                } else {
                    string3 = SeleniumInitKt.queryRegister("HKEY_CURRENT_USER\\SOFTWARE\\Microsoft\\Edge\\BLBeacon|version");
                }
                string = string3;
            }
            catch (UnsupportedOperationException unsupported) {
                throw unsupported;
            }
            catch (Throwable cause) {
                throw new UnsupportedOperationException("Edge \u7248\u672c\u83b7\u53d6\u5931\u8d25", cause);
            }
            version = string;
            File xml = SeleniumInitKt.download("https://msedgewebdriverstorage.blob.core.windows.net/edgewebdriver?prefix=" + version + "&comp=list&timeout=60000", folder, "msedgedriver-" + version + ".xml");
            Sequence bl = Regex.findAll$default((Regex)new Regex("(?<=<Url>).{16,256}\\.zip"), (CharSequence)FilesKt.readText$default((File)xml, null, (int)1, null), (int)0, (int)2, null);
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MatchResult it = (MatchResult)element$iv2;
                boolean bl2 = false;
                if (!StringsKt.contains$default((CharSequence)it.getValue(), (CharSequence)"win64", (boolean)false, (int)2, null)) continue;
                break block15;
            }
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        String url = ((MatchResult)element$iv2).getValue();
        File file = SeleniumInitKt.download(url, folder, "msedgedriver-" + version + '_' + StringsKt.substringAfterLast$default((String)url, (char)'_', null, (int)2, null));
        File driver = FilesKt.resolve((File)folder, (String)(FilesKt.getNameWithoutExtension((File)file) + ".exe"));
        if (!driver.exists()) {
            ZipFile zip = new ZipFile(file);
            ZipEntry entry = zip.getEntry("msedgedriver.exe");
            Closeable closeable = zip.getInputStream(entry);
            Throwable throwable = null;
            try {
                InputStream input = (InputStream)closeable;
                boolean bl = false;
                byte[] byArray = input.readAllBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"input.readAllBytes()");
                FilesKt.writeBytes((File)driver, (byte[])byArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            driver.setLastModified(entry.getTime());
        }
        driver.setExecutable(true);
        System.setProperty("webdriver.edge.driver", driver.getAbsolutePath());
        return (Function1)new Function1<RemoteWebDriverConfig, EdgeDriver>(binary, folder, driver){
            final /* synthetic */ File $binary;
            final /* synthetic */ File $folder;
            final /* synthetic */ File $driver;
            {
                this.$binary = $binary;
                this.$folder = $folder;
                this.$driver = $driver;
                super(1);
            }

            @NotNull
            public final EdgeDriver invoke(@NotNull RemoteWebDriverConfig config) {
                File file;
                int n;
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                if (!StringsKt.isBlank((CharSequence)config.getFactory())) {
                    System.setProperty("webdriver.http.factory", config.getFactory());
                }
                EdgeOptions edgeOptions = new EdgeOptions();
                SeleniumInitKt.toConsumer(config).invoke((Object)edgeOptions);
                EdgeOptions options = edgeOptions;
                if (this.$binary != null) {
                    options.setBinary(this.$binary);
                }
                try {
                    n = PortProber.findFreePort();
                }
                catch (RuntimeException _) {
                    n = 9515;
                }
                int port = n;
                String uuid = "" + System.currentTimeMillis() + '-' + port;
                File file2 = file = FilesKt.resolve((File)this.$folder, (String)("msedgedriver." + uuid + ".log"));
                EdgeDriverService.Builder builder = new EdgeDriverService.Builder();
                boolean bl = false;
                boolean bl2 = config.getLog();
                EdgeDriverService service = (EdgeDriverService)((EdgeDriverService.Builder)((EdgeDriverService.Builder)((EdgeDriverService.Builder)builder.withLogFile(bl2 ? file : null)).usingDriverExecutable(this.$driver)).usingPort(port)).build();
                File it = bl = FilesKt.resolve((File)this.$folder, (String)("msedgedriver." + uuid + ".output"));
                boolean bl3 = false;
                file2 = config.getLog() ? bl : null;
                OutputStream output = file2 != null ? (OutputStream)new FileOutputStream(file2) : (OutputStream)AllIgnoredOutputStream.INSTANCE;
                service.sendOutputTo(output);
                File it2 = file2 = new EdgeDriver(service, options);
                boolean bl4 = false;
                Map map = DriverCache.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)service, (String)"service");
                map.put(it2, service);
                return file2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Function1<RemoteWebDriverConfig, RemoteWebDriver> setupChromeDriver(@NotNull File folder, boolean chromium2) {
        File driver;
        String string;
        Object object;
        String string2;
        File file;
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Platform platform = Platform.getCurrent();
        String string3 = System.getProperty(CHROME_BROWSER_BINARY);
        if (string3 != null) {
            String p0 = string3;
            boolean bl = false;
            file = new File(p0);
        } else {
            file = null;
        }
        File binary = file;
        try {
            Charset charset;
            InputStream inputStream;
            Object it2;
            String path;
            Object object2;
            if (platform.is(Platform.WINDOWS)) {
                if (binary != null) {
                    File file2 = binary.getParentFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"binary.parentFile");
                    object2 = SeleniumInitKt.queryVersion(file2);
                } else {
                    object2 = SeleniumInitKt.queryRegister(chromium2 ? "HKEY_CURRENT_USER\\SOFTWARE\\Chromium\\BLBeacon|version" : "HKEY_CURRENT_USER\\SOFTWARE\\Google\\Chrome\\BLBeacon|version");
                }
            } else if (platform.is(Platform.LINUX)) {
                string2 = chromium2 ? "chromium-browser" : "google-chrome";
                path = System.getProperty(CHROME_BROWSER_BINARY, string2);
                Object bl = new String[]{path, "--version"};
                bl = new ProcessBuilder((String)bl).start().getInputStream();
                object = null;
                try {
                    it2 = (InputStream)bl;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                    inputStream = it2;
                    charset = Charsets.UTF_8;
                    it2 = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
                    object2 = it2;
                }
                catch (Throwable it2) {
                    object = it2;
                    throw it2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)bl, (Throwable)object);
                }
            } else if (platform.is(Platform.MAC)) {
                string2 = chromium2 ? "Chromium" : "Google\\ Chrome";
                path = System.getProperty(CHROME_BROWSER_BINARY, string2);
                Object bl = new String[]{path, "--version"};
                bl = new ProcessBuilder((String)bl).start().getInputStream();
                object = null;
                try {
                    it2 = (InputStream)bl;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                    inputStream = it2;
                    charset = Charsets.UTF_8;
                    it2 = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
                    object2 = it2;
                }
                catch (Throwable it3) {
                    object = it3;
                    throw it3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)bl, (Throwable)object);
                }
            } else {
                throw new UnsupportedOperationException("\u4e0d\u53d7\u652f\u6301\u7684\u5e73\u53f0 " + platform);
            }
            string2 = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)StringsKt.substringAfter$default((String)object2, (String)"Chrome", null, (int)2, null), (String)"Chromium", null, (int)2, null))).toString();
        }
        catch (UnsupportedOperationException unsupported) {
            throw unsupported;
        }
        catch (Throwable cause) {
            throw new UnsupportedOperationException("Chrome/Chromium \u7248\u672c\u83b7\u53d6\u5931\u8d25", cause);
        }
        String version0 = string2;
        String base = System.getProperty(CHROME_DRIVER_MIRRORS, "https://chromedriver.storage.googleapis.com");
        File mapping = FilesKt.resolve((File)folder, (String)("chromedriver-" + version0 + ".mapping"));
        if (!mapping.exists()) {
            object = new String[]{"LATEST_RELEASE_" + StringsKt.substringBeforeLast$default((String)version0, (char)'.', null, (int)2, null), "LATEST_RELEASE_" + StringsKt.substringBefore$default((String)version0, (char)'.', null, (int)2, null), "LATEST_RELEASE"};
            List list = CollectionsKt.listOf((Object[])object);
            for (String release : list) {
                try {
                    SeleniumInitKt.download(base + '/' + release, folder, "chromedriver-" + version0 + ".mapping");
                    break;
                }
                catch (Throwable _) {
                }
            }
        }
        String version = FilesKt.readText$default((File)mapping, null, (int)1, null);
        if (platform.is(Platform.WINDOWS)) {
            string = "win32";
        } else if (platform.is(Platform.LINUX)) {
            string = "linux64";
        } else if (platform.is(Platform.MAC)) {
            string = "mac64";
        } else {
            throw new UnsupportedOperationException("\u4e0d\u53d7\u652f\u6301\u7684\u5e73\u53f0 " + platform);
        }
        String suffix = string;
        File file3 = SeleniumInitKt.download(base + '/' + version + "/chromedriver_" + suffix + ".zip", folder, "chromedriver-" + version + '_' + suffix + ".zip");
        File file4 = driver = platform.is(Platform.WINDOWS) ? FilesKt.resolve((File)folder, (String)("chromedriver-" + version + '_' + suffix + ".exe")) : FilesKt.resolve((File)folder, (String)("chromedriver-" + version + '_' + suffix));
        if (!driver.exists()) {
            ZipFile zip = new ZipFile(file3);
            ZipEntry entry = zip.entries().nextElement();
            Closeable closeable = zip.getInputStream(entry);
            Throwable throwable = null;
            try {
                InputStream input = (InputStream)closeable;
                boolean bl = false;
                byte[] byArray = input.readAllBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"input.readAllBytes()");
                FilesKt.writeBytes((File)driver, (byte[])byArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            driver.setLastModified(entry.getTime());
        }
        driver.setExecutable(true);
        System.setProperty("webdriver.chrome.driver", driver.getAbsolutePath());
        return (Function1)new Function1<RemoteWebDriverConfig, ChromeDriver>(binary, folder, driver){
            final /* synthetic */ File $binary;
            final /* synthetic */ File $folder;
            final /* synthetic */ File $driver;
            {
                this.$binary = $binary;
                this.$folder = $folder;
                this.$driver = $driver;
                super(1);
            }

            @NotNull
            public final ChromeDriver invoke(@NotNull RemoteWebDriverConfig config) {
                File file;
                int n;
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                if (!StringsKt.isBlank((CharSequence)config.getFactory())) {
                    System.setProperty("webdriver.http.factory", config.getFactory());
                }
                ChromeOptions chromeOptions = new ChromeOptions();
                SeleniumInitKt.toConsumer(config).invoke((Object)chromeOptions);
                ChromeOptions options = chromeOptions;
                if (this.$binary != null) {
                    options.setBinary(this.$binary);
                }
                try {
                    n = PortProber.findFreePort();
                }
                catch (RuntimeException _) {
                    n = 9515;
                }
                int port = n;
                String uuid = "" + System.currentTimeMillis() + '-' + port;
                File file2 = file = FilesKt.resolve((File)this.$folder, (String)("chromedriver." + uuid + ".log"));
                ChromeDriverService.Builder builder = new ChromeDriverService.Builder().withAppendLog(config.getLog());
                boolean bl = false;
                boolean bl2 = config.getLog();
                ChromeDriverService service = (ChromeDriverService)((ChromeDriverService.Builder)((ChromeDriverService.Builder)((ChromeDriverService.Builder)builder.withLogFile(bl2 ? file : null)).withLogLevel(options.getLogLevel()).usingDriverExecutable(this.$driver)).usingPort(port)).build();
                File it = bl = FilesKt.resolve((File)this.$folder, (String)("chromedriver." + uuid + ".output"));
                boolean bl3 = false;
                file2 = config.getLog() ? bl : null;
                OutputStream output = file2 != null ? (OutputStream)new FileOutputStream(file2) : (OutputStream)AllIgnoredOutputStream.INSTANCE;
                service.sendOutputTo(output);
                File it2 = file2 = new ChromeDriver(service, options);
                boolean bl4 = false;
                Map map = DriverCache.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)service, (String)"service");
                map.put(it2, service);
                return file2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Function1<RemoteWebDriverConfig, RemoteWebDriver> setupFirefoxDriver(@NotNull File folder) {
        File driver;
        File file;
        String string;
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Platform platform = Platform.getCurrent();
        GitHubRelease json = (GitHubRelease)IgnoreJson.decodeFromString((DeserializationStrategy)GitHubRelease.Companion.serializer(), FilesKt.readText$default((File)SeleniumInitKt.download("https://api.github.com/repos/mozilla/geckodriver/releases/latest", folder, "geckodriver.json"), null, (int)1, null));
        String version = json.getTagName();
        if (platform.is(Platform.WINDOWS)) {
            string = "geckodriver-" + version + "-win64.zip";
        } else if (platform.is(Platform.LINUX)) {
            string = "geckodriver-" + version + "-linux64.tar.gz";
        } else if (platform.is(Platform.MAC)) {
            string = "geckodriver-" + version + "-macos.tar.gz";
        } else {
            throw new UnsupportedOperationException("\u4e0d\u53d7\u652f\u6301\u7684\u5e73\u53f0 " + platform);
        }
        String filename = string;
        String base = System.getProperty(FIREFOX_DRIVER_MIRRORS, "https://github.com/mozilla/geckodriver/releases/download");
        File file2 = SeleniumInitKt.download(base + '/' + version + '/' + filename, folder, filename);
        if (platform.is(Platform.WINDOWS)) {
            file = FilesKt.resolve((File)folder, (String)(FilesKt.getNameWithoutExtension((File)file2) + ".exe"));
        } else {
            String string2 = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.name");
            file = driver = FilesKt.resolve((File)folder, (String)StringsKt.substringBefore$default((String)string2, (String)".tar", null, (int)2, null));
        }
        if (!driver.exists()) {
            if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)file2), (Object)"zip")) {
                ZipFile zip = new ZipFile(file2);
                ZipEntry entry = zip.entries().nextElement();
                Closeable closeable = zip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    InputStream input = (InputStream)closeable;
                    boolean bl = false;
                    byte[] byArray = input.readAllBytes();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"input.readAllBytes()");
                    FilesKt.writeBytes((File)driver, (byte[])byArray);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                driver.setLastModified(entry.getTime());
            } else {
                String[] stringArray = new String[]{"tar", "-xzf", file2.getAbsolutePath()};
                new ProcessBuilder(stringArray).directory(folder).start().waitFor();
                if (!FilesKt.resolve((File)folder, (String)"geckodriver").renameTo(driver)) {
                    boolean bl = false;
                    String string3 = "\u91cd\u547d\u540d geckodriver \u5931\u8d25";
                    throw new IllegalStateException(string3.toString());
                }
            }
        }
        driver.setExecutable(true);
        System.setProperty("webdriver.gecko.driver", driver.getAbsolutePath());
        return (Function1)new Function1<RemoteWebDriverConfig, FirefoxDriver>(folder, driver){
            final /* synthetic */ File $folder;
            final /* synthetic */ File $driver;
            {
                this.$folder = $folder;
                this.$driver = $driver;
                super(1);
            }

            @NotNull
            public final FirefoxDriver invoke(@NotNull RemoteWebDriverConfig config) {
                File file;
                int n;
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                if (!StringsKt.isBlank((CharSequence)config.getFactory())) {
                    System.setProperty("webdriver.http.factory", config.getFactory());
                }
                FirefoxOptions firefoxOptions = new FirefoxOptions();
                SeleniumInitKt.toConsumer(config).invoke((Object)firefoxOptions);
                FirefoxOptions options = firefoxOptions;
                try {
                    n = PortProber.findFreePort();
                }
                catch (RuntimeException _) {
                    n = 9515;
                }
                int port = n;
                String uuid = "" + System.currentTimeMillis() + '-' + port;
                File file2 = file = FilesKt.resolve((File)this.$folder, (String)("geckodriver." + uuid + ".log"));
                GeckoDriverService.Builder builder = new GeckoDriverService.Builder();
                boolean bl = false;
                boolean bl2 = config.getLog();
                GeckoDriverService service = (GeckoDriverService)((GeckoDriverService.Builder)((GeckoDriverService.Builder)((GeckoDriverService.Builder)builder.withLogFile(bl2 ? file : null)).usingDriverExecutable(this.$driver)).usingPort(port)).usingFirefoxBinary(options.getBinary()).build();
                File it = bl = FilesKt.resolve((File)this.$folder, (String)("geckodriver." + uuid + ".output"));
                boolean bl3 = false;
                file2 = config.getLog() ? bl : null;
                OutputStream output = file2 != null ? (OutputStream)new FileOutputStream(file2) : (OutputStream)AllIgnoredOutputStream.INSTANCE;
                service.sendOutputTo(output);
                File it2 = file2 = new FirefoxDriver((FirefoxDriverService)service, options);
                boolean bl4 = false;
                Map map = DriverCache.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)service, (String)"service");
                map.put(it2, service);
                return file2;
            }
        };
    }

    @NotNull
    public static final Function1<Capabilities, Unit> toConsumer(@NotNull RemoteWebDriverConfig $this$toConsumer) {
        Intrinsics.checkNotNullParameter((Object)$this$toConsumer, (String)"<this>");
        return (Function1)new Function1<Capabilities, Unit>($this$toConsumer){
            final /* synthetic */ RemoteWebDriverConfig $this_toConsumer;
            {
                this.$this_toConsumer = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Capabilities capabilities) {
                Intrinsics.checkNotNullParameter((Object)capabilities, (String)"capabilities");
                Capabilities capabilities2 = capabilities;
                if (capabilities2 instanceof ChromiumOptions) {
                    Map map;
                    void $this$mapValuesTo$iv$iv;
                    void $this$mapValues$iv;
                    Capabilities capabilities3 = capabilities;
                    RemoteWebDriverConfig remoteWebDriverConfig = this.$this_toConsumer;
                    ChromiumOptions $this$invoke_u24lambda_u2d1 = (ChromiumOptions)capabilities3;
                    boolean bl = false;
                    $this$invoke_u24lambda_u2d1.setHeadless(remoteWebDriverConfig.getHeadless());
                    $this$invoke_u24lambda_u2d1.setPageLoadStrategy(PageLoadStrategy.NORMAL);
                    $this$invoke_u24lambda_u2d1.setAcceptInsecureCerts(true);
                    Object object = new String[]{"--silent"};
                    $this$invoke_u24lambda_u2d1.addArguments((String[])object);
                    object = new String[]{"enable-automation", "ignore-certificate-errors"};
                    $this$invoke_u24lambda_u2d1.setExperimentalOption("excludeSwitches", (Object)CollectionsKt.listOf((Object[])object));
                    object = new String[]{"--hide-scrollbars"};
                    $this$invoke_u24lambda_u2d1.addArguments((String[])object);
                    if (!StringsKt.isBlank((CharSequence)remoteWebDriverConfig.getProxy())) {
                        object = new String[]{"--proxy-server=" + remoteWebDriverConfig.getProxy()};
                        $this$invoke_u24lambda_u2d1.addArguments((String[])object);
                    }
                    object = new String[]{"--user-agent=" + remoteWebDriverConfig.getUserAgent()};
                    $this$invoke_u24lambda_u2d1.addArguments((String[])object);
                    object = new String[]{"--window-size=" + remoteWebDriverConfig.getWidth() + ',' + remoteWebDriverConfig.getHeight()};
                    $this$invoke_u24lambda_u2d1.addArguments((String[])object);
                    $this$invoke_u24lambda_u2d1.addArguments(remoteWebDriverConfig.getArguments());
                    object = remoteWebDriverConfig.getPreferences();
                    String string = "prefs";
                    ChromiumOptions chromiumOptions = $this$invoke_u24lambda_u2d1;
                    boolean $i$f$mapValues = false;
                    void var11_19 = $this$mapValues$iv;
                    Map destination$iv$iv = new LinkedHashMap<K, V>(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                    boolean $i$f$mapValuesTo = false;
                    Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                    boolean $i$f$associateByTo = false;
                    for (T element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                        void it$iv$iv;
                        Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                        Map map2 = destination$iv$iv;
                        boolean bl2 = false;
                        Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                        K k = it$iv$iv.getKey();
                        map = map2;
                        boolean bl3 = false;
                        String value = (String)entry2.getValue();
                        Object object2 = StringsKt.toBooleanStrictOrNull((String)value);
                        if (object2 == null && (object2 = StringsKt.toDoubleOrNull((String)value)) == null) {
                            object2 = value;
                        }
                        Boolean bl4 = object2;
                        map.put(k, bl4);
                    }
                    map = destination$iv$iv;
                    chromiumOptions.setExperimentalOption(string, (Object)map);
                } else if (capabilities2 instanceof FirefoxOptions) {
                    Capabilities capabilities4 = capabilities;
                    RemoteWebDriverConfig remoteWebDriverConfig = this.$this_toConsumer;
                    FirefoxOptions $this$invoke_u24lambda_u2d2 = (FirefoxOptions)capabilities4;
                    boolean bl = false;
                    $this$invoke_u24lambda_u2d2.setHeadless(remoteWebDriverConfig.getHeadless());
                    $this$invoke_u24lambda_u2d2.setPageLoadStrategy(PageLoadStrategy.NORMAL);
                    $this$invoke_u24lambda_u2d2.setAcceptInsecureCerts(true);
                    if (!StringsKt.isBlank((CharSequence)remoteWebDriverConfig.getProxy())) {
                        Uri url = Uri.create((String)remoteWebDriverConfig.getProxy());
                        $this$invoke_u24lambda_u2d2.addPreference("network.proxy.type", (Object)1);
                        $this$invoke_u24lambda_u2d2.addPreference("network.proxy.http", (Object)url.getHost());
                        $this$invoke_u24lambda_u2d2.addPreference("network.proxy.http_port", (Object)url.getPort());
                        $this$invoke_u24lambda_u2d2.addPreference("network.proxy.ssl", (Object)url.getHost());
                        $this$invoke_u24lambda_u2d2.addPreference("network.proxy.ssl_port", (Object)url.getPort());
                        $this$invoke_u24lambda_u2d2.addPreference("network.proxy.ftp", (Object)url.getHost());
                        $this$invoke_u24lambda_u2d2.addPreference("network.proxy.ftp_port", (Object)url.getPort());
                        $this$invoke_u24lambda_u2d2.addPreference("network.proxy.socks", (Object)url.getHost());
                        $this$invoke_u24lambda_u2d2.addPreference("network.proxy.socks_port", (Object)url.getPort());
                        $this$invoke_u24lambda_u2d2.addPreference("network.proxy.share_proxy_settings", (Object)true);
                    }
                    if (remoteWebDriverConfig.getHeadless()) {
                        $this$invoke_u24lambda_u2d2.addPreference("webgl.disabled", (Object)true);
                    }
                    $this$invoke_u24lambda_u2d2.addPreference("fission.bfcacheInParent", (Object)true);
                    $this$invoke_u24lambda_u2d2.addPreference("fission.webContentIsolationStrategy", (Object)0);
                    $this$invoke_u24lambda_u2d2.addPreference("general.useragent.override", (Object)remoteWebDriverConfig.getUserAgent());
                    Object object = new String[]{"--width=" + remoteWebDriverConfig.getWidth(), "--height=" + remoteWebDriverConfig.getHeight()};
                    $this$invoke_u24lambda_u2d2.addArguments((String[])object);
                    object = new String[]{"--hide-scrollbars"};
                    $this$invoke_u24lambda_u2d2.addArguments((String[])object);
                    $this$invoke_u24lambda_u2d2.addArguments(remoteWebDriverConfig.getArguments());
                    $this$invoke_u24lambda_u2d2.addPreference("browser.aboutConfig.showWarning", (Object)false);
                    $this$invoke_u24lambda_u2d2.addPreference("general.warnOnAboutConfig", (Object)false);
                    for (Map.Entry entry : remoteWebDriverConfig.getPreferences().entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        Object object3 = StringsKt.toBooleanStrictOrNull((String)value);
                        if (object3 == null && (object3 = StringsKt.toDoubleOrNull((String)value)) == null) {
                            object3 = value;
                        }
                        $this$invoke_u24lambda_u2d2.addPreference(key, object3);
                    }
                } else {
                    throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u8bbe\u7f6e\u53c2\u6570\u7684\u6d4f\u89c8\u5668 " + Reflection.getOrCreateKotlinClass(capabilities.getClass()));
                }
                capabilities2 = capabilities;
                this.$this_toConsumer.getCustom().invoke((Object)capabilities2);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<File> clearWebDriver() {
        void $this$filterTo$iv$iv;
        String string = System.getProperty(SELENIUM_DOWNLOAD_EXPIRES, "7");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(SELENIUM_DOWNLOAD_EXPIRES, \"7\")");
        long expires = Long.parseLong(string);
        File folder = new File(System.getProperty(SELENIUM_FOLDER, "."));
        long current = System.currentTimeMillis();
        File[] fileArray = folder.listFiles();
        if (fileArray == null) {
            return CollectionsKt.emptyList();
        }
        File[] $this$filter$iv = fileArray;
        boolean $i$f$filter = false;
        File[] fileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void file = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            if (!(file.isFile() && (current - file.lastModified()) / (long)86400000 > expires && file.delete())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final File sevenZA(@NotNull File folder) {
        File file;
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        File $this$sevenZA_u24lambda_u2d19 = file = FilesKt.resolve((File)folder, (String)"7za.exe");
        boolean bl = false;
        if (!$this$sevenZA_u24lambda_u2d19.exists()) {
            String base = System.getProperty(SEVEN7Z_MIRRORS, "https://www.7-zip.org/a");
            File pack = SeleniumInitKt.download$default(base + "/7za920.zip", folder, null, 4, null);
            Closeable closeable = new ZipFile(pack);
            Throwable throwable = null;
            try {
                ZipFile file2 = (ZipFile)closeable;
                boolean bl2 = false;
                ZipEntry entry = file2.getEntry("7za.exe");
                $this$sevenZA_u24lambda_u2d19.setLastModified(entry.getTime());
                byte[] byArray = file2.getInputStream(entry).readAllBytes();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"file.getInputStream(entry).readAllBytes()");
                FilesKt.writeBytes((File)$this$sevenZA_u24lambda_u2d19, (byte[])byArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            $this$sevenZA_u24lambda_u2d19.setExecutable(true);
        }
        return file;
    }

    @NotNull
    public static final File setupFirefox(@NotNull File folder, @NotNull String version) {
        File file;
        String latest;
        Object object;
        File setup2;
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        folder.mkdirs();
        Platform platform = Platform.getCurrent();
        if (platform.is(Platform.WINDOWS)) {
            File exe;
            File file2;
            setup2 = null;
            if (StringsKt.isBlank((CharSequence)version)) {
                object = SeleniumInitKt.download$default("https://download.mozilla.org/?product=firefox-latest-ssl&os=win64&lang=zh-CN", folder, null, 4, null);
                String[] $this$setupFirefox_u24lambda_u2d20 = object;
                boolean bl = false;
                String string = $this$setupFirefox_u24lambda_u2d20.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                latest = StringsKt.removeSuffix((String)StringsKt.substringAfterLast$default((String)string, (char)' ', null, (int)2, null), (CharSequence)".exe");
                setup2 = FilesKt.resolve((File)folder, (String)("Firefox-v" + latest + "-win"));
                file2 = object;
            } else {
                setup2 = FilesKt.resolve((File)folder, (String)("Firefox-v" + version + "-win"));
                file2 = exe = SeleniumInitKt.download("https://archive.mozilla.org/pub/firefox/releases/" + version + "/win64/zh-CN/Firefox Setup " + version + ".exe", folder, "Firefox Setup " + version + ".exe");
            }
            if (!setup2.exists()) {
                object = new String[]{SeleniumInitKt.sevenZA(folder).getAbsolutePath(), "x", exe.getAbsolutePath(), "-x!setup.exe", "-y"};
                Object $this$setupFirefox_u24lambda_u2d21 = object = new ProcessBuilder((String[])object).directory(folder).start();
                boolean bl = false;
                ((Process)$this$setupFirefox_u24lambda_u2d21).getInputStream().transferTo(AllIgnoredOutputStream.INSTANCE);
                ((Process)object).waitFor();
                if (!FilesKt.resolve((File)folder, (String)"core").renameTo(setup2)) {
                    boolean $i$a$-check-SeleniumInitKt$setupFirefox$binary$42 = false;
                    String $i$a$-check-SeleniumInitKt$setupFirefox$binary$42 = "\u91cd\u547d\u540d core \u5931\u8d25";
                    throw new IllegalStateException($i$a$-check-SeleniumInitKt$setupFirefox$binary$42.toString());
                }
            }
            file = FilesKt.resolve((File)setup2, (String)"firefox.exe");
        } else if (platform.is(Platform.LINUX)) {
            File bz2;
            File file3;
            setup2 = null;
            if (StringsKt.isBlank((CharSequence)version)) {
                object = SeleniumInitKt.download$default("https://download.mozilla.org/?product=firefox-latest-ssl&os=linux64&lang=zh-CN", folder, null, 4, null);
                String[] $this$setupFirefox_u24lambda_u2d23 = object;
                boolean bl = false;
                String string = $this$setupFirefox_u24lambda_u2d23.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                latest = StringsKt.removeSuffix((String)StringsKt.substringAfterLast$default((String)string, (char)'-', null, (int)2, null), (CharSequence)".tar.bz2");
                setup2 = FilesKt.resolve((File)folder, (String)("Firefox-v" + latest + "-linux"));
                file3 = object;
            } else {
                setup2 = FilesKt.resolve((File)folder, (String)("Firefox-v" + version + "-linux"));
                file3 = bz2 = SeleniumInitKt.download("https://archive.mozilla.org/pub/firefox/releases/" + version + "/linux-x86_64/zh-CN/firefox-" + version + ".tar.bz2", folder, "firefox-" + version + ".tar.bz2");
            }
            if (!setup2.exists()) {
                object = new String[]{"tar", "-xjf", bz2.getAbsolutePath()};
                new ProcessBuilder((String[])object).directory(folder).start().waitFor();
                if (!FilesKt.resolve((File)folder, (String)"firefox").renameTo(setup2)) {
                    boolean $i$a$-check-SeleniumInitKt$setupFirefox$binary$52 = false;
                    String $i$a$-check-SeleniumInitKt$setupFirefox$binary$52 = "\u91cd\u547d\u540d firefox \u5931\u8d25";
                    throw new IllegalStateException($i$a$-check-SeleniumInitKt$setupFirefox$binary$52.toString());
                }
            }
            file = FilesKt.resolve((File)setup2, (String)"firefox");
        } else if (platform.is(Platform.MAC)) {
            String[] dmg;
            String[] stringArray;
            setup2 = null;
            if (StringsKt.isBlank((CharSequence)version)) {
                object = SeleniumInitKt.download$default("https://download.mozilla.org/?product=firefox-latest-ssl&os=osx&lang=zh-CN", folder, null, 4, null);
                String[] $this$setupFirefox_u24lambda_u2d25 = object;
                boolean bl = false;
                String string = $this$setupFirefox_u24lambda_u2d25.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                latest = StringsKt.removeSuffix((String)StringsKt.substringAfterLast$default((String)string, (char)' ', null, (int)2, null), (CharSequence)".dmg");
                setup2 = FilesKt.resolve((File)folder, (String)("Firefox-v" + latest + "-mac"));
                stringArray = object;
            } else {
                setup2 = FilesKt.resolve((File)folder, (String)("Firefox-v" + version + "-mac"));
                stringArray = dmg = SeleniumInitKt.download("https://archive.mozilla.org/pub/firefox/releases/" + version + "/mac/zh-CN/Firefox " + version + ".dmg", folder, "Firefox " + version + ".dmg");
            }
            if (!setup2.exists()) {
                object = new String[]{"hdiutil", "attach", "-quiet", "-noautofsck", "-noautoopen", dmg.getAbsolutePath()};
                new ProcessBuilder((String[])object).directory(folder).start().waitFor();
                File volume = new File("/Volumes/Firefox");
                String[] stringArray2 = new String[]{"cp", "-a", volume.getAbsolutePath(), setup2.getAbsolutePath()};
                new ProcessBuilder(stringArray2).directory(volume).start().waitFor();
                stringArray2 = new String[]{"hdiutil", "detach", volume.getAbsolutePath()};
                new ProcessBuilder(stringArray2).directory(folder).start().waitFor();
            }
            file = FilesKt.resolve((File)setup2, (String)"Firefox.app/Contents/MacOS/firefox");
        } else {
            throw new UnsupportedOperationException("\u4e0d\u53d7\u652f\u6301\u7684\u5e73\u53f0 " + platform);
        }
        File binary = file;
        System.setProperty(FIREFOX_BROWSER_BINARY, binary.getAbsolutePath());
        return binary;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final File setupChromium(@NotNull File folder, @NotNull String version) {
        Object xz;
        File file;
        Object $i$f$first2;
        Object pack;
        String url;
        GitHubRelease.Asset asset;
        void $this$first$iv;
        File setup2;
        GitHubRelease release;
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        folder.mkdirs();
        Platform platform = Platform.getCurrent();
        if (platform.is(Platform.WINDOWS)) {
            release = SeleniumInitKt.setupChromium$release(version, folder, "macchrome", "winchrome");
            setup2 = FilesKt.resolve((File)folder, (String)("Chromium-" + release.getTagName()));
            if (!setup2.exists()) {
                Object element$iv2;
                block14: {
                    Iterable iterable = release.getAssets();
                    boolean $i$f$first2 = false;
                    for (Object element$iv2 : $this$first$iv) {
                        asset = (GitHubRelease.Asset)element$iv2;
                        boolean bl = false;
                        if (!StringsKt.endsWith$default((String)asset.getBrowserDownloadUrl(), (String)".7z", (boolean)false, (int)2, null)) continue;
                        break block14;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                url = ((GitHubRelease.Asset)element$iv2).getBrowserDownloadUrl();
                pack = SeleniumInitKt.download(url, folder, StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null));
                $i$f$first2 = new String[]{SeleniumInitKt.sevenZA(folder).getAbsolutePath(), "x", ((File)pack).getAbsolutePath(), "-y"};
                Object $this$setupChromium_u24lambda_u2d28 = $i$f$first2 = new ProcessBuilder((String[])$i$f$first2).directory(folder).start();
                boolean bl = false;
                ((Process)$this$setupChromium_u24lambda_u2d28).getInputStream().transferTo(AllIgnoredOutputStream.INSTANCE);
                ((Process)$i$f$first2).waitFor();
                if (!FilesKt.resolve((File)folder, (String)FilesKt.getNameWithoutExtension((File)pack)).renameTo(setup2)) {
                    boolean bl2 = false;
                    String string = "\u91cd\u547d\u540d " + FilesKt.getNameWithoutExtension((File)pack) + " \u5931\u8d25";
                    throw new IllegalStateException(string.toString());
                }
            }
            file = FilesKt.resolve((File)setup2, (String)"chrome.exe");
        } else if (platform.is(Platform.LINUX)) {
            release = SeleniumInitKt.setupChromium$release(version, folder, "macchrome", "linchrome");
            setup2 = FilesKt.resolve((File)folder, (String)("Chromium-" + release.getTagName()));
            if (!setup2.exists()) {
                Object element$iv3;
                block15: {
                    pack = release.getAssets();
                    boolean $i$f$first3 = false;
                    for (Object element$iv3 : $this$first$iv) {
                        asset = (GitHubRelease.Asset)element$iv3;
                        boolean bl = false;
                        if (!StringsKt.endsWith$default((String)asset.getBrowserDownloadUrl(), (String)".tar.xz", (boolean)false, (int)2, null)) continue;
                        break block15;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                url = ((GitHubRelease.Asset)element$iv3).getBrowserDownloadUrl();
                xz = SeleniumInitKt.download(url, folder, StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null));
                $i$f$first2 = new String[]{"tar", "-xf", ((File)xz).getAbsolutePath()};
                new ProcessBuilder((String[])$i$f$first2).directory(folder).start().waitFor();
                String string = ((File)xz).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"xz.name");
                String unpack = StringsKt.removeSuffix((String)string, (CharSequence)".tar.xz");
                if (!FilesKt.resolve((File)folder, (String)unpack).renameTo(setup2)) {
                    boolean $i$a$-check-SeleniumInitKt$setupChromium$binary$42 = false;
                    String $i$a$-check-SeleniumInitKt$setupChromium$binary$42 = "\u91cd\u547d\u540d " + unpack + " \u5931\u8d25";
                    throw new IllegalStateException($i$a$-check-SeleniumInitKt$setupChromium$binary$42.toString());
                }
            }
            file = FilesKt.resolve((File)setup2, (String)"chrome");
        } else if (platform.is(Platform.MAC)) {
            release = SeleniumInitKt.setupChromium$release(version, folder, "macchrome", "macstable");
            setup2 = FilesKt.resolve((File)folder, (String)("Chromium-" + release.getTagName()));
            if (!setup2.exists()) {
                Object element$iv4;
                block16: {
                    xz = release.getAssets();
                    boolean $i$f$first4 = false;
                    for (Object element$iv4 : $this$first$iv) {
                        asset = (GitHubRelease.Asset)element$iv4;
                        boolean bl = false;
                        if (!StringsKt.contains$default((CharSequence)asset.getBrowserDownloadUrl(), (CharSequence)"Chromium", (boolean)false, (int)2, null)) continue;
                        break block16;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                url = ((GitHubRelease.Asset)element$iv4).getBrowserDownloadUrl();
                File zip = SeleniumInitKt.download(url, folder, StringsKt.substringAfterLast$default((String)url, (char)'/', null, (int)2, null));
                setup2.mkdirs();
                String[] stringArray = new String[]{"unzip", "-o", "-q", zip.getAbsolutePath()};
                new ProcessBuilder(stringArray).directory(setup2).start().waitFor();
            }
            file = FilesKt.resolve((File)setup2, (String)"Chromium.app/Contents/MacOS/Chromium");
        } else {
            throw new UnsupportedOperationException("\u4e0d\u53d7\u652f\u6301\u7684\u5e73\u53f0 " + platform);
        }
        File binary = file;
        System.setProperty(CHROME_BROWSER_BINARY, binary.getAbsolutePath());
        return binary;
    }

    private static final GitHubRelease setupChromium$release(String $version, File $folder, String owner, String repo) {
        GitHubRelease gitHubRelease;
        if (!StringsKt.isBlank((CharSequence)$version)) {
            GitHubRelease gitHubRelease2;
            int page = 0;
            GitHubRelease release = null;
            do {
                Object v0;
                block5: {
                    List releases;
                    if ((releases = (List)IgnoreJson.decodeFromString((DeserializationStrategy)BuiltinSerializersKt.ListSerializer(GitHubRelease.Companion.serializer()), FilesKt.readText$default((File)SeleniumInitKt.download$default("https://api.github.com/repos/" + owner + '/' + repo + "/releases?page=" + page++, $folder, null, 4, null), null, (int)1, null))).isEmpty()) {
                        throw new IllegalArgumentException("Chromium Version: " + $version + " \u67e5\u627e\u5931\u8d25");
                    }
                    Iterable iterable = releases;
                    for (Object t : iterable) {
                        GitHubRelease it = (GitHubRelease)t;
                        boolean bl = false;
                        if (!StringsKt.contains$default((CharSequence)it.getTagName(), (CharSequence)$version, (boolean)false, (int)2, null)) continue;
                        v0 = t;
                        break block5;
                    }
                    v0 = null;
                }
                gitHubRelease2 = v0;
            } while (gitHubRelease2 == null);
            release = gitHubRelease2;
            gitHubRelease = release;
        } else {
            gitHubRelease = (GitHubRelease)IgnoreJson.decodeFromString((DeserializationStrategy)GitHubRelease.Companion.serializer(), FilesKt.readText$default((File)SeleniumInitKt.download$default("https://api.github.com/repos/" + owner + '/' + repo + "/releases/latest", $folder, null, 4, null), null, (int)1, null));
        }
        return gitHubRelease;
    }
}

