/*
 * Decompiled with CFR 0.152.
 */
package xyz.cssxsh.baidu.disk;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.cssxsh.baidu.api.TimestampSerializer;
import xyz.cssxsh.baidu.disk.NetDiskUtilsKt;
import xyz.cssxsh.baidu.disk.RapidUploadInfo$;

@Serializable
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\b\u0018\u0000 72\u00020\u0001:\u000267B_\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0001\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\n\b\u0001\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0001\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fB=\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0010J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\bH\u00c6\u0003J\t\u0010$\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003JI\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010+\u001a\u00020\u00052\b\b\u0002\u0010,\u001a\u00020)J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001J\t\u0010.\u001a\u00020\u0005H\u00d6\u0001J!\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u00c7\u0001R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0018\u0010\u0012\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001b\u0010\u0012\u001a\u0004\b\u001c\u0010\u0017R\u001c\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u0012\u001a\u0004\b\u001e\u0010\u0014R\u001c\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001f\u0010\u0012\u001a\u0004\b \u0010\u0014\u00a8\u00068"}, d2={"Lxyz/cssxsh/baidu/disk/RapidUploadInfo;", "", "seen1", "", "content", "", "slice", "length", "", "path", "created", "Ljava/time/OffsetDateTime;", "modified", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;JLjava/lang/String;Ljava/time/OffsetDateTime;Ljava/time/OffsetDateTime;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;Ljava/time/OffsetDateTime;Ljava/time/OffsetDateTime;)V", "getContent$annotations", "()V", "getContent", "()Ljava/lang/String;", "getCreated$annotations", "getCreated", "()Ljava/time/OffsetDateTime;", "getLength$annotations", "getLength", "()J", "getModified$annotations", "getModified", "getPath$annotations", "getPath", "getSlice$annotations", "getSlice", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "format", "encrypt", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "$serializer", "Companion", "baidu-netdisk"})
public final class RapidUploadInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String content;
    @NotNull
    private final String slice;
    private final long length;
    @NotNull
    private final String path;
    @Nullable
    private final OffsetDateTime created;
    @Nullable
    private final OffsetDateTime modified;

    public RapidUploadInfo(@NotNull String content, @NotNull String slice, long length, @NotNull String path, @Nullable OffsetDateTime created, @Nullable OffsetDateTime modified) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.content = content;
        this.slice = slice;
        this.length = length;
        this.path = path;
        this.created = created;
        this.modified = modified;
    }

    public /* synthetic */ RapidUploadInfo(String string, String string2, long l, String string3, OffsetDateTime offsetDateTime, OffsetDateTime offsetDateTime2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            offsetDateTime = null;
        }
        if ((n & 0x20) != 0) {
            offsetDateTime2 = null;
        }
        this(string, string2, l, string3, offsetDateTime, offsetDateTime2);
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @SerialName(value="content")
    public static /* synthetic */ void getContent$annotations() {
    }

    @NotNull
    public final String getSlice() {
        return this.slice;
    }

    @SerialName(value="slice")
    public static /* synthetic */ void getSlice$annotations() {
    }

    public final long getLength() {
        return this.length;
    }

    @SerialName(value="length")
    public static /* synthetic */ void getLength$annotations() {
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @SerialName(value="path")
    public static /* synthetic */ void getPath$annotations() {
    }

    @Nullable
    public final OffsetDateTime getCreated() {
        return this.created;
    }

    @SerialName(value="local_ctime")
    @Serializable(with=TimestampSerializer.class)
    public static /* synthetic */ void getCreated$annotations() {
    }

    @Nullable
    public final OffsetDateTime getModified() {
        return this.modified;
    }

    @SerialName(value="local_mtime")
    @Serializable(with=TimestampSerializer.class)
    public static /* synthetic */ void getModified$annotations() {
    }

    @NotNull
    public final String format(boolean encrypt) {
        return encrypt ? NetDiskUtilsKt.encryptMD5(this.content) + "#" + NetDiskUtilsKt.encryptMD5(this.slice) + "#" + this.length + "#" + this.path : this.content + "#" + this.slice + "#" + this.length + "#" + this.path;
    }

    public static /* synthetic */ String format$default(RapidUploadInfo rapidUploadInfo, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return rapidUploadInfo.format(bl);
    }

    @NotNull
    public final String component1() {
        return this.content;
    }

    @NotNull
    public final String component2() {
        return this.slice;
    }

    public final long component3() {
        return this.length;
    }

    @NotNull
    public final String component4() {
        return this.path;
    }

    @Nullable
    public final OffsetDateTime component5() {
        return this.created;
    }

    @Nullable
    public final OffsetDateTime component6() {
        return this.modified;
    }

    @NotNull
    public final RapidUploadInfo copy(@NotNull String content, @NotNull String slice, long length, @NotNull String path, @Nullable OffsetDateTime created, @Nullable OffsetDateTime modified) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new RapidUploadInfo(content, slice, length, path, created, modified);
    }

    public static /* synthetic */ RapidUploadInfo copy$default(RapidUploadInfo rapidUploadInfo, String string, String string2, long l, String string3, OffsetDateTime offsetDateTime, OffsetDateTime offsetDateTime2, int n, Object object) {
        if ((n & 1) != 0) {
            string = rapidUploadInfo.content;
        }
        if ((n & 2) != 0) {
            string2 = rapidUploadInfo.slice;
        }
        if ((n & 4) != 0) {
            l = rapidUploadInfo.length;
        }
        if ((n & 8) != 0) {
            string3 = rapidUploadInfo.path;
        }
        if ((n & 0x10) != 0) {
            offsetDateTime = rapidUploadInfo.created;
        }
        if ((n & 0x20) != 0) {
            offsetDateTime2 = rapidUploadInfo.modified;
        }
        return rapidUploadInfo.copy(string, string2, l, string3, offsetDateTime, offsetDateTime2);
    }

    @NotNull
    public String toString() {
        return "RapidUploadInfo(content=" + this.content + ", slice=" + this.slice + ", length=" + this.length + ", path=" + this.path + ", created=" + this.created + ", modified=" + this.modified + ")";
    }

    public int hashCode() {
        int result = this.content.hashCode();
        result = result * 31 + this.slice.hashCode();
        result = result * 31 + Long.hashCode(this.length);
        result = result * 31 + this.path.hashCode();
        result = result * 31 + (this.created == null ? 0 : this.created.hashCode());
        result = result * 31 + (this.modified == null ? 0 : this.modified.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RapidUploadInfo)) {
            return false;
        }
        RapidUploadInfo rapidUploadInfo = (RapidUploadInfo)other;
        if (!Intrinsics.areEqual((Object)this.content, (Object)rapidUploadInfo.content)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.slice, (Object)rapidUploadInfo.slice)) {
            return false;
        }
        if (this.length != rapidUploadInfo.length) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)rapidUploadInfo.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.created, (Object)rapidUploadInfo.created)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.modified, (Object)rapidUploadInfo.modified);
    }

    @JvmStatic
    public static final void write$Self(@NotNull RapidUploadInfo self, @NotNull CompositeEncoder output, @NotNull SerialDescriptor serialDesc) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)serialDesc, (String)"serialDesc");
        output.encodeStringElement(serialDesc, 0, self.content);
        output.encodeStringElement(serialDesc, 1, self.slice);
        output.encodeLongElement(serialDesc, 2, self.length);
        output.encodeStringElement(serialDesc, 3, self.path);
        if (output.shouldEncodeElementDefault(serialDesc, 4) ? true : self.created != null) {
            output.encodeNullableSerializableElement(serialDesc, 4, (SerializationStrategy)TimestampSerializer.INSTANCE, (Object)self.created);
        }
        if (output.shouldEncodeElementDefault(serialDesc, 5) ? true : self.modified != null) {
            output.encodeNullableSerializableElement(serialDesc, 5, (SerializationStrategy)TimestampSerializer.INSTANCE, (Object)self.modified);
        }
    }

    @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
    public /* synthetic */ RapidUploadInfo(int seen1, @SerialName(value="content") String content, @SerialName(value="slice") String slice, @SerialName(value="length") long length, @SerialName(value="path") String path, @SerialName(value="local_ctime") @Serializable(with=TimestampSerializer.class) OffsetDateTime created, @SerialName(value="local_mtime") @Serializable(with=TimestampSerializer.class) OffsetDateTime modified, SerializationConstructorMarker serializationConstructorMarker) {
        if (15 != (0xF & seen1)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)15, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.content = content;
        this.slice = slice;
        this.length = length;
        this.path = path;
        this.created = (seen1 & 0x10) == 0 ? null : created;
        this.modified = (seen1 & 0x20) == 0 ? null : modified;
    }

    @JvmStatic
    @NotNull
    public static final RapidUploadInfo parse(@NotNull String code) {
        return Companion.parse(code);
    }

    @JvmStatic
    @NotNull
    public static final RapidUploadInfo calculate(@NotNull File file) {
        return Companion.calculate(file);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u00c6\u0001\u00a8\u0006\f"}, d2={"Lxyz/cssxsh/baidu/disk/RapidUploadInfo$Companion;", "", "()V", "calculate", "Lxyz/cssxsh/baidu/disk/RapidUploadInfo;", "file", "Ljava/io/File;", "parse", "code", "", "serializer", "Lkotlinx/serialization/KSerializer;", "baidu-netdisk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final RapidUploadInfo parse(@NotNull String code) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            char[] cArray = new char[]{'#'};
            List list2 = StringsKt.split$default((CharSequence)code, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean bl = false;
            String content = (String)list2.get(0);
            String slice = (String)list2.get(1);
            String length = (String)list2.get(2);
            String path = (String)list2.get(3);
            return new RapidUploadInfo(content, slice, Long.parseLong(length), path, null, null, 48, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final RapidUploadInfo calculate(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            MessageDigest digest = MessageDigest.getInstance("md5");
            byte[] buffer = new byte[262144];
            Closeable closeable = new FileInputStream(file);
            Throwable throwable = null;
            try {
                FileInputStream input = (FileInputStream)closeable;
                boolean bl = false;
                int size2 = input.read(buffer);
                digest.update(buffer, 0, size2);
                byte[] slice = digest.digest();
                digest.update(buffer, 0, size2);
                while ((size2 = input.read(buffer)) > 0) {
                    digest.update(buffer, 0, size2);
                }
                byte[] byArray = digest.digest();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest.digest()");
                String string = NetDiskUtilsKt.toHexString(byArray);
                Intrinsics.checkNotNullExpressionValue((Object)slice, (String)"slice");
                input = TuplesKt.to((Object)string, (Object)NetDiskUtilsKt.toHexString(slice));
            }
            catch (Throwable input) {
                throwable = input;
                throw input;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            FileInputStream fileInputStream = input;
            String content = (String)fileInputStream.component1();
            String slice = (String)fileInputStream.component2();
            OffsetDateTime modified = OffsetDateTime.ofInstant(Instant.ofEpochSecond(file.lastModified()), ZoneId.systemDefault());
            long l = file.length();
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            return new RapidUploadInfo(content, slice, l, string, modified, modified);
        }

        @NotNull
        public final KSerializer<RapidUploadInfo> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

