/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.tparse;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import xyz.cofe.text.tparse.GR;
import xyz.cofe.text.tparse.Pointer;
import xyz.cofe.text.tparse.RptOP;
import xyz.cofe.text.tparse.Tok;

public class RptOPImpl<P extends Pointer<?, ?, P>, T extends Tok<P>>
implements RptOP<P, T> {
    private final GR<P, T> gr;
    private final int min;
    private final int max;
    private final boolean greedly;

    public RptOPImpl(GR<P, T> gr, int min, int max, boolean greedly) {
        if (gr == null) {
            throw new IllegalArgumentException("gr==null");
        }
        if (min > max) {
            throw new IllegalArgumentException("min>max");
        }
        this.gr = gr;
        this.min = min;
        this.max = max;
        this.greedly = greedly;
    }

    @Override
    public GR<P, T> expression() {
        return this.gr;
    }

    @Override
    public int min() {
        return this.min;
    }

    @Override
    public RptOP<P, T> min(int n) {
        return new RptOPImpl<P, T>(this.gr, n, this.max, this.greedly);
    }

    @Override
    public int max() {
        return this.max;
    }

    @Override
    public RptOP<P, T> max(int n) {
        return new RptOPImpl<P, T>(this.gr, this.min, n, this.greedly);
    }

    @Override
    public boolean greedly() {
        return this.greedly;
    }

    @Override
    public RptOP<P, T> greedly(boolean b) {
        return new RptOPImpl<P, T>(this.gr, this.min, this.max, b);
    }

    @Override
    public <U extends Tok<P>> GR<P, U> map(final Function<List<T>, U> map) {
        if (map == null) {
            throw new IllegalArgumentException("map==null");
        }
        return new GR<P, U>(){

            @Override
            public Optional<U> apply(P ptr) {
                if (ptr == null) {
                    throw new IllegalArgumentException("ptr==null");
                }
                if (ptr.eof()) {
                    return Optional.empty();
                }
                ArrayList<Tok> matched = new ArrayList<Tok>();
                while (!ptr.eof()) {
                    Optional tokOpt = (Optional)RptOPImpl.this.gr.apply(ptr);
                    if (tokOpt == null) {
                        throw new IllegalStateException("bug!");
                    }
                    if (!tokOpt.isPresent()) break;
                    Tok tok = (Tok)tokOpt.get();
                    if (tok == null) {
                        throw new IllegalStateException("bug");
                    }
                    if (tok.end() == null) {
                        throw new IllegalStateException("bug");
                    }
                    Object next = tok.end();
                    if (next == null) {
                        throw new IllegalStateException("bug");
                    }
                    if (ptr.compareTo(next) >= 0) {
                        throw new IllegalStateException("bug");
                    }
                    matched.add(tok);
                    if (!RptOPImpl.this.greedly && matched.size() >= RptOPImpl.this.min || RptOPImpl.this.max > 0 && matched.size() >= RptOPImpl.this.max) break;
                    ptr = next;
                }
                if (RptOPImpl.this.max > 0 && matched.size() > RptOPImpl.this.max) {
                    int dropSize = matched.size() - RptOPImpl.this.max;
                    for (int i = 0; i < dropSize; ++i) {
                        matched.remove(matched.size() - 1);
                    }
                }
                if (matched.isEmpty()) {
                    return Optional.empty();
                }
                if (RptOPImpl.this.min > 0 && matched.size() < RptOPImpl.this.min) {
                    return Optional.empty();
                }
                Tok result = (Tok)map.apply(matched);
                if (result == null) {
                    throw new IllegalStateException("bug");
                }
                return Optional.of(result);
            }
        };
    }
}

