/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parse;

import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import xyz.cofe.text.parse.CharPointer;
import xyz.cofe.text.parse.Token;
import xyz.cofe.text.parse.tmpl.Template;

public enum CharType implements Function<CharPointer, Token>
{
    UNDEFINED(x -> false),
    DIGIT_DOT(c -> c.charValue() == '.'),
    Whitespace(Character::isWhitespace, "Character.isWhitespace( ${ptr}.lookup() ) ? new " + Token.class.getName() + "( ${ptr}, ${ptr}.move(1) )"),
    Digit(Character::isDigit, "Character.isDigit( ${ptr}.lookup() ) ? new " + Token.class.getName() + "( ${ptr}, ${ptr}.move(1) )"),
    Letter(Character::isLetter, "Character.isLetter( ${ptr}.lookup() ) ? new " + Token.class.getName() + "( ${ptr}, ${ptr}.move(1) )"),
    LetterOrDigit(Character::isLetterOrDigit, "Character.isLetterOrDigit( ${ptr}.lookup() ) ? new " + Token.class.getName() + "( ${ptr}, ${ptr}.move(1) )"),
    Alphabetic(Character::isAlphabetic, "Character.isAlphabetic( ${ptr}.lookup() ) ? new " + Token.class.getName() + "( ${ptr}, ${ptr}.move(1) )"),
    BmpCodePoint(Character::isBmpCodePoint),
    Defined(Character::isDefined),
    HighSurrogate(Character::isHighSurrogate),
    IdentifierIgnorable(Character::isIdentifierIgnorable),
    Ideographic(Character::isIdeographic),
    ISOControl(Character::isISOControl),
    JavaIdentifierPart(Character::isJavaIdentifierPart),
    JavaIdentifierStart(Character::isJavaIdentifierStart),
    LowerCase(Character::isLowerCase),
    LowSurrogate(Character::isLowSurrogate),
    Mirrored(Character::isMirrored),
    TitleCase(Character::isTitleCase),
    SpaceChar(Character::isSpaceChar),
    SupplementaryCodePoint(Character::isSupplementaryCodePoint),
    UnicodeIdentifierPart(Character::isUnicodeIdentifierPart),
    UnicodeIdentifierStart(Character::isUnicodeIdentifierStart),
    UpperCase(Character::isUpperCase),
    ValidCodePoint(Character::isValidCodePoint),
    Surrogate(Character::isSurrogate);

    private Predicate<Character> testfn;
    private final Template template;

    private CharType(Predicate<Character> testfn) {
        if (testfn == null) {
            throw new IllegalArgumentException("testfn==null");
        }
        this.testfn = testfn;
        this.template = null;
    }

    private CharType(Predicate<Character> testfn, String template) {
        if (testfn == null) {
            throw new IllegalArgumentException("testfn==null");
        }
        this.testfn = testfn;
        this.template = template != null ? Template.parse(template) : null;
    }

    public boolean test(Character c) {
        if (c == null) {
            c = Character.valueOf('\u0000');
        }
        return this.testfn.test(c);
    }

    public boolean test(char c) {
        return this.testfn.test(Character.valueOf(c));
    }

    public boolean test(int c) {
        return this.test((char)c);
    }

    @Override
    public Token apply(CharPointer tp) {
        if (tp == null) {
            return null;
        }
        if (tp.eof()) {
            return null;
        }
        if (this.test((Character)tp.lookup())) {
            return new Token(tp, (CharPointer)tp.move(1));
        }
        return null;
    }

    public String exprTemplate(String textPointerVarName) {
        if (textPointerVarName == null) {
            throw new IllegalArgumentException("textPointerVarName==null");
        }
        if (this.template == null) {
            return null;
        }
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("ptr", textPointerVarName);
        return this.template.apply(m);
    }
}

