/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.xml.stream.path;

import java.util.List;
import xyz.cofe.collection.Pointer;
import xyz.cofe.common.Reciver;
import xyz.cofe.text.parser.LexerUtil;
import xyz.cofe.text.parser.ListLexer;
import xyz.cofe.text.parser.Token;
import xyz.cofe.text.parser.lex.Keyword;
import xyz.cofe.text.parser.lex.Keywords;
import xyz.cofe.text.parser.lex.KeywordsParser;
import xyz.cofe.text.parser.lex.TagName;
import xyz.cofe.text.parser.lex.TagNameParser;
import xyz.cofe.text.parser.lex.WhiteSpace;
import xyz.cofe.text.parser.lex.WhiteSpaceParser;
import xyz.cofe.xml.stream.path.Expressions;
import xyz.cofe.xml.stream.path.PathExpression;

public class PathParser {
    public PathExpression parse(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        List<Token> toks = this.lexParse(text);
        Pointer ptr = new Pointer(toks);
        return this.parsePath((Pointer<Token>)ptr);
    }

    protected PathExpression parsePath(Pointer<Token> ptr) {
        Keyword k;
        PathExpression e = null;
        Token t = null;
        t = (Token)ptr.lookup(0);
        if (t == null) {
            return null;
        }
        if (t instanceof Keyword) {
            Keyword k2 = (Keyword)t;
            if (k2.getKeyword().equals("/")) {
                e = Expressions.rootPath();
                ptr.move(1);
            } else {
                return null;
            }
        }
        if (!((t = (Token)ptr.lookup(0)) instanceof TagName)) {
            return e;
        }
        TagName tn = (TagName)t;
        ptr.move(1);
        e = e == null ? Expressions.tagNameEquals(tn.getLocalName()) : Expressions.andPath(Expressions.parentPath(e), Expressions.tagNameEquals(tn.getLocalName()));
        while ((t = (Token)ptr.lookup(0)) instanceof Keyword && (k = (Keyword)t).getId().equals("op") && (t = (Token)ptr.lookup(1)) instanceof TagName) {
            tn = (TagName)t;
            ptr.move(2);
            e = Expressions.andPath(Expressions.parentPath(e), Expressions.tagNameEquals(tn.getLocalName()));
        }
        return e;
    }

    protected ListLexer createLexer() {
        ListLexer ll = new ListLexer();
        KeywordsParser kw = new KeywordsParser("op");
        kw.setKeywords(new Keywords(false).put("/"));
        ll.getParsers().add(kw);
        TagNameParser tn = new TagNameParser("tag");
        ll.getParsers().add(tn);
        WhiteSpaceParser ws = new WhiteSpaceParser("ws");
        ll.getParsers().add(ws);
        return ll;
    }

    protected List<Token> lexParse(String text) {
        ListLexer ll = this.createLexer();
        List toks = ll.parse(text, (Reciver)new Reciver<String>(){

            public void recive(String obj) {
                System.out.println("lexer error " + obj);
            }
        });
        toks = LexerUtil.filter((List)toks, (Class[])new Class[]{WhiteSpace.class});
        return toks;
    }
}

