/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.xml;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import xyz.cofe.collection.Func0;
import xyz.cofe.common.LazyValue;
import xyz.cofe.text.template.BasicTemplate;
import xyz.cofe.xml.XMLUtil;

public class XmlContext {
    protected final Lock lock = new ReentrantLock();
    private boolean useJavaScript = false;
    private boolean useLasyValue = true;
    private boolean useFunc0 = true;
    private Map<XPathExpression, Object> contexts;
    private XPath xpath;
    private WeakHashMap<String, BasicTemplate> cacheBasicTemplate;

    public XmlContext() {
    }

    public XmlContext(XmlContext src) {
        if (src != null) {
            this.useJavaScript = src.useJavaScript;
            this.useLasyValue = src.useLasyValue;
            if (src.contexts != null) {
                this.getContexts().putAll(src.contexts);
            }
        }
    }

    public XmlContext clone() {
        return new XmlContext(this);
    }

    public boolean isUseJavaScript() {
        try {
            this.lock.lock();
            boolean bl = this.useJavaScript;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUseJavaScript(boolean useJavaScript) {
        try {
            this.lock.lock();
            this.useJavaScript = useJavaScript;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean isUseLasyValue() {
        try {
            this.lock.lock();
            boolean bl = this.useLasyValue;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setUseLasyValue(boolean useLasyValue) {
        try {
            this.lock.lock();
            this.useLasyValue = useLasyValue;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean isFunc0() {
        try {
            this.lock.lock();
            boolean bl = this.useFunc0;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void setFunc0(boolean useFunc0) {
        try {
            this.lock.lock();
            this.useFunc0 = useFunc0;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Map<XPathExpression, Object> getContexts() {
        try {
            this.lock.lock();
            if (this.contexts != null) {
                Map<XPathExpression, Object> map = this.contexts;
                return map;
            }
            this.contexts = new LinkedHashMap<XPathExpression, Object>();
            Map<XPathExpression, Object> map = this.contexts = Collections.synchronizedMap(this.contexts);
            return map;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setContexts(Map<XPathExpression, Object> contexts) {
        try {
            this.lock.lock();
            this.contexts = contexts;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clear() {
        this.getContexts().clear();
    }

    public void put(XPathExpression expr, Object context) {
        if (expr == null) {
            throw new IllegalArgumentException("expr==null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context==null");
        }
        this.getContexts().put(expr, context);
    }

    private XPath getXPath() {
        try {
            this.lock.lock();
            if (this.xpath != null) {
                XPath xPath = this.xpath;
                return xPath;
            }
            XPath xPath = this.xpath = XPathFactory.newInstance().newXPath();
            return xPath;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String xpathExpression, Object context) {
        if (xpathExpression == null) {
            throw new IllegalArgumentException("xpathExpression==null");
        }
        if (context == null) {
            throw new IllegalArgumentException("context==null");
        }
        try {
            this.lock.lock();
            XPath xpath = this.getXPath();
            try {
                XPathExpression xexpr = xpath.compile(xpathExpression);
                this.put(xexpr, context);
            }
            catch (XPathExpressionException ex) {
                Logger.getLogger(XmlContext.class.getName()).log(Level.SEVERE, null, ex);
                throw new Error(ex.getMessage(), ex);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eval(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("node==null");
        }
        try {
            this.lock.lock();
            Map<XPathExpression, Object> ctxs = this.getContexts();
            if (ctxs == null) {
                return;
            }
            Map<XPathExpression, Object> map = ctxs;
            synchronized (map) {
                this.eval0(node, ctxs);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void eval0(Node node, Map<XPathExpression, Object> ctxs) {
        for (Map.Entry<XPathExpression, Object> en : ctxs.entrySet()) {
            XPathExpression exp = en.getKey();
            if (exp == null) continue;
            Object ctx = en.getValue();
            if (this.useLasyValue && ctx instanceof LazyValue) {
                ctx = ((LazyValue)ctx).evaluate();
            } else if (this.useFunc0 && ctx instanceof Func0) {
                ctx = ((Func0)ctx).apply();
            }
            if (ctx == null) continue;
            this.eval(node, exp, ctx);
        }
    }

    private void eval(Node node, XPathExpression expr, Object ctx) {
        try {
            NodeList nodes = (NodeList)expr.evaluate(node, XPathConstants.NODESET);
            for (Node n : XMLUtil.xmlNodes(nodes)) {
                this.apply(n, ctx);
            }
        }
        catch (XPathExpressionException ex) {
            Logger.getLogger(XmlContext.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void apply(Node node, Object ctx) {
        if (node instanceof Text) {
            this.applyText((Text)node, ctx);
        } else if (node instanceof Attr) {
            this.applyAttr((Attr)node, ctx);
        }
    }

    private BasicTemplate getBasicTemplate(String templateText) {
        BasicTemplate bt;
        if (templateText == null) {
            throw new IllegalArgumentException("templateText==null");
        }
        if (this.cacheBasicTemplate == null) {
            this.cacheBasicTemplate = new WeakHashMap();
        }
        if ((bt = this.cacheBasicTemplate.get(templateText)) != null) {
            return bt;
        }
        bt = new BasicTemplate(templateText);
        this.cacheBasicTemplate.put(templateText, bt);
        return bt;
    }

    private void applyText(Text textNode, Object ctx) {
        BasicTemplate.Context ctxTemplate;
        String res;
        String txt;
        if (ctx instanceof ApplyText) {
            ((ApplyText)ctx).applyText(textNode);
            if (ctx instanceof ApplyContinue) {
                if (!((ApplyContinue)ctx).isContinue()) {
                    return;
                }
            } else {
                return;
            }
        }
        if ((txt = textNode.getTextContent()) == null || txt.length() == 0) {
            return;
        }
        BasicTemplate tmpl = this.getBasicTemplate(txt);
        BasicTemplate.ContextBuilder ctxb = tmpl.context(ctx.getClass());
        if (this.isUseJavaScript()) {
            ctxb.useJavaScript();
        }
        if ((res = (ctxTemplate = ctxb.build()).eval(ctx)) != null) {
            textNode.setTextContent(res);
        }
    }

    private void applyAttr(Attr attrNode, Object ctx) {
        BasicTemplate.Context ctxTemplate;
        String res;
        String txt;
        if (ctx instanceof ApplyAttr) {
            ((ApplyAttr)ctx).applyAttr(attrNode);
            if (ctx instanceof ApplyContinue) {
                if (!((ApplyContinue)ctx).isContinue()) {
                    return;
                }
            } else {
                return;
            }
        }
        if ((txt = attrNode.getValue()) == null || txt.length() == 0) {
            return;
        }
        BasicTemplate tmpl = this.getBasicTemplate(txt);
        BasicTemplate.ContextBuilder ctxb = tmpl.context(ctx.getClass());
        if (this.isUseJavaScript()) {
            ctxb.useJavaScript();
        }
        if ((res = (ctxTemplate = ctxb.build()).eval(ctx)) != null) {
            attrNode.setValue(res);
        }
    }

    public static interface ApplyContinue {
        public boolean isContinue();
    }

    public static interface ApplyAttr {
        public void applyAttr(Attr var1);
    }

    public static interface ApplyText {
        public void applyText(Text var1);
    }
}

