/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.sec;

public class TypeDesc {
    public static final TypeDesc undefined = new TypeDesc("?", 0);
    public final String name;
    public final int dimension;
    public final boolean array;

    public TypeDesc(String name, int dimension) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        if (dimension < 0) {
            throw new IllegalArgumentException("dimension<0");
        }
        this.name = name;
        this.dimension = dimension;
        this.array = dimension > 0;
    }

    public TypeDesc(String name) {
        this(name, 0);
    }

    public static Parse parse(String raw, int from) {
        if (raw == null) {
            throw new IllegalArgumentException("raw==null");
        }
        if (from < 0) {
            throw new IllegalArgumentException("from<0");
        }
        if (from >= raw.length()) {
            throw new IllegalArgumentException("from>=raw.length()");
        }
        int ptr = from - 1;
        int arr = 0;
        String type = null;
        int state = 0;
        StringBuilder typeName = new StringBuilder();
        while (ptr < raw.length() - 1 && type == null) {
            char c = raw.charAt(++ptr);
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case '[': {
                            ++arr;
                            break;
                        }
                        case 'Z': {
                            type = Boolean.TYPE.getName();
                            break;
                        }
                        case 'C': {
                            type = Character.TYPE.getName();
                            break;
                        }
                        case 'B': {
                            type = Byte.TYPE.getName();
                            break;
                        }
                        case 'S': {
                            type = Short.TYPE.getName();
                            break;
                        }
                        case 'I': {
                            type = Integer.TYPE.getName();
                            break;
                        }
                        case 'F': {
                            type = Float.TYPE.getName();
                            break;
                        }
                        case 'J': {
                            type = Long.TYPE.getName();
                            break;
                        }
                        case 'D': {
                            type = Double.TYPE.getName();
                            break;
                        }
                        case 'V': {
                            type = Void.TYPE.getName();
                            break;
                        }
                        case 'L': {
                            state = 1;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case ';': {
                            type = typeName.toString();
                            break block0;
                        }
                        case '.': 
                        case '/': {
                            typeName.append(".");
                            break block0;
                        }
                    }
                    typeName.append(c);
                }
            }
        }
        if (type == null) {
            throw new Error("can't parse for \"" + raw + "\", from=" + from);
        }
        return new Parse(new TypeDesc(type, arr), from, ptr + 1);
    }

    public static TypeDesc parse(String raw) {
        if (raw == null) {
            throw new IllegalArgumentException("raw==null");
        }
        return TypeDesc.parse((String)raw, (int)0).type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.dimension > 0) {
            for (int d = 0; d < this.dimension; ++d) {
                sb.append("[]");
            }
        }
        return sb.toString();
    }

    public static class Parse {
        public final TypeDesc type;
        public final int from;
        public final int to;

        public Parse(TypeDesc type, int from, int to) {
            this.type = type;
            this.from = from;
            this.to = to;
        }
    }
}

