/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.mth;

import org.objectweb.asm.MethodVisitor;
import xyz.cofe.trambda.bc.ByteCode;
import xyz.cofe.trambda.bc.mth.MAbstractBC;
import xyz.cofe.trambda.bc.mth.MethodWriter;
import xyz.cofe.trambda.bc.mth.MethodWriterCtx;
import xyz.cofe.trambda.bc.mth.OpCode;

public class MVarInsn
extends MAbstractBC
implements ByteCode,
MethodWriter {
    private static final long serialVersionUID = 1L;
    private int opcode;
    private int variable;

    public MVarInsn() {
    }

    public MVarInsn(int op, int vi) {
        this.opcode = op;
        this.variable = vi;
    }

    public MVarInsn(MVarInsn sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.opcode = sample.opcode;
        this.variable = sample.variable;
    }

    @Override
    public MVarInsn clone() {
        return new MVarInsn(this);
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void setOpcode(int opcode) {
        this.opcode = opcode;
    }

    public int getVariable() {
        return this.variable;
    }

    public void setVariable(int variable) {
        this.variable = variable;
    }

    public String toString() {
        return MVarInsn.class.getSimpleName() + " opcode=" + OpCode.code(this.opcode).map(Enum::name).orElse("?") + "#" + this.opcode + " variable=" + this.variable;
    }

    @Override
    public void write(MethodVisitor v, MethodWriterCtx ctx) {
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        v.visitVarInsn(this.getOpcode(), this.getVariable());
    }
}

