/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.mth;

import org.objectweb.asm.MethodVisitor;
import xyz.cofe.trambda.bc.mth.MAbstractBC;
import xyz.cofe.trambda.bc.mth.MethodWriter;
import xyz.cofe.trambda.bc.mth.MethodWriterCtx;
import xyz.cofe.trambda.bc.mth.OpCode;

public class MMethodInsn
extends MAbstractBC
implements MethodWriter {
    private static final long serialVersionUID = 1L;
    private int opcode;
    private String owner;
    private String name;
    private String descriptor;
    private boolean iface;

    public MMethodInsn() {
    }

    public MMethodInsn(int op, String owner, String name, String descriptor, boolean iface) {
        this.opcode = op;
        this.owner = owner;
        this.name = name;
        this.descriptor = descriptor;
        this.iface = iface;
    }

    public MMethodInsn(MMethodInsn sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.opcode = sample.opcode;
        this.owner = sample.owner;
        this.name = sample.name;
        this.descriptor = sample.descriptor;
        this.iface = sample.iface;
    }

    @Override
    public MMethodInsn clone() {
        return new MMethodInsn(this);
    }

    public int getOpcode() {
        return this.opcode;
    }

    public void setOpcode(int opcode) {
        this.opcode = opcode;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public boolean isIface() {
        return this.iface;
    }

    public void setIface(boolean iface) {
        this.iface = iface;
    }

    public String toString() {
        return MMethodInsn.class.getSimpleName() + " opcode=" + OpCode.code(this.opcode).map(Enum::name).orElse("?") + "#" + this.opcode + " owner=" + this.owner + " name=" + this.name + " desc=" + this.descriptor + " iface=" + this.iface;
    }

    @Override
    public void write(MethodVisitor v, MethodWriterCtx ctx) {
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        v.visitMethodInsn(this.getOpcode(), this.getOwner(), this.getName(), this.getDescriptor(), this.isIface());
    }
}

