/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.mth;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.MethodVisitor;
import xyz.cofe.iter.Eterable;
import xyz.cofe.trambda.bc.ByteCode;
import xyz.cofe.trambda.bc.ann.AnnotationByteCode;
import xyz.cofe.trambda.bc.ann.AnnotationDef;
import xyz.cofe.trambda.bc.ann.GetAnnotationByteCodes;
import xyz.cofe.trambda.bc.mth.MAbstractBC;
import xyz.cofe.trambda.bc.mth.MethodWriter;
import xyz.cofe.trambda.bc.mth.MethodWriterCtx;

public class MParameterAnnotation
extends MAbstractBC
implements ByteCode,
AnnotationDef,
GetAnnotationByteCodes,
MethodWriter {
    private static final long serialVersionUID = 1L;
    protected int parameter;
    protected String descriptor;
    protected boolean visible;
    protected List<AnnotationByteCode> annotationByteCodes;

    public MParameterAnnotation() {
    }

    public MParameterAnnotation(MParameterAnnotation sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.parameter = sample.parameter;
        this.descriptor = sample.descriptor;
        this.visible = sample.visible;
        if (sample.annotationByteCodes != null) {
            this.annotationByteCodes = new ArrayList<AnnotationByteCode>();
            for (AnnotationByteCode b : sample.annotationByteCodes) {
                if (b != null) {
                    this.annotationByteCodes.add(b.clone());
                    continue;
                }
                this.annotationByteCodes.add(null);
            }
        }
    }

    @Override
    public MParameterAnnotation clone() {
        return new MParameterAnnotation(this);
    }

    public int getParameter() {
        return this.parameter;
    }

    public void setParameter(int parameter) {
        this.parameter = parameter;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String toString() {
        return MParameterAnnotation.class.getSimpleName() + " parameter=" + this.parameter + " descriptor=" + this.descriptor + " visible=" + this.visible;
    }

    @Override
    public List<AnnotationByteCode> getAnnotationByteCodes() {
        if (this.annotationByteCodes == null) {
            this.annotationByteCodes = new ArrayList<AnnotationByteCode>();
        }
        return this.annotationByteCodes;
    }

    public void setAnnotationByteCodes(List<AnnotationByteCode> byteCodes) {
        this.annotationByteCodes = byteCodes;
    }

    @Override
    public Eterable<ByteCode> nodes() {
        if (this.annotationByteCodes != null) {
            return Eterable.of(this.annotationByteCodes);
        }
        return Eterable.empty();
    }

    @Override
    public void write(MethodVisitor v, MethodWriterCtx ctx) {
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        AnnotationVisitor av = v.visitParameterAnnotation(this.getParameter(), this.getDescriptor(), this.isVisible());
        List<AnnotationByteCode> abody = this.annotationByteCodes;
        if (abody != null) {
            int i = -1;
            for (AnnotationByteCode ab : abody) {
                ++i;
                if (ab != null) {
                    ab.write(av);
                    continue;
                }
                throw new IllegalStateException("annotationByteCodes[" + i + "]==null");
            }
        }
    }
}

