/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda.bc.cls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import xyz.cofe.iter.Eterable;
import xyz.cofe.trambda.bc.AccFlags;
import xyz.cofe.trambda.bc.AccFlagsProperty;
import xyz.cofe.trambda.bc.ByteCode;
import xyz.cofe.trambda.bc.MethodFlags;
import xyz.cofe.trambda.bc.cls.ClazzWriter;
import xyz.cofe.trambda.bc.cls.ClsByteCode;
import xyz.cofe.trambda.bc.mth.MEnd;
import xyz.cofe.trambda.bc.mth.MethodByteCode;
import xyz.cofe.trambda.bc.mth.MethodWriterCtx;

public class CMethod
implements ClsByteCode,
ClazzWriter,
AccFlagsProperty,
MethodFlags {
    private static final long serialVersionUID = 1L;
    protected int access;
    protected String name;
    protected String descriptor;
    protected String signature;
    protected String[] exceptions;
    protected List<MethodByteCode> methodByteCodes;

    public CMethod() {
    }

    public CMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        this.access = access;
        this.name = name;
        this.descriptor = descriptor;
        this.signature = signature;
        this.exceptions = exceptions;
    }

    public CMethod(CMethod sample) {
        if (sample == null) {
            throw new IllegalArgumentException("sample==null");
        }
        this.access = sample.getAccess();
        this.name = sample.getName();
        this.descriptor = sample.getDescriptor();
        this.signature = sample.getSignature();
        this.exceptions = sample.getExceptions();
        if (sample.methodByteCodes != null) {
            this.methodByteCodes = new ArrayList<MethodByteCode>();
            for (MethodByteCode mb : sample.methodByteCodes) {
                this.methodByteCodes.add(mb != null ? mb.clone() : null);
            }
        }
    }

    @Override
    public CMethod clone() {
        return new CMethod(this);
    }

    public CMethod configure(Consumer<CMethod> conf) {
        if (conf == null) {
            throw new IllegalArgumentException("conf==null");
        }
        conf.accept(this);
        return this;
    }

    @Override
    public int getAccess() {
        return this.access;
    }

    @Override
    public void setAccess(int access) {
        this.access = access;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(String[] exceptions) {
        this.exceptions = exceptions;
    }

    public List<MethodByteCode> getMethodByteCodes() {
        if (this.methodByteCodes == null) {
            this.methodByteCodes = new ArrayList<MethodByteCode>();
        }
        return this.methodByteCodes;
    }

    public void setMethodByteCodes(List<MethodByteCode> ls) {
        this.methodByteCodes = ls;
    }

    public String toString() {
        return "CMethod access=" + this.access + "#" + new AccFlags(this.access).flags() + " name=" + this.name + " descriptor=" + this.descriptor + " signature=" + this.signature + " exceptions=" + Arrays.toString(this.exceptions);
    }

    @Override
    public Eterable<ByteCode> nodes() {
        if (this.methodByteCodes != null) {
            return Eterable.of(this.methodByteCodes);
        }
        return Eterable.empty();
    }

    @Override
    public void write(ClassWriter v) {
        if (v == null) {
            throw new IllegalArgumentException("v==null");
        }
        MethodVisitor mv = v.visitMethod(this.getAccess(), this.getName(), this.getDescriptor(), this.getSignature(), this.getExceptions());
        MethodWriterCtx ctx = new MethodWriterCtx();
        List<MethodByteCode> body = this.methodByteCodes;
        if (body != null) {
            for (MethodByteCode b : body) {
                if (b == null || b instanceof MEnd) continue;
                b.write(mv, ctx);
            }
        }
        mv.visitEnd();
    }
}

