/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.trambda;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import xyz.cofe.collection.ImTree;
import xyz.cofe.collection.ImTreeWalk;
import xyz.cofe.iter.Eterable;
import xyz.cofe.trambda.bc.cls.CBegin;
import xyz.cofe.trambda.bc.cls.CMethod;

public class LambdaNode
implements Serializable,
ImTree<LambdaNode>,
ImTreeWalk<LambdaNode> {
    protected CBegin clazz;
    protected CMethod method;
    protected List<LambdaNode> nodes;

    public LambdaNode configure(Consumer<LambdaNode> conf) {
        if (conf == null) {
            throw new IllegalArgumentException("conf==null");
        }
        conf.accept(this);
        return this;
    }

    public CBegin getClazz() {
        return this.clazz;
    }

    public void setClazz(CBegin clazz) {
        this.clazz = clazz;
    }

    public CMethod getMethod() {
        return this.method;
    }

    public void setMethod(CMethod method) {
        this.method = method;
    }

    public List<LambdaNode> getNodes() {
        if (this.nodes == null) {
            this.nodes = new ArrayList<LambdaNode>();
        }
        return this.nodes;
    }

    public void setNodes(List<LambdaNode> nodes) {
        this.nodes = nodes;
    }

    public String toString() {
        return this.toString(0);
    }

    private String toString(int level) {
        StringBuilder sb = new StringBuilder();
        String indent = "  ".repeat(level);
        sb.append(indent);
        sb.append(LambdaNode.class.getSimpleName());
        if (this.clazz != null) {
            sb.append(" ");
            sb.append(this.clazz.getName());
        }
        if (this.method != null) {
            sb.append(" ");
            sb.append(this.method);
        }
        if (this.nodes != null) {
            sb.append(System.lineSeparator());
            for (LambdaNode n : this.nodes) {
                String s = n.toString(level + 1);
                sb.append(s);
                if (n.nodes != null && !n.nodes.isEmpty()) continue;
                sb.append(System.lineSeparator());
            }
        }
        return sb.toString();
    }

    public Eterable<LambdaNode> nodes() {
        return Eterable.of(this.getNodes());
    }
}

