/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnionWriter
extends Writer {
    protected Set<Writer> writers = new LinkedHashSet<Writer>();

    public UnionWriter() {
    }

    public UnionWriter(Writer ... writers) {
        if (writers == null) {
            return;
        }
        Set<Writer> ww = this.getWriters();
        if (ww == null) {
            return;
        }
        if (!(ww instanceof Collection)) {
            return;
        }
        Collection _w = ww;
        for (Writer w : writers) {
            if (w == null) continue;
            _w.add(w);
        }
    }

    public UnionWriter(Iterable<Writer> writers) {
        if (writers == null) {
            return;
        }
        Set<Writer> ww = this.getWriters();
        if (ww == null) {
            return;
        }
        if (!(ww instanceof Collection)) {
            return;
        }
        Collection _w = ww;
        for (Writer w : writers) {
            if (w == null) continue;
            _w.add(w);
        }
    }

    public Set<Writer> getWriters() {
        if (this.writers == null) {
            this.writers = new LinkedHashSet<Writer>();
        }
        return this.writers;
    }

    public void setWriters(Iterable<Writer> writers) {
        if (this.writers != null) {
            this.writers.clear();
        } else {
            this.writers = new LinkedHashSet<Writer>();
        }
        if (writers != null) {
            for (Writer w : writers) {
                if (w == null) continue;
                this.writers.add(w);
            }
        }
    }

    protected boolean isCatchException() {
        return true;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        Set<Writer> _writers = this.getWriters();
        if (_writers == null) {
            return;
        }
        for (Writer w : _writers) {
            if (w == null) continue;
            if (this.isCatchException()) {
                try {
                    w.write(cbuf, off, len);
                }
                catch (Exception e) {
                    Logger.getLogger(UnionWriter.class.getName()).log(Level.SEVERE, "", e);
                }
                continue;
            }
            w.write(cbuf, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        Set<Writer> _writers = this.getWriters();
        if (_writers == null) {
            return;
        }
        for (Writer w : _writers) {
            if (w == null) continue;
            if (this.isCatchException()) {
                try {
                    w.flush();
                }
                catch (Exception e) {
                    Logger.getLogger(UnionWriter.class.getName()).log(Level.SEVERE, "", e);
                }
                continue;
            }
            w.flush();
        }
    }

    @Override
    public void close() throws IOException {
        Set<Writer> _writers = this.getWriters();
        if (_writers == null) {
            return;
        }
        for (Writer w : _writers) {
            if (w == null) continue;
            if (this.isCatchException()) {
                try {
                    w.close();
                }
                catch (Exception e) {
                    Logger.getLogger(UnionWriter.class.getName()).log(Level.SEVERE, "", e);
                }
                continue;
            }
            w.close();
        }
    }
}

