/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import xyz.cofe.fn.Pair;
import xyz.cofe.iter.Eterable;
import xyz.cofe.text.Align;
import xyz.cofe.text.EndLine;
import xyz.cofe.text.FullDecFormat;

public class Text {
    protected static Map<String, String> text2HtmlCharMap = null;

    public static String getHex(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes==null");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Text.getHex(bytes[i]));
        }
        return sb.toString();
    }

    public static String getHex(Byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes==null");
        }
        StringBuilder sb = new StringBuilder();
        for (Byte byte1 : bytes) {
            sb.append(Text.getHex(byte1));
        }
        return sb.toString();
    }

    public static String getHex(byte byteValue) {
        return Integer.toString((byteValue & 0xFF) + 256, 16).substring(1).toUpperCase();
    }

    public static String encodeHex(byte[] bytes, int off, int len) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes==null");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(Text.getHex(bytes[i + off]));
        }
        return sb.toString();
    }

    public static String encodeHex(Byte[] bytes, int off, int len) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes==null");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(Text.getHex(bytes[i + off]));
        }
        return sb.toString();
    }

    public static String encodeHex(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes==null");
        }
        return Text.getHex(bytes);
    }

    public static String encodeHex(Byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes==null");
        }
        return Text.getHex(bytes);
    }

    public static byte[] decodeHex(String bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes==null");
        }
        int len = bytes.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(bytes.charAt(i), 16) << 4) + Character.digit(bytes.charAt(i + 1), 16));
        }
        return data;
    }

    public static byte[] decodeHex(String bytes, int offset, int len) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes==null");
        }
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(bytes.charAt(i + offset), 16) << 4) + Character.digit(bytes.charAt(i + 1 + offset), 16));
        }
        return data;
    }

    public static Byte[] decodeHexBytes(String bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes==null");
        }
        int len = bytes.length();
        Byte[] data = new Byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(bytes.charAt(i), 16) << 4) + Character.digit(bytes.charAt(i + 1), 16));
        }
        return data;
    }

    public static Byte[] decodeHexBytes(String bytes, int offset, int len) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes==null");
        }
        Byte[] data = new Byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(bytes.charAt(i + offset), 16) << 4) + Character.digit(bytes.charAt(i + 1 + offset), 16));
        }
        return data;
    }

    public static Map<String, String> getText2HtmlCharMap() {
        if (text2HtmlCharMap != null) {
            return text2HtmlCharMap;
        }
        text2HtmlCharMap = new HashMap<String, String>();
        text2HtmlCharMap.put("&", "&amp;");
        text2HtmlCharMap.put("<", "&lt;");
        text2HtmlCharMap.put(">", "&gt;");
        text2HtmlCharMap.put("\"", "&quot;");
        text2HtmlCharMap.put("'", "&apos;");
        text2HtmlCharMap.put("\u00a0", "&nbsp;");
        text2HtmlCharMap.put("\u00a9", "&copy;");
        text2HtmlCharMap.put("\u00ae", "&reg;");
        text2HtmlCharMap.put("\u00ab", "&laquo;");
        text2HtmlCharMap.put("\u00bb", "&raquo;");
        text2HtmlCharMap.put("\u2039", "&lsaquo;");
        text2HtmlCharMap.put("\u203a", "&rsaquo;");
        text2HtmlCharMap.put("\u201e", "&bdquo;");
        text2HtmlCharMap.put("\u201c", "&ldquo;");
        text2HtmlCharMap.put("\u201d", "&rdquo;");
        text2HtmlCharMap.put("\u201f", "&#8223;");
        text2HtmlCharMap.put("\u2019", "&rsquo;");
        text2HtmlCharMap.put("\u201a", "&sbquo;");
        text2HtmlCharMap.put("\u201b", "&#8219;");
        text2HtmlCharMap.put("\u2018", "&lsquo;");
        text2HtmlCharMap.put("\u00bf", "&iquest;");
        text2HtmlCharMap.put("\u00a1", "&iexcl;");
        text2HtmlCharMap.put("\u00a7", "&sect;");
        text2HtmlCharMap.put("\u00b6", "&para;");
        text2HtmlCharMap.put("\u2022", "&bull;");
        text2HtmlCharMap.put("\u2014", "&mdash;");
        text2HtmlCharMap.put("\u2026", "&hellip;");
        text2HtmlCharMap.put("\u221a", "&radic;");
        text2HtmlCharMap.put("\u222b", "&int;");
        text2HtmlCharMap.put("\u2202", "&part;");
        text2HtmlCharMap.put("\u2211", "&sum;");
        text2HtmlCharMap.put("\u220f", "&prod;");
        return text2HtmlCharMap;
    }

    public static String htmlDecode(String html) {
        if (html == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int idx = -1;
        while (++idx < html.length()) {
            String current = html.substring(idx);
            if (current.startsWith("&amp;")) {
                sb.append("&");
                idx += 4;
                continue;
            }
            if (current.startsWith("&nbsp;")) {
                sb.append(" ");
                idx += 5;
                continue;
            }
            if (current.startsWith("&lt;")) {
                sb.append("<");
                idx += 3;
                continue;
            }
            if (current.startsWith("&quot;")) {
                sb.append("\"");
                idx += 5;
                continue;
            }
            if (current.startsWith("&gt;")) {
                sb.append(">");
                idx += 3;
                continue;
            }
            if (current.startsWith("&apos;")) {
                sb.append("'");
                idx += 5;
                continue;
            }
            sb.append(html.charAt(idx));
        }
        return sb.toString();
    }

    public static String htmlEncode(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder u = new StringBuilder(text.trim());
        for (int i = 0; i < u.length(); ++i) {
            char c = u.charAt(i);
            if (c == '<') {
                u.replace(i, i + 1, "&lt;");
                i += 3;
                continue;
            }
            if (c == '>') {
                u.replace(i, i + 1, "&gt;");
                i += 3;
                continue;
            }
            if (c != '&') continue;
            u.replace(i, i + 1, "&amp;");
            i += 4;
        }
        return u.toString();
    }

    public static String attrEncode(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder u = new StringBuilder(text);
        block7: for (int i = 0; i < u.length(); ++i) {
            char c = u.charAt(i);
            switch (c) {
                case '<': {
                    u.replace(i, i + 1, "&lt;");
                    i += 3;
                    continue block7;
                }
                case '>': {
                    u.replace(i, i + 1, "&gt;");
                    i += 3;
                    continue block7;
                }
                case '&': {
                    u.replace(i, i + 1, "&amp;");
                    i += 4;
                    continue block7;
                }
                case '\"': {
                    u.replace(i, i + 1, "&quot;");
                    i += 5;
                    continue block7;
                }
                case '\'': {
                    u.replace(i, i + 1, "&apos;");
                    i += 5;
                    continue block7;
                }
            }
        }
        return u.toString();
    }

    public static String attrDecode(String attr) {
        if (attr == null) {
            return null;
        }
        StringBuilder res = new StringBuilder();
        int p = 0;
        while (p < attr.length()) {
            String txt4 = Text.lookupText(attr, p, 4);
            if (txt4.equalsIgnoreCase("&lt;")) {
                res.append("<");
                p += 4;
                continue;
            }
            if (txt4.equalsIgnoreCase("&gt;")) {
                res.append(">");
                p += 4;
                continue;
            }
            String txt5 = Text.lookupText(attr, p, 5);
            if (txt5.equalsIgnoreCase("&amp;")) {
                res.append("&");
                p += 5;
                continue;
            }
            String txt6 = Text.lookupText(attr, p, 5);
            if (txt6.equalsIgnoreCase("&quot;")) {
                res.append("\"");
                p += 6;
                continue;
            }
            if (txt6.equalsIgnoreCase("&apos;")) {
                res.append("'");
                p += 6;
                continue;
            }
            String txt1 = Text.lookupText(attr, p, 1);
            if (txt1.length() < 1) break;
            res.append(txt1);
            ++p;
        }
        return res.toString();
    }

    public static String urlDecode(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        try {
            return URLDecoder.decode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(Text.class.getName()).log(Level.SEVERE, null, ex);
            throw new Error(ex);
        }
    }

    public static String urlDecode(String text, String charset) {
        try {
            return URLDecoder.decode(text, charset);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(Text.class.getName()).log(Level.SEVERE, null, ex);
            throw new Error(ex);
        }
    }

    public static String urlEncode(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(Text.class.getName()).log(Level.SEVERE, null, ex);
            throw new Error(ex);
        }
    }

    public static String urlEncode(String text, String charset) {
        try {
            return URLEncoder.encode(text, charset);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(Text.class.getName()).log(Level.SEVERE, null, ex);
            throw new Error(ex);
        }
    }

    public static String queryStringEncodeMap(Map<String, String> map, boolean allowNullKey, boolean allowNullValue) {
        if (map == null) {
            throw new IllegalArgumentException("map==null");
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> en : map.entrySet()) {
            String k = en.getKey();
            String v = en.getValue();
            if (k == null && v == null) continue;
            if (k == null) {
                if (!allowNullKey) continue;
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append("=");
                sb.append(Text.urlEncode(v));
                continue;
            }
            if (v == null) {
                if (!allowNullValue) continue;
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(Text.urlEncode(k));
                sb.append("=");
                continue;
            }
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(Text.urlEncode(k));
            sb.append("=");
            sb.append(Text.urlEncode(v));
        }
        return sb.toString();
    }

    public static Map<String, String> queryStringDecodeMap(String queryString) {
        if (queryString == null) {
            throw new IllegalArgumentException("queryString==null");
        }
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        for (String kval : Text.queryStringSplit(queryString, null, true, null, true)) {
            String[] kv = Text.queryStringKeyValueSplit(kval, true);
            if (kv == null || kv.length != 2) continue;
            res.put(kv[0], kv[1]);
        }
        return res;
    }

    public static Map<String, List<String>> queryStringDecodeMultiMap(String queryString) {
        if (queryString == null) {
            throw new IllegalArgumentException("queryString==null");
        }
        LinkedHashMap<String, List<String>> res = new LinkedHashMap<String, List<String>>();
        for (String kval : Text.queryStringSplit(queryString, null, true, null, true)) {
            String[] kv = Text.queryStringKeyValueSplit(kval, true);
            if (kv == null || kv.length != 2) continue;
            ArrayList<String> lvals = (ArrayList<String>)res.get(kv[0]);
            if (lvals == null) {
                lvals = new ArrayList<String>();
                res.put(kv[0], lvals);
            }
            lvals.add(kv[1]);
        }
        return res;
    }

    public static String[] queryStringKeyValueSplit(String keyValuePair, boolean allowNullValue) {
        if (keyValuePair == null) {
            throw new IllegalArgumentException("keyValuePair==null");
        }
        if (!keyValuePair.contains("=")) {
            if (allowNullValue) {
                return new String[]{Text.urlEncode(keyValuePair), ""};
            }
            return null;
        }
        String[] kvArr = keyValuePair.split("=", 2);
        if (kvArr.length < 2) {
            if (allowNullValue) {
                return new String[]{Text.urlDecode(keyValuePair), ""};
            }
            return null;
        }
        if (kvArr.length > 2) {
            return new String[]{Text.urlDecode(kvArr[0]), Text.urlDecode(kvArr[1])};
        }
        return new String[]{Text.urlDecode(kvArr[0]), Text.urlDecode(kvArr[1])};
    }

    public static List<String> queryStringSplit(String queryString, Iterable<String> specChars, boolean specCharsIgnoreCase, Function<String, String> specCharConv, boolean checkComment) {
        char c;
        if (queryString == null) {
            throw new IllegalArgumentException("queryString==null");
        }
        Iterable<String> iterable = specChars = specChars == null ? Text.getText2HtmlCharMap().values() : specChars;
        if (specCharConv == null) {
            LinkedHashMap<String, String> spec2txt = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> e : Text.getText2HtmlCharMap().entrySet()) {
                spec2txt.put(e.getValue(), e.getKey());
            }
            specCharConv = Convertors.map(spec2txt, "", "");
        }
        StringBuilder buff = new StringBuilder();
        ArrayList<String> keyValuePairs = new ArrayList<String>();
        int i = -1;
        while (!(++i >= queryString.length() || (c = queryString.charAt(i)) == '#' && checkComment)) {
            if (c == '&') {
                boolean speccMatched = false;
                for (String specc : specChars) {
                    String v;
                    if (specc == null || specc.length() == 0) continue;
                    String l = Text.lookupText(queryString, i, specc.length());
                    if (specCharsIgnoreCase) {
                        if (!specc.equalsIgnoreCase(l)) continue;
                        i += specc.length() - 1;
                        if (specCharConv != null) {
                            v = specCharConv.apply(specc);
                            if (v != null) {
                                buff.append(v);
                            }
                        } else {
                            buff.append(specc);
                        }
                        speccMatched = true;
                        break;
                    }
                    if (!specc.equals(l)) continue;
                    i += specc.length() - 1;
                    if (specCharConv != null) {
                        v = specCharConv.apply(specc);
                        if (v != null) {
                            buff.append(v);
                        }
                    } else {
                        buff.append(specc);
                    }
                    speccMatched = true;
                    break;
                }
                if (speccMatched) continue;
                keyValuePairs.add(buff.toString());
                buff.setLength(0);
                continue;
            }
            buff.append(c);
        }
        if (buff.length() > 0) {
            keyValuePairs.add(buff.toString());
        }
        return keyValuePairs;
    }

    public static String lookupText(String source, int beginIndex, int len) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        if (len < 0) {
            throw new IllegalArgumentException("len<0");
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex<0");
        }
        if (beginIndex >= source.length()) {
            return "";
        }
        int endIdx = beginIndex + len;
        if (beginIndex >= endIdx) {
            return "";
        }
        if (endIdx > source.length()) {
            endIdx = source.length();
        }
        return source.substring(beginIndex, endIdx);
    }

    public static boolean matchText(String source, String needly, int beginIndex, boolean ignoreCase) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        if (needly == null) {
            throw new IllegalArgumentException("needly==null");
        }
        String partOfSrc = Text.lookupText(source, beginIndex, needly.length());
        return ignoreCase ? partOfSrc.equalsIgnoreCase(needly) : partOfSrc.equals(needly);
    }

    public static Pair<Integer, String> nextNewLine(String text, int beginIndex) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        for (int i = beginIndex; i < text.length(); ++i) {
            char c1;
            char c0 = text.charAt(i);
            char c = c1 = i + 1 < text.length() ? text.charAt(i + 1) : (char)'\u0000';
            if (c0 == '\n' && c1 == '\r') {
                return Pair.of((Object)(i + 2), (Object)"\n\r");
            }
            if (c0 == '\r' && c1 == '\n') {
                return Pair.of((Object)(i + 2), (Object)"\r\n");
            }
            if (c0 == '\n' && c1 != '\r') {
                return Pair.of((Object)(i + 1), (Object)"\n");
            }
            if (c0 != '\r' || c1 == '\n') continue;
            return Pair.of((Object)(i + 1), (Object)"\r");
        }
        return null;
    }

    public static String[] dropFirstEmptyLines(String[] lines) {
        if (lines == null) {
            throw new IllegalArgumentException("lines==null");
        }
        ArrayList<String> nlines = new ArrayList<String>();
        boolean drop = true;
        for (String line : lines) {
            if (drop) {
                if (line == null || line.trim().length() < 1) continue;
                drop = false;
                nlines.add(line);
                continue;
            }
            nlines.add(line);
        }
        return nlines.toArray(new String[0]);
    }

    public static List<String> dropFirstEmptyLines(Iterable<String> lines) {
        if (lines == null) {
            throw new IllegalArgumentException("lines==null");
        }
        ArrayList<String> nlines = new ArrayList<String>();
        boolean drop = true;
        for (String line : lines) {
            if (drop) {
                if (line == null || line.trim().length() < 1) continue;
                drop = false;
                nlines.add(line);
                continue;
            }
            nlines.add(line);
        }
        return nlines;
    }

    public static String[] dropLastEmptyLines(String[] lines) {
        ArrayList<String> nlines = new ArrayList<String>();
        boolean drop = true;
        for (int i = lines.length - 1; i >= 0; --i) {
            String line = lines[i];
            if (drop) {
                if (line == null || line.trim().length() < 1) continue;
                drop = false;
                nlines.add(line);
                continue;
            }
            nlines.add(line);
        }
        Collections.reverse(nlines);
        return nlines.toArray(new String[0]);
    }

    public static List<String> dropLastEmptyLines(Iterable<String> lines) {
        ArrayList<String> nlines = new ArrayList<String>();
        ArrayList<String> slines = new ArrayList<String>();
        if (lines != null) {
            for (String l : lines) {
                slines.add(0, l);
            }
        }
        boolean drop = true;
        for (String line : slines) {
            if (drop) {
                if (line == null || line.trim().length() < 1) continue;
                drop = false;
                nlines.add(line);
                continue;
            }
            nlines.add(line);
        }
        Collections.reverse(nlines);
        return nlines;
    }

    public static Eterable<String> convert(Iterable<String> source, Function<String, String> convertor) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        if (convertor == null) {
            return Eterable.of(source);
        }
        return Eterable.of(source).map(convertor);
    }

    public static String[] convert(String[] source, Function<String, String> convertor) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        if (convertor == null) {
            throw new IllegalArgumentException("convertor==null");
        }
        String[] res = new String[source.length];
        for (int i = 0; i < source.length; ++i) {
            res[i] = convertor.apply(source[i]);
        }
        return res;
    }

    public static int indexOfNonWSChar(String text, int begin, int endexclusive) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        for (int i = begin; i < endexclusive; ++i) {
            char c = text.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfNonWSChar(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        return Text.indexOfNonWSChar(text, 0, text.length());
    }

    public static String trimStart(String text) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        StringBuilder res = new StringBuilder();
        int state = 0;
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(c)) continue block4;
                    res.append(c);
                    state = 1;
                    continue block4;
                }
                case 1: {
                    res.append(c);
                }
            }
        }
        return res.toString();
    }

    public static String trimStart(String text, int max) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        StringBuilder res = new StringBuilder();
        int state = max <= 0 ? 1 : 0;
        int co = 0;
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (state) {
                case 0: {
                    if (!Character.isWhitespace(c)) {
                        res.append(c);
                        state = 1;
                    }
                    if (++co < max || max <= 0) continue block4;
                    state = 1;
                    continue block4;
                }
                case 1: {
                    res.append(c);
                }
            }
        }
        return res.toString();
    }

    public static String trimStart(String text, String trimText) {
        int cutlength;
        if (text == null) {
            throw new IllegalArgumentException("text == null");
        }
        if (trimText == null) {
            throw new IllegalArgumentException("trimText == null");
        }
        if (trimText.length() < 1 || text.length() < 1) {
            return text;
        }
        String result = text;
        while (result.length() > 0 && result.startsWith(trimText) && (cutlength = trimText.length()) <= result.length()) {
            if (cutlength == result.length()) {
                result = "";
                break;
            }
            result = result.substring(cutlength);
        }
        return result;
    }

    public static String trimEnd(String text, String trimText) {
        int endindex;
        if (text == null) {
            throw new IllegalArgumentException("text == null");
        }
        if (trimText == null) {
            throw new IllegalArgumentException("trimText == null");
        }
        if (trimText.length() < 1 || text.length() < 1) {
            return text;
        }
        String result = text;
        while (result.length() > 0 && result.endsWith(trimText) && (endindex = result.length() - trimText.length()) >= 0) {
            result = result.substring(0, endindex);
        }
        return result;
    }

    public static String repeat(String text, int count) {
        if (count < 1) {
            return "";
        }
        if (count == 1) {
            return text;
        }
        String res = "";
        for (int i = 0; i < count; ++i) {
            res = res + text;
        }
        return res;
    }

    public static String[] split(String src, String splitter) {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        if (splitter == null) {
            throw new IllegalArgumentException("splitter == null");
        }
        ArrayList<String> result = new ArrayList<String>();
        if (splitter.equals(src)) {
            result.add("");
        } else if (splitter.length() > src.length()) {
            result.add(src);
        } else {
            int offset = 0;
            while (offset <= src.length()) {
                String s;
                if (offset == src.length()) {
                    result.add("");
                    break;
                }
                int next = src.indexOf(splitter, offset);
                if (next < 0) {
                    s = src.substring(offset, src.length());
                    result.add(s);
                    break;
                }
                s = src.substring(offset, next);
                result.add(s);
                offset = next + splitter.length();
            }
        }
        return result.toArray(new String[0]);
    }

    public static Eterable<String> splitIterable(String src, String splitter) {
        Object[] arr = Text.split(src, splitter);
        return Eterable.of((Object[])arr);
    }

    public static String join(Iterable<String> lines, String glue) {
        return Text.join(lines, glue, false);
    }

    public static String join(Iterable<String> lines, String glue, boolean withNulls) {
        if (lines == null) {
            throw new IllegalArgumentException("lines == null");
        }
        if (glue == null) {
            throw new IllegalArgumentException("glue == null");
        }
        StringBuilder res = new StringBuilder();
        int idx = -1;
        for (String line : lines) {
            if (line == null && !withNulls) continue;
            if (++idx > 0) {
                res.append(glue);
            }
            res.append(line != null ? line : "null");
        }
        return res.toString();
    }

    public static String join(Iterable<String> lines, String glue, int from, int count, boolean withNulls) {
        if (lines == null) {
            throw new IllegalArgumentException("lines == null");
        }
        if (glue == null) {
            throw new IllegalArgumentException("glue == null");
        }
        if (count == 0) {
            return "";
        }
        StringBuilder res = new StringBuilder();
        int included = -1;
        int lineIdx = -1;
        for (String line : lines) {
            if (line == null && !withNulls || from >= 0 && ++lineIdx < from) continue;
            if (count > 0 && included >= count && count != Integer.MAX_VALUE) break;
            if (++included > 0) {
                res.append(glue);
            }
            res.append(line != null ? line : "null");
        }
        return res.toString();
    }

    public static String join(String[] lines, String glue, int from, int count) {
        if (lines == null) {
            throw new IllegalArgumentException("lines == null");
        }
        if (glue == null) {
            throw new IllegalArgumentException("glue == null");
        }
        return Text.join(lines, glue, from, count, false);
    }

    public static String join(String[] lines, String glue, int from, int count, boolean withNulls) {
        if (lines == null) {
            throw new IllegalArgumentException("lines == null");
        }
        if (glue == null) {
            throw new IllegalArgumentException("glue == null");
        }
        if (count == 0) {
            return "";
        }
        int includedLinesCount = 0;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            boolean leftOutside;
            boolean rightOutside;
            int idx = from + i;
            boolean bl = rightOutside = idx >= lines.length;
            if (rightOutside) break;
            boolean bl2 = leftOutside = idx < 0;
            if (leftOutside) continue;
            String line = lines[idx];
            if (!withNulls && line == null) continue;
            if (includedLinesCount > 0) {
                sb.append(glue);
            }
            sb.append(line);
            ++includedLinesCount;
        }
        return sb.toString();
    }

    public static String join(String[] lines, String glue) {
        if (lines == null) {
            throw new IllegalArgumentException("lines == null");
        }
        if (glue == null) {
            throw new IllegalArgumentException("glue == null");
        }
        return Text.join(lines, glue, 0, lines.length);
    }

    public static boolean in(String src, String ... arr) {
        return Text.indexOf(src, arr) >= 0;
    }

    public static int indexOf(String src, String ... arr) {
        if (src == null) {
            throw new IllegalArgumentException("src==null");
        }
        if (arr == null) {
            throw new IllegalArgumentException("arr==null");
        }
        int idx = -1;
        for (String a : arr) {
            ++idx;
            if (a == null || !src.equals(a)) continue;
            return idx;
        }
        return -1;
    }

    public static int[] indexesOf(Predicate<String> src, String ... arr) {
        if (src == null) {
            throw new IllegalArgumentException("src==null");
        }
        if (arr == null) {
            throw new IllegalArgumentException("arr==null");
        }
        int[] res = new int[]{};
        int idx = -1;
        for (String a : arr) {
            ++idx;
            if (a == null || !src.test(a)) continue;
            res = Arrays.copyOf(res, res.length + 1);
            res[res.length - 1] = idx;
        }
        return res;
    }

    public static int[] indexesOf(Predicate<String> src, Iterable<String> arr) {
        if (src == null) {
            throw new IllegalArgumentException("src==null");
        }
        if (arr == null) {
            throw new IllegalArgumentException("arr==null");
        }
        int[] res = new int[]{};
        int idx = -1;
        for (String a : arr) {
            ++idx;
            if (a == null || !src.test(a)) continue;
            res = Arrays.copyOf(res, res.length + 1);
            res[res.length - 1] = idx;
        }
        return res;
    }

    public static boolean in(String src, Iterable<String> list) {
        return Text.indexOf(src, list) >= 0;
    }

    public static int indexOf(String src, Iterable<String> list) {
        if (src == null) {
            throw new IllegalArgumentException("src==null");
        }
        if (list == null) {
            throw new IllegalArgumentException("list==null");
        }
        int idx = -1;
        for (String a : list) {
            ++idx;
            if (a == null || !src.equals(a)) continue;
            return idx;
        }
        return -1;
    }

    private static String ww_getNext(String text, int offset) {
        if (text == null) {
            return null;
        }
        if (offset >= text.length()) {
            return null;
        }
        if (offset < 0) {
            return null;
        }
        char c = text.charAt(offset);
        if (Character.isLetterOrDigit(c)) {
            StringBuilder sb = new StringBuilder();
            while (offset < text.length() && Character.isLetterOrDigit(c = text.charAt(offset))) {
                ++offset;
                sb.append(c);
            }
            return sb.toString();
        }
        return new String(new char[]{c});
    }

    public static Eterable<String> wordWrapIterable(String text, int maxwidth) {
        Object[] src = Text.wordWrap(text, maxwidth);
        return Eterable.of((Object[])src);
    }

    public static String[] wordWrap(String text, int maxwidth) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        if (maxwidth < 1) {
            throw new IllegalArgumentException("maxwidth<1");
        }
        if (text.length() == 0) {
            return new String[]{text};
        }
        if (text.length() < maxwidth) {
            return new String[]{text};
        }
        ArrayList<String> lines = new ArrayList<String>();
        int offset = 0;
        StringBuilder sb = new StringBuilder();
        String tok = null;
        while (true) {
            if (tok == null) {
                tok = Text.ww_getNext(text, offset);
                if (tok == null) break;
                offset += tok.length();
            }
            if (tok.length() == maxwidth) {
                if (sb.length() > 0) {
                    lines.add(sb.toString());
                    sb.setLength(0);
                }
                lines.add(tok);
                tok = null;
                continue;
            }
            if (tok.length() > maxwidth) {
                if (sb.length() > 0) {
                    lines.add(sb.toString());
                    sb.setLength(0);
                }
                lines.add(tok.substring(0, maxwidth));
                tok = tok.substring(maxwidth);
                continue;
            }
            if (tok.length() == 0) {
                tok = null;
                continue;
            }
            int sbLen = sb.length();
            if (sbLen + tok.length() > maxwidth) {
                if (sb.length() > 0) {
                    lines.add(sb.toString());
                    sb.setLength(0);
                }
                sb.append(tok);
                tok = null;
                continue;
            }
            sb.append(tok);
            tok = null;
        }
        if (sb.length() > 0) {
            lines.add(sb.toString());
            sb.setLength(0);
        }
        return lines.toArray(new String[0]);
    }

    public static String[] align(String[] lines, Align align, String padText, int len) {
        if (lines == null) {
            throw new IllegalArgumentException("lines==null");
        }
        if (align == null) {
            throw new IllegalArgumentException("align==null");
        }
        String[] res = new String[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            res[i] = Text.align(lines[i], align, padText, len);
        }
        return res;
    }

    public static Iterable<String> align(Iterable<String> lines, Align align, String padText, int len) {
        if (lines == null) {
            throw new IllegalArgumentException("lines==null");
        }
        if (align == null) {
            throw new IllegalArgumentException("align==null");
        }
        return Text.convert(lines, Convertors.align(align, padText, len));
    }

    public static String align(String text, Align align, String padText, int len) {
        return Text.align(text, align, padText, len, false);
    }

    public static String align(String text, Align align, String padText, int len, boolean trimText) {
        if (text == null) {
            throw new IllegalArgumentException("text==null");
        }
        if (align == null) {
            throw new IllegalArgumentException("align==null");
        }
        if (padText == null) {
            padText = " ";
        } else if (padText.length() < 1) {
            padText = " ";
        }
        if (len < 0) {
            throw new IllegalArgumentException("len<0");
        }
        if (trimText) {
            text = text.trim();
        }
        if (text.length() >= len) {
            return text;
        }
        int add = len - text.length();
        int idx = -1;
        int padLen = padText.length();
        StringBuilder sb = new StringBuilder();
        boolean insCBegin = true;
        if (align == Align.Begin) {
            sb.append(text);
        }
        if (align == Align.Center) {
            sb.append(text);
        }
        for (int i = 0; i < add; ++i) {
            if (++idx >= padLen) {
                idx = 0;
            }
            char c = padText.charAt(idx);
            if (align == Align.Center) {
                if (insCBegin) {
                    sb.insert(0, c);
                } else {
                    sb.append(c);
                }
                insCBegin = !insCBegin;
                continue;
            }
            sb.append(c);
        }
        if (align == Align.End) {
            sb.append(text);
        }
        return sb.toString();
    }

    public static String indent(String indent, String srcText) {
        if (srcText == null) {
            throw new IllegalArgumentException("srcText==null");
        }
        if (indent == null) {
            throw new IllegalArgumentException("indent==null");
        }
        String[] lines = Text.splitNewLines(srcText);
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = indent + lines[i];
        }
        return Text.join(lines, EndLine.Default.get());
    }

    public static String indent(String indent, String source, String lineDelim) {
        if (source == null) {
            throw new IllegalArgumentException("source == null");
        }
        if (lineDelim == null) {
            lineDelim = EndLine.Default.get();
        }
        if (indent == null) {
            throw new IllegalArgumentException("indent == null");
        }
        String[] sourceLines = Text.splitNewLines(source);
        String[] res = new String[sourceLines.length];
        for (int i = 0; i < sourceLines.length; ++i) {
            res[i] = indent + sourceLines[i];
        }
        return Text.join(res, lineDelim);
    }

    public static String[] indent(String indent, String[] sourceLines) {
        if (sourceLines == null) {
            throw new IllegalArgumentException("sourceLines == null");
        }
        if (indent == null) {
            throw new IllegalArgumentException("indent == null");
        }
        String[] res = new String[sourceLines.length];
        for (int i = 0; i < sourceLines.length; ++i) {
            res[i] = indent + sourceLines[i];
        }
        return res;
    }

    public static Iterable<String> indent(String indent, Iterable<String> source) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        if (indent == null) {
            throw new IllegalArgumentException("indent==null");
        }
        return Text.convert(source, Convertors.wrap(indent, ""));
    }

    public static Eterable<String> splitNewLinesIterable(String text) {
        Object[] arr = Text.splitNewLines(text);
        return Eterable.of((Object[])arr);
    }

    public static String[] splitNewLines(String line) {
        if (line == null) {
            throw new IllegalArgumentException("line==null");
        }
        int idx = 0;
        int len = line.length();
        StringBuilder buff = new StringBuilder();
        ArrayList<String> lines = new ArrayList<String>();
        while (idx < len) {
            char c2;
            char c1 = line.charAt(idx);
            char c = c2 = idx < len - 1 ? line.charAt(idx + 1) : (char)'\u0000';
            if (c1 == '\r' && c2 == '\n') {
                lines.add(buff.toString());
                buff.setLength(0);
                idx += 2;
                continue;
            }
            if (c1 == '\n' && c2 == '\r') {
                lines.add(buff.toString());
                buff.setLength(0);
                idx += 2;
                continue;
            }
            if (c1 == '\r' && c2 != '\n') {
                lines.add(buff.toString());
                buff.setLength(0);
                ++idx;
                continue;
            }
            if (c1 == '\n' && c2 != '\r') {
                lines.add(buff.toString());
                buff.setLength(0);
                ++idx;
                continue;
            }
            buff.append(c1);
            ++idx;
        }
        lines.add(buff.toString());
        return lines.toArray(new String[0]);
    }

    public static String encodeStringConstant(String srcText, char quoteChar) {
        if (srcText == null) {
            return "null";
        }
        StringBuilder txt = new StringBuilder();
        txt.append(quoteChar);
        block10: for (int i = 0; i < srcText.length(); ++i) {
            char c = srcText.charAt(i);
            switch (c) {
                case '\'': {
                    txt.append("\\'");
                    continue block10;
                }
                case '\"': {
                    txt.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    txt.append("\\\\");
                    continue block10;
                }
                case '\t': {
                    txt.append("\\t");
                    continue block10;
                }
                case '\r': {
                    txt.append("\\r");
                    continue block10;
                }
                case '\n': {
                    txt.append("\\n");
                    continue block10;
                }
                case '\b': {
                    txt.append("\\b");
                    continue block10;
                }
                case '\f': {
                    txt.append("\\f");
                    continue block10;
                }
                default: {
                    txt.append(c);
                }
            }
        }
        txt.append(quoteChar);
        return txt.toString();
    }

    public static String encodeStringConstant(String srcText) {
        return Text.encodeStringConstant(srcText, '\"');
    }

    public static ParseStringResult parseStringConstat(String constant, int startIndex) {
        if (constant == null) {
            return null;
        }
        if (startIndex < 0 || startIndex >= constant.length()) {
            return null;
        }
        int state = 0;
        int endIndex = -1;
        String buf = "";
        block16: for (int i = startIndex; i < constant.length() && state <= 99 && state >= 0; ++i) {
            char c = constant.charAt(i);
            switch (state) {
                case 0: {
                    if (Character.isWhitespace(c)) {
                        state = 0;
                        continue block16;
                    }
                    if (c == '\"') {
                        state = 1;
                        continue block16;
                    }
                    state = -1;
                    continue block16;
                }
                case 1: {
                    switch (c) {
                        case '\\': {
                            state = 2;
                            continue block16;
                        }
                        case '\"': {
                            state = 99999;
                            endIndex = i + 1;
                            continue block16;
                        }
                    }
                    buf = buf + c;
                    continue block16;
                }
                case 2: {
                    switch (c) {
                        case 'n': {
                            buf = buf + "\n";
                            state = 1;
                            continue block16;
                        }
                        case 'r': {
                            buf = buf + "\r";
                            state = 1;
                            continue block16;
                        }
                        case 't': {
                            buf = buf + "\t";
                            state = 1;
                            continue block16;
                        }
                        case '\"': {
                            buf = buf + "\"";
                            state = 1;
                            continue block16;
                        }
                        case '\\': {
                            buf = buf + "\\";
                            state = 1;
                            continue block16;
                        }
                    }
                    state = -1;
                }
            }
        }
        if (state < 0) {
            return null;
        }
        SimpleParseResult res = new SimpleParseResult();
        res.sourceString = constant;
        res.decodedString = buf;
        res.beginIndex = startIndex;
        res.endIndex = endIndex;
        return state > 99 ? res : null;
    }

    public static Pattern wildcard(String wildcard, boolean escapeAllowed, boolean ignoreCase) {
        if (wildcard == null) {
            throw new IllegalArgumentException("wildcard==null");
        }
        StringBuilder sb = new StringBuilder();
        if (ignoreCase) {
            sb.append("(?is)");
        } else {
            sb.append("(?s)");
        }
        if (escapeAllowed) {
            boolean qOpen = false;
            boolean esc = false;
            block5: for (int i = 0; i < wildcard.length(); ++i) {
                char c = wildcard.charAt(i);
                switch (c) {
                    case '?': {
                        if (esc) {
                            if (!qOpen) {
                                sb.append("\\Q");
                                qOpen = true;
                            }
                            sb.append("?");
                            continue block5;
                        }
                        if (qOpen) {
                            sb.append("\\E");
                            qOpen = false;
                        }
                        sb.append(".");
                        continue block5;
                    }
                    case '*': {
                        if (esc) {
                            if (!qOpen) {
                                sb.append("\\Q");
                                qOpen = true;
                            }
                            sb.append("*");
                            continue block5;
                        }
                        if (qOpen) {
                            sb.append("\\E");
                            qOpen = false;
                        }
                        sb.append(".*?");
                        continue block5;
                    }
                    case '\\': {
                        if (esc) {
                            if (!qOpen) {
                                sb.append("\\Q");
                                qOpen = true;
                            }
                            sb.append('\\');
                            esc = false;
                            continue block5;
                        }
                        esc = true;
                        continue block5;
                    }
                    default: {
                        if (!qOpen) {
                            sb.append("\\Q");
                            qOpen = true;
                        }
                        sb.append(c);
                    }
                }
            }
            if (qOpen) {
                sb.append("\\E");
                qOpen = false;
            }
        } else {
            wildcard = wildcard.replace("?", ".");
            wildcard = wildcard.replace("*", ".*?");
            sb.append(wildcard);
        }
        return Pattern.compile(sb.toString());
    }

    public static String format(String format, Number num) {
        if (format == null) {
            throw new IllegalArgumentException("format==null");
        }
        return FullDecFormat.create(format).format(num);
    }

    public static class Predicates {
        private static Pattern _numericPattern = null;

        public static Predicate<String> in(boolean ignoreCase, String ... values) {
            return Predicates.in(ignoreCase, Arrays.asList(values));
        }

        public static Predicate<String> in(final boolean ignoreCase, final Iterable<String> values) {
            if (values == null) {
                throw new IllegalArgumentException("values == null");
            }
            return new Predicate<String>(){

                @Override
                public boolean test(String value) {
                    for (String sample : values) {
                        boolean m;
                        if (!(sample == null ? value == null : (m = ignoreCase ? sample.equalsIgnoreCase(value) : sample.equals(value)))) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        public static Predicate<String> in(final Iterable<String> values, final BiFunction<String, String, Boolean> matcher) {
            if (values == null) {
                throw new IllegalArgumentException("values == null");
            }
            if (matcher == null) {
                throw new IllegalArgumentException("matcher == null");
            }
            return new Predicate<String>(){

                @Override
                public boolean test(String value) {
                    for (String sample : values) {
                        boolean m = (Boolean)matcher.apply(sample, value);
                        if (!m) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        public static Predicate<String> matchRegex(Pattern regex) {
            if (regex == null) {
                throw new IllegalArgumentException("regex == null");
            }
            final Pattern reg = regex;
            return new Predicate<String>(){

                @Override
                public boolean test(String value) {
                    if (value == null) {
                        return false;
                    }
                    return reg.matcher(value).matches();
                }
            };
        }

        public static Predicate<String> equals(String source) {
            final String src = source;
            return new Predicate(){

                public boolean test(Object value) {
                    if (src == null && value == null) {
                        return true;
                    }
                    if (src != null && value == null) {
                        return false;
                    }
                    if (src == null && value != null) {
                        return false;
                    }
                    return src.equals(value);
                }
            };
        }

        public static Predicate<String> equalsIgnoreCase(String source) {
            final String src = source;
            return new Predicate(){

                public boolean test(Object value) {
                    if (src == null && value == null) {
                        return true;
                    }
                    if (src != null && value == null) {
                        return false;
                    }
                    if (src == null && value != null) {
                        return false;
                    }
                    return src.toString().equalsIgnoreCase(((CharSequence)value).toString());
                }
            };
        }

        public static Predicate<String> isNumeric() {
            if (_numericPattern == null) {
                _numericPattern = Pattern.compile("(?is)^\\s*(\\-|\\+)?\\s*\\d+(\\.(\\d+))?\\s*$");
            }
            return Predicates.matchRegex(_numericPattern);
        }
    }

    public static class Convertors {
        public static final Function<String, String> toStringConst = new Function<String, String>(){

            @Override
            public String apply(String from) {
                if (from == null) {
                    return "null";
                }
                String str = Text.encodeStringConstant(from);
                return str;
            }
        };
        public static final Function<String, String> fromStringConst = new Function<String, String>(){

            @Override
            public String apply(String from) {
                if (from == null) {
                    return null;
                }
                if (from.trim().equalsIgnoreCase("null")) {
                    return null;
                }
                ParseStringResult res = Text.parseStringConstat(from, 0);
                if (res == null) {
                    return null;
                }
                return res.decodedString();
            }
        };
        public static final Function<String, String> toLowerCase = new Function<String, String>(){

            @Override
            public String apply(String from) {
                return from.toLowerCase();
            }
        };
        public static final Function<String, String> toUpperCase = new Function<String, String>(){

            @Override
            public String apply(String from) {
                return from.toUpperCase();
            }
        };
        public static final Function<String, String> htmlEncode = new Function<String, String>(){

            @Override
            public String apply(String from) {
                if (from == null) {
                    return null;
                }
                return Text.htmlEncode(from);
            }
        };
        public static final Function<String, String> htmlDecode = new Function<String, String>(){

            @Override
            public String apply(String from) {
                if (from == null) {
                    return null;
                }
                return Text.htmlDecode(from);
            }
        };
        public static final Function<String, String> attrEncode = new Function<String, String>(){

            @Override
            public String apply(String from) {
                if (from == null) {
                    return null;
                }
                return Text.attrEncode(from);
            }
        };

        public static final Function<String, String> map(final Map<String, String> srcMap, final String defValue, final String nullValue) {
            return new Function<String, String>(){

                @Override
                public String apply(String from) {
                    if (from == null) {
                        return defValue;
                    }
                    if (srcMap == null) {
                        return defValue;
                    }
                    if (!srcMap.containsKey(from)) {
                        return defValue;
                    }
                    String v = (String)srcMap.get(from);
                    if (v == null) {
                        return nullValue;
                    }
                    return v;
                }
            };
        }

        public static final Function<String, String> align(final Align align, final String padText, final int len) {
            return new Function<String, String>(){

                @Override
                public String apply(String from) {
                    return Text.align(from, align, padText, len);
                }
            };
        }

        public static Function<String, String> trim(String trimStart, String trimEnd) {
            final String s = trimStart;
            final String e = trimEnd;
            return new Function<String, String>(){

                @Override
                public String apply(String from) {
                    if (from == null) {
                        return from;
                    }
                    if (s != null && s.length() > 0) {
                        from = Text.trimStart(from, s);
                    }
                    if (e != null && e.length() > 0) {
                        from = Text.trimEnd(from, e);
                    }
                    return from;
                }
            };
        }

        public static Function<String, String> sequence(Function<String, String> ... convertors) {
            final Function[] convs = convertors;
            return new Function<String, String>(){

                @Override
                public String apply(String from) {
                    for (Function c : convs) {
                        from = (String)c.apply(from);
                    }
                    return from;
                }
            };
        }

        public static Function<String, String> wrap(Supplier<String> before, Supplier<String> after) {
            final Supplier<String> sbefore = before;
            final Supplier<String> safter = after;
            return new Function<String, String>(){

                @Override
                public String apply(String text) {
                    if (sbefore != null && safter != null) {
                        return (String)sbefore.get() + text + (String)safter.get();
                    }
                    if (sbefore == null && safter != null) {
                        return text + (String)safter.get();
                    }
                    if (sbefore != null && safter == null) {
                        return (String)sbefore.get() + text;
                    }
                    return text;
                }
            };
        }

        public static Function<String, String> wrap(String before, String after) {
            final String sbefore = before;
            final String safter = after;
            return new Function<String, String>(){

                @Override
                public String apply(String text) {
                    if (sbefore != null && safter != null) {
                        return sbefore + text + safter;
                    }
                    if (sbefore == null && safter != null) {
                        return text + safter;
                    }
                    if (sbefore != null && safter == null) {
                        return sbefore + text;
                    }
                    return text;
                }
            };
        }

        public static Function<String, String> newlineReplace(String newLine) {
            final String nl = newLine;
            final StringBuilder sb = new StringBuilder();
            return new Function<String, String>(){

                @Override
                public String apply(String text) {
                    if (text != null) {
                        String[] lines = Text.splitNewLines(text);
                        sb.setLength(0);
                        for (int i = 0; i < lines.length; ++i) {
                            if (i > 0 && nl != null) {
                                sb.append(nl);
                            }
                            sb.append(lines[i]);
                        }
                        return sb.toString();
                    }
                    return text;
                }
            };
        }

        public static Function<String, String> newlineReplace(Supplier<String> newLine) {
            final Supplier<String> nl = newLine;
            final StringBuilder sb = new StringBuilder();
            return new Function<String, String>(){

                @Override
                public String apply(String text) {
                    if (text != null) {
                        String[] lines = Text.splitNewLines(text);
                        sb.setLength(0);
                        for (int i = 0; i < lines.length; ++i) {
                            if (i > 0 && nl != null) {
                                sb.append((String)nl.get());
                            }
                            sb.append(lines[i]);
                        }
                        return sb.toString();
                    }
                    return text;
                }
            };
        }
    }

    public static class SimpleParseResult
    implements ParseStringResult {
        public String decodedString = null;
        public String sourceString = null;
        public int beginIndex = -1;
        public int endIndex = -2;

        @Override
        public String decodedString() {
            return this.decodedString;
        }

        @Override
        public String sourceString() {
            return this.sourceString;
        }

        @Override
        public int beginIndex() {
            return this.beginIndex;
        }

        @Override
        public int endIndex() {
            return this.endIndex;
        }
    }

    public static interface ParseStringResult {
        public String decodedString();

        public String sourceString();

        public int beginIndex();

        public int endIndex();
    }
}

