/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.io.Writer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.text.EndLine;
import xyz.cofe.text.EndLineReWriter;
import xyz.cofe.text.Text;

public class PrefixWriter
extends EndLineReWriter {
    private static final Logger logger = Logger.getLogger(PrefixWriter.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;
    protected Supplier<String> linePrefix;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    public PrefixWriter(Writer writer) {
        super(writer);
    }

    public PrefixWriter(Writer writer, String endl) {
        super(writer, endl);
    }

    public PrefixWriter(Writer writer, EndLine endl) {
        super(writer, endl);
    }

    public synchronized void setLinePrefixFn(Supplier<String> fn) {
        this.linePrefix = fn;
        this.assignLinePrefixFn();
    }

    public synchronized Supplier<String> getLinePrefixFn() {
        return this.linePrefix;
    }

    public synchronized String getLinePrefix() {
        Supplier<String> lPrefix = this.linePrefix;
        if (lPrefix == null) {
            return null;
        }
        try {
            String prefix = lPrefix.get();
            return prefix;
        }
        catch (Throwable err) {
            PrefixWriter.logException(err);
            return null;
        }
    }

    public synchronized void setLinePrefix(String prefix) {
        if (prefix == null) {
            this.linePrefix = null;
            return;
        }
        this.linePrefix = () -> prefix;
        this.assignLinePrefixFn();
    }

    private synchronized void assignLinePrefixFn() {
        if (this.linePrefix == null) {
            this.setLineConvertor(null);
        }
        Supplier<String> prefixValue = new Supplier<String>(){

            @Override
            public String get() {
                return PrefixWriter.this.getLinePrefix();
            }
        };
        Function<String, String> lineConv = Text.Convertors.wrap(prefixValue, null);
        this.setLineConvertor(lineConv);
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

