/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.io.IOException;
import java.io.Writer;
import xyz.cofe.text.PrefixWriter;
import xyz.cofe.text.Text;

public class IndentWriter
extends PrefixWriter {
    private int level = 0;
    private String singleIndentText = "   ";

    public IndentWriter(Writer delegateWriter) {
        super(delegateWriter);
        if (delegateWriter == null) {
            throw new IllegalArgumentException("delegateWriter == null");
        }
    }

    public String getIndent() {
        if (this.singleIndentText == null) {
            this.singleIndentText = "    ";
        }
        return this.singleIndentText;
    }

    public void setIndent(String indent) {
        if (indent == null) {
            indent = "    ";
        }
        this.singleIndentText = indent;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        if (level < 0) {
            level = 0;
        }
        if (this.level != level) {
            this.level = level;
        }
    }

    public void incLevel() {
        this.setLevel(this.getLevel() + 1);
    }

    public void decLevel() {
        this.setLevel(this.getLevel() - 1);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public String getLinePrefix() {
        String ind = this.getIndent();
        int l = this.getLevel();
        if (l > 0 && ind != null) {
            if (l == 1) {
                return ind;
            }
            return Text.repeat(ind, l);
        }
        return null;
    }
}

