/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Stack;
import xyz.cofe.text.EndLine;
import xyz.cofe.text.IndentWriter;
import xyz.cofe.text.StackWriter;

public class IndentStackWriter
extends PrintWriter {
    protected StackWriter stackWriter = null;
    protected IndentWriter indentWriter = null;
    protected Stack<State> stack = new Stack();

    public IndentStackWriter(Writer writer) {
        super(writer);
        this.stackWriter = new StackWriter(writer);
        this.indentWriter = new IndentWriter(this.stackWriter);
        this.out = this.indentWriter;
    }

    public void push() {
        this.stackWriter.push();
        State s = new State();
        s.endl = this.indentWriter.getEndl();
        s.indent = this.indentWriter.getIndent();
        s.level = this.indentWriter.getLevel();
        this.stack.push(s);
        this.indentWriter.setLevel(0);
    }

    public String pop() {
        String res = this.stackWriter.pop();
        if (this.stack.size() > 0) {
            State s = this.stack.pop();
            this.indentWriter.setLevel(s.level);
            this.indentWriter.setEndl(s.endl);
            this.indentWriter.setIndent(s.indent);
        }
        return res;
    }

    public void setLevel(int level) {
        this.indentWriter.setLevel(level);
    }

    public int getLevel() {
        return this.indentWriter.getLevel();
    }

    public void setIndent(String indent) {
        this.indentWriter.setIndent(indent);
    }

    public String getIndent() {
        return this.indentWriter.getIndent();
    }

    public void incLevel() {
        this.indentWriter.incLevel();
    }

    public String getEndl() {
        return this.indentWriter.getEndl();
    }

    public void setEndl(String endl) {
        this.indentWriter.setEndl(endl);
    }

    public void setEndLine(EndLine endline) {
        this.indentWriter.setEndLine(endline);
    }

    public EndLine getEndLine() {
        return this.indentWriter.getEndLine();
    }

    public void decLevel() {
        this.indentWriter.decLevel();
    }

    @Override
    public void close() {
        super.close();
        this.stack.clear();
    }

    public static class State {
        public int level = 0;
        public String endl = null;
        public String indent = null;
    }
}

