/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.table;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.text.table.Border;
import xyz.cofe.text.table.Borders;
import xyz.cofe.text.table.CellFormat;
import xyz.cofe.text.table.CellFormats;
import xyz.cofe.text.table.TableFormat;
import xyz.cofe.text.table.VerticalSplitter;

public class TableFormats {
    private static TableFormat asciiTable = null;
    private static TableFormat unicodeTable = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(TableFormats.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(TableFormats.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(TableFormats.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(TableFormats.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(TableFormats.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(TableFormats.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(TableFormats.class.getName()).log(Level.SEVERE, null, ex);
    }

    public static TableFormat asciiTable() {
        if (asciiTable != null) {
            return asciiTable;
        }
        asciiTable = new TableFormat();
        CellFormat defcf = CellFormats.def().clone();
        defcf.setThreeDots("..");
        Border brdHeader = Borders.asciiLine().clone();
        brdHeader.setBottomText("=");
        VerticalSplitter vspt = new VerticalSplitter();
        vspt.setText("|");
        vspt.setTopText("+");
        vspt.setBottomText("+");
        asciiTable.setDefaultCell(defcf);
        asciiTable.setFirstCell(defcf);
        asciiTable.setMiddleCell(defcf);
        asciiTable.setLastCell(defcf);
        asciiTable.getHeader().setBorder(brdHeader);
        asciiTable.getHeader().setVerticalSplitter(vspt);
        Border brd2 = Borders.asciiLine().clone();
        brd2.setTopHeight(0);
        asciiTable.getFirstRow().setBorder(brd2);
        asciiTable.getFirstRow().setVerticalSplitter(vspt);
        asciiTable.getMiddleRow().setBorder(brd2);
        asciiTable.getMiddleRow().setVerticalSplitter(vspt);
        asciiTable.getLastRow().setBorder(brd2);
        asciiTable.getLastRow().setVerticalSplitter(vspt);
        asciiTable.setBorder(Borders.empty().clone());
        return asciiTable;
    }

    public static TableFormat unicodeTable() {
        if (unicodeTable != null) {
            return unicodeTable;
        }
        unicodeTable = new TableFormat();
        return unicodeTable;
    }

    public static TableBuilder unicode() {
        TableBuilder b = new TableBuilder(TableFormats.unicodeTable().clone());
        return b;
    }

    public static TableBuilder ascii() {
        TableBuilder b = new TableBuilder(TableFormats.asciiTable().clone());
        b.setDefVSplitBottomText("+");
        b.setDefVSplitTopText("+");
        b.setDefVSplitText("|");
        return b;
    }

    public static class TableBuilder {
        private TableFormat tf = null;
        private boolean headerVisible = true;
        private boolean innerHLines = true;
        private boolean innerVLines = true;
        private boolean outerHLines = true;
        private boolean outerVLines = true;
        private Border headerBorder = null;
        private Border firstRowBorder = null;
        private Border middleRowBorder = null;
        private Border lastRowBorder = null;
        private VerticalSplitter vsplit = null;
        private boolean vsplitTextOnly = false;
        private String defVSplitText = "\u2502";
        private String defVSplitTopText = "\u252c";
        private String defVSplitBottomText = "\u2534";

        public String getDefVSplitText() {
            if (this.defVSplitText == null) {
                this.defVSplitText = "\u2502";
            }
            return this.defVSplitText;
        }

        public void setDefVSplitText(String defVsplitText) {
            this.defVSplitText = defVsplitText;
        }

        public String getDefVSplitTopText() {
            if (this.defVSplitTopText == null) {
                this.defVSplitTopText = "\u252c";
            }
            return this.defVSplitTopText;
        }

        public void setDefVSplitTopText(String defVsplitText) {
            this.defVSplitTopText = defVsplitText;
        }

        public String getDefVSplitBottomText() {
            if (this.defVSplitBottomText == null) {
                this.defVSplitBottomText = "\u2534";
            }
            return this.defVSplitBottomText;
        }

        public void setDefVSplitBottomText(String defVsplitText) {
            this.defVSplitBottomText = defVsplitText;
        }

        public TableBuilder(TableFormat tableFormat) {
            if (tableFormat == null) {
                throw new IllegalArgumentException("tableFormat==null");
            }
            this.tf = tableFormat;
            this.headerBorder = tableFormat.getHeader().getBorder().clone();
            this.firstRowBorder = tableFormat.getFirstRow().getBorder().clone();
            this.middleRowBorder = tableFormat.getMiddleRow().getBorder().clone();
            this.lastRowBorder = tableFormat.getLastRow().getBorder().clone();
        }

        public TableFormat get() {
            if (this.vsplit != null) {
                if (this.vsplitTextOnly) {
                    this.tf.getHeader().getVerticalSplitter().setText(this.vsplit.getText());
                    this.tf.getFirstRow().getVerticalSplitter().setText(this.vsplit.getText());
                    this.tf.getMiddleRow().getVerticalSplitter().setText(this.vsplit.getText());
                    this.tf.getLastRow().getVerticalSplitter().setText(this.vsplit.getText());
                } else {
                    this.tf.getHeader().setVerticalSplitter(this.vsplit);
                    this.tf.getFirstRow().setVerticalSplitter(this.vsplit);
                    this.tf.getMiddleRow().setVerticalSplitter(this.vsplit);
                    this.tf.getLastRow().setVerticalSplitter(this.vsplit);
                }
            }
            this.tf.setHeaderVisible(this.headerVisible);
            if (!this.headerVisible) {
                this.tf.getFirstRow().getBorder().setTopHeight(this.headerBorder.getBottomHeigth());
                this.tf.getFirstRow().getBorder().setTopText(this.headerBorder.getTopText());
                this.tf.getFirstRow().getBorder().setLeftTopText(this.headerBorder.getLeftTopText());
                this.tf.getFirstRow().getBorder().setRightTopText(this.headerBorder.getRightTopText());
            }
            if (!this.innerHLines) {
                this.tf.getFirstRow().getBorder().bottomHeigth(0);
                this.tf.getFirstRow().getBorder().topHeight(0);
                this.tf.getMiddleRow().getBorder().bottomHeigth(0);
                this.tf.getMiddleRow().getBorder().topHeight(0);
                this.tf.getLastRow().getBorder().topHeight(0);
            }
            if (!this.innerVLines) {
                this.tf.getHeader().getVerticalSplitter().setWidth(0);
                this.tf.getFirstRow().getVerticalSplitter().setWidth(0);
                this.tf.getMiddleRow().getVerticalSplitter().setWidth(0);
                this.tf.getLastRow().getVerticalSplitter().setWidth(0);
            }
            if (!this.outerHLines) {
                this.tf.getHeader().getBorder().topHeight(0);
                this.tf.getLastRow().getBorder().bottomHeigth(0);
            }
            if (!this.outerVLines) {
                this.tf.getHeader().getBorder().leftWidth(0);
                this.tf.getHeader().getBorder().rightWidth(0);
                this.tf.getFirstRow().getBorder().leftWidth(0);
                this.tf.getFirstRow().getBorder().rightWidth(0);
                this.tf.getMiddleRow().getBorder().leftWidth(0);
                this.tf.getMiddleRow().getBorder().rightWidth(0);
                this.tf.getLastRow().getBorder().leftWidth(0);
                this.tf.getLastRow().getBorder().rightWidth(0);
            }
            if (this.innerHLines && this.vsplitTextOnly && this.vsplit != null) {
                this.tf.getHeader().getVerticalSplitter().setTopText(this.tf.getHeader().getBorder().getTopText());
                this.tf.getHeader().getVerticalSplitter().setBottomText(this.tf.getHeader().getBorder().getBottomText());
                this.tf.getFirstRow().getVerticalSplitter().setTopText(this.tf.getFirstRow().getBorder().getTopText());
                this.tf.getFirstRow().getVerticalSplitter().setBottomText(this.tf.getFirstRow().getBorder().getBottomText());
                this.tf.getMiddleRow().getVerticalSplitter().setTopText(this.tf.getMiddleRow().getBorder().getTopText());
                this.tf.getMiddleRow().getVerticalSplitter().setBottomText(this.tf.getMiddleRow().getBorder().getBottomText());
                this.tf.getLastRow().getVerticalSplitter().setTopText(this.tf.getLastRow().getBorder().getTopText());
                this.tf.getLastRow().getVerticalSplitter().setBottomText(this.tf.getLastRow().getBorder().getBottomText());
            }
            return this.tf;
        }

        public TableBuilder header(boolean visible) {
            this.headerVisible = visible;
            return this;
        }

        public TableBuilder innerHLines(boolean visible) {
            this.innerHLines = visible;
            return this;
        }

        public TableBuilder innerVLines(boolean visible) {
            this.innerVLines = visible;
            return this;
        }

        public TableBuilder outerHLines(boolean visible) {
            this.outerHLines = visible;
            return this;
        }

        public TableBuilder outerVLines(boolean visible) {
            this.outerVLines = visible;
            return this;
        }

        public TableBuilder vsplit(VerticalSplitter vsplit) {
            this.vsplit = vsplit;
            return this;
        }

        public TableBuilder vsplit(int width, String topText, String text, String bottomText) {
            String string = text == null ? this.getDefVSplitText() : (text = text.length() < 1 ? this.getDefVSplitText() : text);
            String string2 = topText == null ? this.getDefVSplitTopText() : (topText = topText.length() < 1 ? this.getDefVSplitTopText() : topText);
            bottomText = bottomText == null ? this.getDefVSplitBottomText() : (bottomText.length() < 1 ? this.getDefVSplitBottomText() : bottomText);
            this.vsplit = new VerticalSplitter(width, topText, text, bottomText);
            return this;
        }

        public TableBuilder vsplit(int width, String text) {
            text = text == null ? this.getDefVSplitText() : (text.length() < 1 ? this.getDefVSplitText() : text);
            this.vsplitTextOnly = true;
            this.vsplit = new VerticalSplitter(width, text, text, text);
            return this;
        }

        public TableBuilder vsplit(String text) {
            text = text == null ? this.getDefVSplitText() : (text.length() < 1 ? this.getDefVSplitText() : text);
            this.vsplitTextOnly = true;
            this.vsplit = new VerticalSplitter(text.length(), text, text, text);
            return this;
        }
    }
}

