/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.io.IOException;
import java.io.Writer;
import java.util.function.Function;
import xyz.cofe.text.EndLine;

public class EndLineReWriter
extends Writer {
    protected Writer writer = null;
    protected String endl = System.getProperty("line.separator", "\n");
    private int state = 0;
    private final StringBuilder lineBuffer = new StringBuilder();
    protected Function<String, String> lineConvertor;

    public synchronized String getEndl() {
        return this.endl;
    }

    public synchronized void setEndl(String endl) {
        if (endl == null) {
            endl = System.getProperty("line.separator", "\n");
        }
        this.endl = endl;
    }

    public synchronized void setEndLine(EndLine endline) {
        if (endline == null) {
            endline = EndLine.Default;
        }
        this.endl = endline.get();
    }

    public synchronized EndLine getEndLine() {
        if (this.endl == null) {
            return null;
        }
        if (this.endl.equals(EndLine.Default.get())) {
            return EndLine.Default;
        }
        if (this.endl.equals(EndLine.Linux.get())) {
            return EndLine.Linux;
        }
        if (this.endl.equals(EndLine.Mac.get())) {
            return EndLine.Mac;
        }
        if (this.endl.equals(EndLine.Windows.get())) {
            return EndLine.Windows;
        }
        if (this.endl.equals(EndLine.Other.get())) {
            return EndLine.Other;
        }
        return null;
    }

    public EndLineReWriter(Writer writer) {
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        this.writer = writer;
    }

    public EndLineReWriter(Writer writer, String endl) {
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        if (endl == null) {
            throw new IllegalArgumentException("endl==null");
        }
        this.writer = writer;
        this.endl = endl;
    }

    public EndLineReWriter(Writer writer, EndLine endl) {
        if (writer == null) {
            throw new IllegalArgumentException("writer==null");
        }
        if (endl == null) {
            throw new IllegalArgumentException("endl==null");
        }
        this.writer = writer;
        this.endl = endl.get();
    }

    protected StringBuilder getLineBuffer() {
        return this.lineBuffer;
    }

    private synchronized void lineBufferFlush(Writer to) throws IOException {
        if (this.lineBuffer.length() > 0) {
            to.write(this.lineBuffer.toString());
            this.lineBuffer.setLength(0);
        }
    }

    public synchronized Function<String, String> getLineConvertor() {
        return this.lineConvertor;
    }

    public synchronized void setLineConvertor(Function<String, String> newLineConv) {
        this.lineConvertor = newLineConv;
    }

    protected synchronized void lineBufferFlush(boolean forceConvert) throws IOException {
        if (this.lineConvertor != null && this.lineBuffer != null) {
            String srcline = this.lineBuffer.toString();
            String resline = this.lineConvertor.apply(srcline);
            if (forceConvert) {
                if (resline != null) {
                    this.lineBuffer.setLength(0);
                    this.lineBuffer.append(resline);
                }
            } else if (this.lineBuffer.length() > 0 && resline != null) {
                this.lineBuffer.setLength(0);
                this.lineBuffer.append(resline);
            }
        }
        this.lineBufferFlush(this.writer);
    }

    protected synchronized void lineBufferAppend(char c) {
        this.lineBuffer.append(c);
    }

    @Override
    public synchronized void write(char[] cbuf, int off, int len) throws IOException {
        int idx = -1;
        char[] chars1 = new char[1];
        char[] chars2 = new char[2];
        for (int i = off; i < off + len; ++i) {
            ++idx;
            char c0 = cbuf[i];
            int c1 = i < off + len - 1 ? cbuf[i + 1] : -1;
            chars2[0] = c0;
            chars2[1] = (char)c1;
            chars1[0] = c0;
            if (this.state == 0) {
                if (c0 == '\n' && c1 == 13) {
                    this.lineBufferFlush(true);
                    this.writeEndLine(cbuf, off, len, chars2, ++i - 1);
                    continue;
                }
                if (c0 == '\r' && c1 == 10) {
                    this.lineBufferFlush(true);
                    this.writeEndLine(cbuf, off, len, chars2, ++i - 1);
                    continue;
                }
                if (c0 == '\n' && c1 != 13 && c1 != -1) {
                    this.lineBufferFlush(true);
                    this.writeEndLine(cbuf, off, len, chars1, i);
                    continue;
                }
                if (c0 == '\r' && c1 != 10 && c1 != -1) {
                    this.lineBufferFlush(true);
                    this.writeEndLine(cbuf, off, len, chars1, i);
                    continue;
                }
                if (c0 == '\r' && c1 == -1) {
                    this.state = 1;
                    this.lineBufferFlush(true);
                    this.writeEndLine(cbuf, off, len, chars1, i);
                    continue;
                }
                if (c0 == '\n' && c1 == -1) {
                    this.state = 2;
                    this.lineBufferFlush(true);
                    this.writeEndLine(cbuf, off, len, chars1, i);
                    continue;
                }
                this.lineBufferAppend(c0);
                continue;
            }
            if (this.state == 1) {
                if (c0 == '\n') {
                    this.state = 0;
                    continue;
                }
                if (c0 == '\r') {
                    this.state = 1;
                    this.lineBufferFlush(true);
                    this.writeEndLine(cbuf, off, len, chars1, i);
                    continue;
                }
                this.state = 0;
                this.lineBufferAppend(c0);
                continue;
            }
            if (this.state != 2) continue;
            if (c0 == '\r') {
                this.state = 0;
                continue;
            }
            if (c0 == '\n') {
                this.state = 2;
                this.lineBufferFlush(true);
                this.writeEndLine(cbuf, off, len, chars1, i);
                continue;
            }
            this.state = 0;
            this.lineBufferAppend(c0);
        }
    }

    protected synchronized void writeEndLine() throws IOException {
        this.writer.write(this.getEndl());
    }

    protected synchronized void writeEndLine(char[] cbuff, int coff, int clen, char[] newlineChar, int nlOff) throws IOException {
        this.writeEndLine();
    }

    protected synchronized void writeChar(char c0) throws IOException {
        this.writer.write(c0);
    }

    @Override
    public synchronized void flush() throws IOException {
        this.lineBufferFlush(false);
        this.writer.flush();
    }

    @Override
    public synchronized void close() throws IOException {
        this.writer.close();
    }
}

