/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Convertor;
import xyz.cofe.text.table.Border;
import xyz.cofe.text.table.Borders;
import xyz.cofe.text.table.Bounds;
import xyz.cofe.text.table.CellFormat;
import xyz.cofe.text.table.CellFormatMap;
import xyz.cofe.text.table.CellFormats;
import xyz.cofe.text.table.TextCell;
import xyz.cofe.text.table.VerticalSplitter;

public class RowFormat {
    private Border border = Borders.singleLine().clone();
    private VerticalSplitter verticalSplitter = new VerticalSplitter();
    private CellFormat defaultCell = CellFormats.def().clone();
    private CellFormat firstCell = CellFormats.def().clone();
    private CellFormat lastCell = CellFormats.def().clone();
    private CellFormat middleCell = CellFormats.def().clone();
    private CellFormatMap cellFormatMap = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(RowFormat.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(RowFormat.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(RowFormat.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(RowFormat.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(RowFormat.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(RowFormat.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(RowFormat.class.getName()).log(Level.SEVERE, null, ex);
    }

    public RowFormat() {
    }

    public RowFormat(RowFormat src) {
        if (src != null) {
            this.border = src.border != null ? src.border.clone() : this.border;
            this.verticalSplitter = src.verticalSplitter != null ? src.verticalSplitter.clone() : this.verticalSplitter;
            this.defaultCell = src.defaultCell != null ? src.defaultCell.clone() : this.defaultCell;
            this.firstCell = src.firstCell != null ? src.firstCell.clone() : this.firstCell;
            this.lastCell = src.lastCell != null ? src.lastCell.clone() : this.lastCell;
            CellFormat cellFormat = this.middleCell = src.middleCell != null ? src.middleCell.clone() : this.middleCell;
            if (src.cellFormatMap != null) {
                this.cellFormatMap = src.cellFormatMap.clone();
            }
        }
    }

    public RowFormat clone() {
        return new RowFormat(this);
    }

    public Border getBorder() {
        if (this.border == null) {
            this.border = Borders.singleLine().clone();
        }
        return this.border;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public VerticalSplitter getVerticalSplitter() {
        if (this.verticalSplitter != null) {
            return this.verticalSplitter;
        }
        this.verticalSplitter = new VerticalSplitter();
        return this.verticalSplitter;
    }

    public void setVerticalSplitter(VerticalSplitter verticalSplitter) {
        this.verticalSplitter = verticalSplitter;
    }

    public CellFormat getDefaultCell() {
        if (this.defaultCell != null) {
            return this.defaultCell;
        }
        this.defaultCell = CellFormats.def().clone();
        return this.defaultCell;
    }

    public void setDefaultCell(CellFormat defaultCell) {
        this.defaultCell = defaultCell;
    }

    public CellFormat getFirstCell() {
        if (this.firstCell != null) {
            return this.firstCell;
        }
        this.firstCell = CellFormats.def().clone();
        return this.firstCell;
    }

    public void setFirstCell(CellFormat firstCell) {
        this.firstCell = firstCell;
    }

    public CellFormat getLastCell() {
        if (this.lastCell != null) {
            return this.lastCell;
        }
        this.lastCell = CellFormats.def().clone();
        return this.lastCell;
    }

    public void setLastCell(CellFormat lastCell) {
        this.lastCell = lastCell;
    }

    public CellFormat getMiddleCell() {
        if (this.middleCell != null) {
            return this.middleCell;
        }
        this.middleCell = CellFormats.def().clone();
        return this.middleCell;
    }

    public void setMiddleCell(CellFormat middleCell) {
        this.middleCell = middleCell;
    }

    public CellFormatMap getCellFormatMap() {
        if (this.cellFormatMap != null) {
            return this.cellFormatMap;
        }
        this.cellFormatMap = new CellFormatMap();
        return this.cellFormatMap;
    }

    public void setCellFormatMap(CellFormatMap cellFormatMap) {
        this.cellFormatMap = cellFormatMap;
    }

    public List<String> format(String ... data) {
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        final String[] fdata = data;
        Convertor<Integer, CellFormat> c = new Convertor<Integer, CellFormat>(){

            public CellFormat convert(Integer from) {
                if (from == null) {
                    return RowFormat.this.getDefaultCell();
                }
                int colIdx = from;
                CellFormat cf = (CellFormat)RowFormat.this.getCellFormatMap().get(colIdx);
                if (cf != null) {
                    return cf;
                }
                if (fdata.length > 1) {
                    if (colIdx == 0) {
                        return RowFormat.this.getFirstCell();
                    }
                    if (colIdx == fdata.length - 1) {
                        return RowFormat.this.getLastCell();
                    }
                    return RowFormat.this.getMiddleCell();
                }
                return RowFormat.this.getDefaultCell();
            }
        };
        return this.format(data, c);
    }

    public List<String> format(String[] data, String[] columnNames) {
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != null) continue;
            data[i] = "";
        }
        if (columnNames != null && data.length < columnNames.length) {
            int addCo = columnNames.length - data.length;
            for (int i = 0; i < addCo; ++i) {
                data = Arrays.copyOf(data, data.length + 1);
                data[data.length - 1] = "";
            }
        }
        final String[] fdata = data;
        final String[] colNames = columnNames;
        Convertor<Integer, CellFormat> c = new Convertor<Integer, CellFormat>(){

            public CellFormat convert(Integer from) {
                CellFormat[] cfByName;
                if (from == null) {
                    return RowFormat.this.getDefaultCell();
                }
                CellFormat cf = RowFormat.this.getDefaultCell();
                int colIdx = from;
                if (fdata.length > 1) {
                    cf = colIdx == 0 ? RowFormat.this.getFirstCell() : (colIdx == fdata.length - 1 ? RowFormat.this.getLastCell() : RowFormat.this.getMiddleCell());
                }
                String colName = colNames == null ? Integer.toString(colIdx) : (colIdx >= 0 && colIdx < colNames.length ? (colNames[colIdx] != null ? colNames[colIdx] : Integer.toString(colIdx)) : Integer.toString(colIdx));
                CellFormat[] cfByIndex = RowFormat.this.getCellFormatMap().getByIndex(colIdx);
                if (cfByIndex != null) {
                    for (CellFormat cfi : cfByIndex) {
                        cf = cf.merge(cfi);
                    }
                }
                if ((cfByName = RowFormat.this.getCellFormatMap().getByName(colName)) != null) {
                    for (CellFormat cfn : cfByName) {
                        cf = cf.merge(cfn);
                    }
                }
                return cf;
            }
        };
        return this.format(data, c);
    }

    public List<String> format(String[] data, Map<Integer, CellFormat> cellFormatter) {
        final Map<Integer, CellFormat> fc = cellFormatter;
        Convertor<Integer, CellFormat> c = new Convertor<Integer, CellFormat>(){

            public CellFormat convert(Integer from) {
                return (CellFormat)fc.get(from);
            }
        };
        return this.format(data, c);
    }

    public List<String> format(String[] data, Convertor<Integer, CellFormat> cellFormatter) {
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        if (cellFormatter == null) {
            throw new IllegalArgumentException("cellFormatter==null");
        }
        TextCell[] dataCells = new TextCell[data.length];
        CellFormat[] cellFormats = new CellFormat[data.length];
        for (int i = 0; i < dataCells.length; ++i) {
            TextCell tc;
            CellFormat cf = (CellFormat)cellFormatter.convert((Object)i);
            dataCells[i] = tc = cf.getCellBuilder().build(data[i]);
            cellFormats[i] = cf;
        }
        Bounds dataBounds = Bounds.get(dataCells);
        TextCell[] borderCells = new TextCell[dataCells.length];
        for (int i = 0; i < data.length; ++i) {
            borderCells[i] = cellFormats[i].build(dataCells[i].getTextLines(), dataBounds.getHeight());
        }
        ArrayList<TextCell> rowCells = new ArrayList<TextCell>();
        HashMap<TextCell, Boolean> isRowSplitter = new HashMap<TextCell, Boolean>();
        int splitterWidth = this.getVerticalSplitter().getWidth();
        if (borderCells.length > 1 && splitterWidth > 0) {
            TextCell[] borderCellsBounds = Bounds.get(borderCells);
            TextCell splitter = TextCell.createBlock(this.getVerticalSplitter().getText(), splitterWidth, borderCellsBounds.getHeight());
            rowCells.add(borderCells[0]);
            isRowSplitter.put(borderCells[0], Boolean.FALSE);
            for (int i = 1; i < borderCells.length; ++i) {
                TextCell borderCell = borderCells[i];
                rowCells.add(splitter);
                isRowSplitter.put(splitter, Boolean.TRUE);
                rowCells.add(borderCell);
                isRowSplitter.put(borderCell, Boolean.FALSE);
            }
        } else {
            rowCells.addAll(Arrays.asList(borderCells));
            for (TextCell tc : borderCells) {
                isRowSplitter.put(tc, Boolean.FALSE);
            }
        }
        TextCell rowContent = TextCell.joinAsTextCell(rowCells);
        Border outBorder = this.getBorder();
        Bounds rowContentBounds = Bounds.get(rowContent);
        ArrayList<TextCell> outTopCells = new ArrayList<TextCell>();
        if (outBorder.getTopHeight() > 0) {
            if (outBorder.getLeftWidth() > 0) {
                outTopCells.add(outBorder.getLeftTopCell());
            }
            for (TextCell tc : rowCells) {
                Boolean isSplt = (Boolean)isRowSplitter.get(tc);
                if (splitterWidth > 0 && isSplt.booleanValue()) {
                    TextCell splt = TextCell.createBlock(this.getVerticalSplitter().getTopText(), splitterWidth, outBorder.getTopHeight());
                    outTopCells.add(splt);
                    continue;
                }
                Bounds b = Bounds.get(tc);
                TextCell horzLine = outBorder.getTopCell(b);
                outTopCells.add(horzLine);
            }
            if (outBorder.getRightWidth() > 0) {
                outTopCells.add(outBorder.getRightTopCell());
            }
        }
        ArrayList<TextCell> outInnCells = new ArrayList<TextCell>();
        if (rowContentBounds.getHeight() > 0) {
            TextCell b;
            if (outBorder.getLeftWidth() > 0) {
                b = outBorder.getLeftCell(rowContentBounds);
                outInnCells.add(b);
            }
            outInnCells.add(rowContent);
            if (outBorder.getRightWidth() > 0) {
                b = outBorder.getRightCell(rowContentBounds);
                outInnCells.add(b);
            }
        }
        ArrayList<TextCell> outBottomCells = new ArrayList<TextCell>();
        if (outBorder.getBottomHeigth() > 0) {
            if (outBorder.getLeftWidth() > 0) {
                outBottomCells.add(outBorder.getLeftBottomCell());
            }
            for (TextCell tc : rowCells) {
                if (splitterWidth > 0 && ((Boolean)isRowSplitter.get(tc)).booleanValue()) {
                    TextCell splt = TextCell.createBlock(this.getVerticalSplitter().getBottomText(), splitterWidth, outBorder.getBottomHeigth());
                    outBottomCells.add(splt);
                    continue;
                }
                Bounds b = Bounds.get(tc);
                TextCell horzLine = outBorder.getBottomCell(b);
                outBottomCells.add(horzLine);
            }
            if (outBorder.getRightWidth() > 0) {
                outBottomCells.add(outBorder.getRightBottomCell());
            }
        }
        List<String> outList = TextCell.joinAsList(outTopCells);
        outList.addAll(TextCell.joinAsList(outInnCells));
        outList.addAll(TextCell.joinAsList(outBottomCells));
        return outList;
    }
}

