/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.text.Text;
import xyz.cofe.text.table.Bounds;
import xyz.cofe.text.table.TextCell;

public class Border {
    private transient TextCell leftTopCell = null;
    private transient TextCell rightTopCell = null;
    private transient TextCell leftBottomCell = null;
    private transient TextCell rightBottomCell = null;
    private transient TextCell topCell = null;
    private transient Integer topCellWidth = null;
    private transient TextCell bottomCell = null;
    private transient Integer bottomCellWidth = null;
    private transient TextCell leftCell = null;
    private transient Integer leftCellHeight = null;
    private transient TextCell rightCell = null;
    private transient Integer rightCellHeight = null;
    private String leftText = null;
    private String rightText = null;
    private String bottomText = null;
    private String topText = null;
    private String leftTopText = null;
    private String rightTopText = null;
    private String leftBottomText = null;
    private String rightBottomText = null;
    private int leftWidth = 0;
    private int rightWidth = 0;
    private int topHeight = 0;
    private int bottomHeigth = 0;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(Border.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(Border.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(Border.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(Border.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(Border.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(Border.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(Border.class.getName()).log(Level.SEVERE, null, ex);
    }

    public Border() {
    }

    public Border(Border src) {
        if (src != null) {
            this.leftText = src.leftText;
            this.rightText = src.rightText;
            this.topText = src.topText;
            this.bottomText = src.bottomText;
            this.leftTopText = src.leftTopText;
            this.rightTopText = src.rightTopText;
            this.leftBottomText = src.leftBottomText;
            this.rightBottomText = src.rightBottomText;
            this.leftWidth = src.leftWidth;
            this.rightWidth = src.rightWidth;
            this.topHeight = src.topHeight;
            this.bottomHeigth = src.bottomHeigth;
        }
    }

    public synchronized Border clone() {
        return new Border(this);
    }

    public synchronized boolean isEmpty() {
        return this.getLeftWidth() == 0 && this.getRightWidth() == 0 && this.getTopHeight() == 0 && this.getBottomHeigth() == 0;
    }

    public synchronized TextCell getLeftTopCell() {
        if (this.leftTopCell != null) {
            return this.leftTopCell;
        }
        this.leftTopCell = TextCell.createBlock(this.leftTopText, this.getLeftWidth(), this.getTopHeight());
        return this.leftTopCell;
    }

    public synchronized TextCell getRightTopCell() {
        if (this.rightTopCell != null) {
            return this.rightTopCell;
        }
        this.rightTopCell = TextCell.createBlock(this.rightTopText, this.getRightWidth(), this.getTopHeight());
        return this.rightTopCell;
    }

    public synchronized TextCell getLeftBottomCell() {
        if (this.leftBottomCell != null) {
            return this.leftBottomCell;
        }
        this.leftBottomCell = TextCell.createBlock(this.leftBottomText, this.getLeftWidth(), this.getBottomHeigth());
        return this.leftBottomCell;
    }

    public synchronized TextCell getRightBottomCell() {
        if (this.rightBottomCell != null) {
            return this.rightBottomCell;
        }
        this.rightBottomCell = TextCell.createBlock(this.rightBottomText, this.getRightWidth(), this.getBottomHeigth());
        return this.rightBottomCell;
    }

    public synchronized TextCell getTopCell(int width) {
        if (this.topCellWidth != null && this.topCellWidth == width && this.topCell != null) {
            return this.topCell;
        }
        this.topCell = TextCell.createBlock(this.topText, width, this.getTopHeight());
        this.topCellWidth = width;
        return this.topCell;
    }

    public synchronized TextCell getTopCell(Bounds b) {
        int w = b.getWidth();
        return this.getTopCell(w);
    }

    public synchronized TextCell getBottomCell(int width) {
        if (this.bottomCellWidth != null && this.bottomCellWidth == width && this.bottomCell != null) {
            return this.bottomCell;
        }
        this.bottomCell = TextCell.createBlock(this.bottomText, width, this.getBottomHeigth());
        this.bottomCellWidth = width;
        return this.bottomCell;
    }

    public synchronized TextCell getBottomCell(Bounds b) {
        return this.getBottomCell(b.getWidth());
    }

    public synchronized TextCell getLeftCell(int height) {
        if (this.leftCellHeight != null && this.leftCellHeight == height && this.leftCell != null) {
            return this.leftCell;
        }
        this.leftCell = TextCell.createBlock(this.leftText, this.getLeftWidth(), height);
        this.leftCellHeight = height;
        return this.leftCell;
    }

    public synchronized TextCell getLeftCell(Bounds b) {
        return this.getLeftCell(b.getHeight());
    }

    public synchronized TextCell getRightCell(int height) {
        if (this.rightCellHeight != null && this.rightCellHeight == height && this.rightCell != null) {
            return this.rightCell;
        }
        this.rightCell = TextCell.createBlock(this.rightText, this.getRightWidth(), height);
        this.rightCellHeight = height;
        return this.rightCell;
    }

    public synchronized TextCell getRightCell(Bounds b) {
        return this.getRightCell(b.getHeight());
    }

    public static ArrayList<String> format(TextCell cell, Border border) {
        if (cell == null) {
            throw new IllegalArgumentException("cell==null");
        }
        if (border == null) {
            throw new IllegalArgumentException("border==null");
        }
        return Border.format(cell.getTextLines(), border);
    }

    public static ArrayList<String> format(Iterable<String> lines, Border border) {
        if (lines == null) {
            throw new IllegalArgumentException("lines==null");
        }
        if (border == null) {
            throw new IllegalArgumentException("border==null");
        }
        if (lines instanceof Collection) {
            Collection c = (Collection)lines;
            return Border.format(c.toArray(new String[0]), border);
        }
        ArrayList<String> l = new ArrayList<String>();
        for (String s : lines) {
            l.add(s);
        }
        return Border.format(l.toArray(new String[0]), border);
    }

    public static ArrayList<String> format(String[] lines, Border border) {
        if (lines == null) {
            throw new IllegalArgumentException("lines==null");
        }
        if (border == null) {
            throw new IllegalArgumentException("border==null");
        }
        ArrayList<String> res = new ArrayList<String>();
        Bounds b = Bounds.get(lines);
        if (border.getTopHeight() > 0) {
            TextCell tLT = border.getLeftTopCell();
            TextCell tT = border.getTopCell(b);
            TextCell tRT = border.getRightTopCell();
            res.addAll(TextCell.joinAsList(tLT, tT, tRT));
        }
        if (lines.length > 0) {
            TextCell tL = border.getLeftCell(lines.length);
            TextCell tR = border.getRightCell(lines.length);
            String[] lL = tL.getTextLines();
            String[] lR = tR.getTextLines();
            StringBuilder sb = new StringBuilder();
            for (int y = 0; y < lines.length; ++y) {
                sb.setLength(0);
                if (y < lL.length) {
                    sb.append(lL[y]);
                } else {
                    sb.append(Text.repeat(" ", border.getLeftWidth()));
                }
                sb.append(lines[y]);
                if (y < lR.length) {
                    sb.append(lR[y]);
                } else {
                    sb.append(Text.repeat(" ", border.getRightWidth()));
                }
                res.add(sb.toString());
            }
        }
        if (border.getBottomHeigth() > 0) {
            TextCell tLB = border.getLeftBottomCell();
            TextCell tB = border.getBottomCell(b);
            TextCell tRB = border.getRightBottomCell();
            res.addAll(TextCell.joinAsList(tLB, tB, tRB));
        }
        return res;
    }

    public synchronized String getLeftText() {
        return this.leftText;
    }

    public synchronized void setLeftText(String leftText) {
        this.leftText = leftText;
        this.leftCell = null;
    }

    public synchronized String getRightText() {
        return this.rightText;
    }

    public synchronized void setRightText(String rightText) {
        this.rightText = rightText;
        this.rightCell = null;
    }

    public synchronized String getBottomText() {
        return this.bottomText;
    }

    public synchronized void setBottomText(String bottomText) {
        this.bottomText = bottomText;
        this.bottomCell = null;
    }

    public synchronized String getTopText() {
        return this.topText;
    }

    public synchronized void setTopText(String topText) {
        this.topText = topText;
        this.topCell = null;
    }

    public synchronized String getLeftTopText() {
        return this.leftTopText;
    }

    public synchronized void setLeftTopText(String leftTopText) {
        this.leftTopText = leftTopText;
        this.leftTopCell = null;
    }

    public synchronized String getRightTopText() {
        return this.rightTopText;
    }

    public synchronized void setRightTopText(String rightTopText) {
        this.rightTopText = rightTopText;
        this.rightTopCell = null;
    }

    public synchronized String getLeftBottomText() {
        return this.leftBottomText;
    }

    public synchronized void setLeftBottomText(String leftBottomText) {
        this.leftBottomText = leftBottomText;
        this.leftBottomCell = null;
    }

    public synchronized String getRightBottomText() {
        return this.rightBottomText;
    }

    public synchronized void setRightBottomText(String rightBottomText) {
        this.rightBottomText = rightBottomText;
        this.rightBottomCell = null;
    }

    public synchronized int getLeftWidth() {
        return this.leftWidth;
    }

    public synchronized void setLeftWidth(int leftWidth) {
        this.leftWidth = leftWidth;
        this.leftTopCell = null;
        this.leftBottomCell = null;
        this.leftCell = null;
    }

    public synchronized Border leftWidth(int leftWidth) {
        this.setLeftWidth(leftWidth);
        return this;
    }

    public synchronized int getRightWidth() {
        return this.rightWidth;
    }

    public synchronized void setRightWidth(int rightWidth) {
        this.rightWidth = rightWidth;
        this.rightTopCell = null;
        this.rightBottomCell = null;
        this.rightCell = null;
    }

    public synchronized Border rightWidth(int rightWidth) {
        this.setRightWidth(rightWidth);
        return this;
    }

    public synchronized int getTopHeight() {
        return this.topHeight;
    }

    public synchronized void setTopHeight(int topHeight) {
        this.topHeight = topHeight;
        this.leftTopCell = null;
        this.rightTopCell = null;
        this.topCell = null;
    }

    public synchronized Border topHeight(int topHeight) {
        this.setTopHeight(topHeight);
        return this;
    }

    public synchronized int getBottomHeigth() {
        return this.bottomHeigth;
    }

    public synchronized void setBottomHeigth(int bottomHeigth) {
        this.bottomHeigth = bottomHeigth;
        this.leftBottomCell = null;
        this.rightBottomCell = null;
        this.bottomCell = null;
    }

    public synchronized Border bottomHeigth(int bottomHeigth) {
        this.setBottomHeigth(bottomHeigth);
        return this;
    }
}

