/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parser.lex;

import xyz.cofe.collection.Convertor;
import xyz.cofe.text.parser.LexerUtil;
import xyz.cofe.text.parser.TokenParser;
import xyz.cofe.text.parser.lex.Keyword;
import xyz.cofe.text.parser.lex.Keywords;

public class KeywordsParser
implements TokenParser {
    protected String id = null;
    private Keywords keywords = null;
    protected Convertor<String, String> matchedTextConvertor = null;

    public KeywordsParser() {
    }

    public KeywordsParser(String id) {
        this.id = id;
    }

    public KeywordsParser(boolean ignoreCase, String ... keywords) {
        this(keywords, ignoreCase, null);
    }

    public KeywordsParser(String[] keywords, boolean ignoreCase, Convertor<String, String> matchedTextConvertor) {
        if (keywords == null) {
            throw new IllegalArgumentException("keywords==null");
        }
        this.matchedTextConvertor = matchedTextConvertor;
        this.keywords = new Keywords(ignoreCase);
        this.keywords.putAll(keywords);
    }

    public KeywordsParser(Keywords keywords) {
        if (keywords == null) {
            throw new IllegalArgumentException("keywords==null");
        }
        this.keywords = keywords;
    }

    public Keywords getKeywords() {
        if (this.keywords == null) {
            this.keywords = new Keywords();
        }
        return this.keywords;
    }

    public void setKeywords(Keywords keywords) {
        if (keywords == null) {
            keywords = new Keywords();
        }
        this.keywords = keywords;
    }

    public Convertor<String, String> getMatchedTextConvertor() {
        return this.matchedTextConvertor;
    }

    public void setMatchedTextConvertor(Convertor<String, String> matchedTextConvertor) {
        this.matchedTextConvertor = matchedTextConvertor;
    }

    @Override
    public Keyword parse(String source, int offset) {
        Keywords kws = this.getKeywords();
        for (String kwText : kws.getKeywords()) {
            boolean m = LexerUtil.match(source, offset, this.getKeywords().isIgnoreCase(), kwText);
            if (!m) continue;
            Keywords.KeywordDesc desc = kws.get(kwText);
            if (desc != null) {
                return desc.create(source, offset, kwText.length(), this.matchedTextConvertor == null ? kwText : (String)this.matchedTextConvertor.convert((Object)kwText), this.id);
            }
            Keyword kw = new Keyword();
            kw.setSource(source);
            kw.setBegin(offset);
            kw.setLength(kwText.length());
            if (this.matchedTextConvertor != null) {
                kwText = (String)this.matchedTextConvertor.convert((Object)kwText);
            }
            kw.setKeyword(kwText);
            if (this.id != null) {
                kw.setId(this.id);
            }
            return kw;
        }
        return null;
    }
}

