/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parser.lex;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.map.ICaseStringMap;
import xyz.cofe.text.parser.lex.Keyword;

public class Keywords {
    private final Map<String, KeywordDesc> keywords;
    private final boolean ignoreCase;
    private String[] sortedKeyWords = null;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(Keywords.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(Keywords.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(Keywords.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(Keywords.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(Keywords.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(Keywords.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(Keywords.class.getName()).log(Level.SEVERE, null, ex);
    }

    public Keywords() {
        this.keywords = new ICaseStringMap(false);
        this.ignoreCase = false;
    }

    public Keywords(boolean ignoreCase) {
        this.keywords = new ICaseStringMap(ignoreCase);
        this.ignoreCase = ignoreCase;
    }

    public Keywords(Keywords src) {
        this.ignoreCase = src == null ? false : src.ignoreCase;
        this.keywords = new ICaseStringMap(this.ignoreCase);
        if (src != null) {
            for (Map.Entry<String, KeywordDesc> en : src.keywords.entrySet()) {
                String k = en.getKey();
                KeywordDesc desc = en.getValue();
                this.put(k, desc);
            }
        }
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public Keywords clone() {
        return new Keywords(this);
    }

    public void putAll(String ... kw) {
        this.putAll(Arrays.asList(kw));
    }

    public void putAll(Iterable<String> kw) {
        if (kw != null) {
            for (String k : kw) {
                if (k == null) continue;
                this.put(k);
            }
        }
    }

    public Keywords put(String keyword, KeywordDesc desc) {
        if (keyword == null) {
            throw new IllegalArgumentException("keyword==null");
        }
        if (desc == null) {
            throw new IllegalArgumentException("desc==null");
        }
        this.keywords.put(keyword, desc);
        this.sortedKeyWords = null;
        return this;
    }

    public Keywords put(String keyword) {
        this.put(keyword, new KeywordDesc());
        return this;
    }

    public Keywords put(String keyword, String id) {
        this.put(keyword, new KeywordDesc(id, null));
        return this;
    }

    public Keywords put(String keyword, Class type) {
        this.put(keyword, new KeywordDesc(null, type));
        return this;
    }

    public Keywords put(String keyword, String id, Class type) {
        this.put(keyword, new KeywordDesc(id, type));
        return this;
    }

    public void remove(String keyword) {
        this.sortedKeyWords = null;
        this.keywords.remove(keyword);
    }

    public Keywords clear() {
        this.sortedKeyWords = null;
        this.keywords.clear();
        return this;
    }

    public KeywordDesc get(String keyword) {
        return this.keywords.get(keyword);
    }

    private String[] getSortedKeyWords() {
        if (this.sortedKeyWords != null) {
            return this.sortedKeyWords;
        }
        String[] kw = this.keywords.keySet().toArray(new String[0]);
        this.sortedKeyWords = Keywords.sortKeywordsArray(kw, this.ignoreCase);
        return this.sortedKeyWords;
    }

    public String[] getKeywords() {
        return this.getSortedKeyWords();
    }

    private static String[] sortKeywordsArray(String[] keywords, boolean ignoreCase) {
        final boolean ic = ignoreCase;
        int direction = -1;
        TreeSet<String> kw = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null && o2 != null) {
                    return -1;
                }
                if (o1 != null && o2 == null) {
                    return 1;
                }
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o1.length() < o2.length()) {
                    return 1;
                }
                if (ic) {
                    return o1.compareToIgnoreCase(o2) * -1;
                }
                return o1.compareTo(o2) * -1;
            }
        });
        for (String k : keywords) {
            if (k == null) continue;
            kw.add(k);
        }
        keywords = kw.toArray(new String[0]);
        return keywords;
    }

    public static class KeywordDesc {
        public String id = null;
        public Class type = null;

        public KeywordDesc() {
        }

        public KeywordDesc(KeywordDesc src) {
            if (src != null) {
                this.id = src.id;
                this.type = src.type;
            }
        }

        public KeywordDesc clone() {
            return new KeywordDesc(this);
        }

        public KeywordDesc(String id, Class type) {
            this.id = id;
            this.type = type;
        }

        public Keyword create(String source, int offset, int len, String keywordText, String id) {
            Keyword kw = null;
            if (this.type != null) {
                try {
                    Object o = this.type.newInstance();
                    if (o instanceof Keyword) {
                        kw = (Keyword)o;
                    }
                }
                catch (InstantiationException ex) {
                    Logger.getLogger(Keywords.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(Keywords.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (kw == null) {
                kw = new Keyword();
            }
            if (this.id != null) {
                kw.setId(this.id);
            }
            if (id != null) {
                kw.setId(id);
            }
            kw.setSource(source);
            kw.setBegin(offset);
            kw.setLength(len);
            if (keywordText != null) {
                kw.setKeyword(keywordText);
            }
            return kw;
        }
    }
}

