/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.parser;

public class Token {
    protected int begin;
    protected int length;
    protected String source;
    protected String id = null;

    public Token() {
    }

    public Token(String id, String source, int begin, int len) {
        this.id = id;
        this.source = source;
        this.begin = begin;
        this.length = len;
    }

    protected Token(Token src) {
        if (src != null) {
            this.id = src.id;
            this.begin = src.begin;
            this.length = src.length;
            this.source = src.source;
        }
    }

    public Token clone() {
        return new Token(this);
    }

    public int getBegin() {
        return this.begin;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getMatchedText() {
        if (this.source == null) {
            throw new IllegalStateException("source==null");
        }
        if (this.begin < 0) {
            throw new IllegalStateException("begin<0");
        }
        if (this.length < 0) {
            throw new IllegalStateException("length<0");
        }
        if (this.begin + this.length > this.source.length()) {
            throw new IllegalStateException("begin+length>source.length()");
        }
        if (this.length == 0) {
            return "";
        }
        return this.source.substring(this.begin, this.begin + this.length);
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.getClass().getSimpleName();
        }
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

