/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class CharListRO
implements List<Character> {
    protected String source = null;
    protected int from = -1;
    protected int length = -1;

    public CharListRO(String source, int from, int length) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        if (from < 0) {
            throw new IllegalArgumentException("from<0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length<0");
        }
        if (length > 0 && from + length > source.length()) {
            new IllegalArgumentException("from(" + from + ")+length(" + length + ")>source.length()({" + source.length() + "})");
        }
        this.source = source;
        this.from = from;
        this.length = length;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Character) {
            Character c = (Character)o;
            for (int i = this.from; i < this.from + this.length; ++i) {
                char c2 = this.source.charAt(i);
                if (c2 != c.charValue()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<Character> iterator() {
        return new CharIterator(this.source, this.from, this.length);
    }

    @Override
    public Object[] toArray() {
        Object[] carr = new Character[this.length];
        if (this.length == 0) {
            return carr;
        }
        for (int i = 0; i < this.length; ++i) {
            carr[i] = Character.valueOf(this.source.charAt(i + this.from));
        }
        return carr;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a instanceof Character[]) {
            Character[] carr = new Character[this.length];
            if (this.length == 0) {
                return carr;
            }
            for (int i = 0; i < this.length; ++i) {
                carr[i] = Character.valueOf(this.source.charAt(i + this.from));
            }
            return carr;
        }
        return null;
    }

    @Override
    public boolean add(Character e) {
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        for (Object o : coll) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Character> c) {
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Character> c) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public Character get(int index) {
        if (index < 0) {
            return null;
        }
        if (index > this.length - 1) {
            return null;
        }
        return Character.valueOf(this.source.charAt(index + this.from));
    }

    @Override
    public Character set(int index, Character element) {
        return null;
    }

    @Override
    public void add(int index, Character element) {
    }

    @Override
    public Character remove(int index) {
        return null;
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof Character)) {
            return -1;
        }
        Character c = (Character)o;
        for (int i = 0; i < this.length; ++i) {
            char c2 = this.source.charAt(i + this.from);
            if (c.charValue() != c2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!(o instanceof Character)) {
            return -1;
        }
        Character c = (Character)o;
        for (int i = this.length - 1; i >= 0; --i) {
            char c2 = this.source.charAt(i + this.from);
            if (c.charValue() != c2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<Character> listIterator() {
        return new CharIterator(this.source, this.from, this.length);
    }

    @Override
    public ListIterator<Character> listIterator(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index<0");
        }
        if (index > this.length) {
            throw new IllegalArgumentException("index>length");
        }
        return new CharIterator(this.source, this.from + index, this.length - index);
    }

    @Override
    public List<Character> subList(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex > toIndex");
        }
        if (fromIndex < 0) {
            throw new IllegalArgumentException("fromIndex < 0");
        }
        if (toIndex > this.length) {
            throw new IllegalArgumentException("toIndex > length");
        }
        int newLen = toIndex - fromIndex;
        return new CharListRO(this.source, fromIndex + this.from, newLen);
    }

    public static class CharIterator
    implements ListIterator<Character> {
        protected String src = null;
        protected int offset = -1;
        protected Character chr = null;
        protected int from = -1;
        protected int length = -1;

        public CharIterator(String source, int from, int length) {
            if (source == null) {
                throw new IllegalArgumentException("source==null");
            }
            this.src = source;
            if (from < 0) {
                throw new IllegalArgumentException("from<0");
            }
            if (length < 0) {
                throw new IllegalArgumentException("length<0");
            }
            if (length > 0 && from + length > source.length()) {
                new IllegalArgumentException("from(" + from + ")+length(" + length + ")>source.length()(" + source.length() + ")");
            }
            this.from = from;
            this.length = length;
            if (length > 0) {
                this.chr = Character.valueOf(this.src.charAt(from));
                this.offset = 0;
            } else {
                this.offset = -2;
            }
        }

        @Override
        public boolean hasNext() {
            return this.chr != null;
        }

        @Override
        public Character next() {
            Character res = this.chr;
            if (this.offset >= 0 && this.offset < this.length) {
                ++this.offset;
                if (this.offset >= 0 && this.offset < this.length) {
                    this.chr = Character.valueOf(this.src.charAt(this.offset + this.from));
                }
            }
            return res;
        }

        @Override
        public void remove() {
        }

        @Override
        public boolean hasPrevious() {
            return this.offset > 0;
        }

        @Override
        public Character previous() {
            if (this.offset > 0) {
                --this.offset;
                this.chr = Character.valueOf(this.src.charAt(this.offset + this.from));
                return this.chr;
            }
            return null;
        }

        @Override
        public int nextIndex() {
            return this.offset;
        }

        @Override
        public int previousIndex() {
            return this.offset - 1;
        }

        @Override
        public void set(Character e) {
        }

        @Override
        public void add(Character e) {
        }
    }
}

