/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.text.template;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import xyz.cofe.collection.Func0;
import xyz.cofe.collection.Func1;
import xyz.cofe.text.EndLine;
import xyz.cofe.text.ast.AstNode;
import xyz.cofe.text.template.AlignFormatBuilder;
import xyz.cofe.text.template.FormatBuilder;
import xyz.cofe.text.template.PropertyAccessResolver;
import xyz.cofe.text.template.TemplateParser;
import xyz.cofe.typeconv.ExtendedCastGraph;
import xyz.cofe.typeconv.TypeCastGraph;
import xyz.cofe.types.FieldController;

public class BasicTemplate {
    private String source = null;
    private AstNode tree = null;
    private TemplateParser parser = null;
    private static WeakHashMap<String, EasyTemplate> cache = new WeakHashMap();

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(BasicTemplate.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(BasicTemplate.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(BasicTemplate.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(BasicTemplate.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(BasicTemplate.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(BasicTemplate.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(BasicTemplate.class.getName()).log(Level.SEVERE, null, ex);
    }

    public BasicTemplate(String template) {
        if (template == null) {
            throw new IllegalArgumentException("template==null");
        }
        this.source = template;
        this.parser = new TemplateParser();
        this.tree = this.parser.parse(template);
    }

    public BasicTemplate(BasicTemplate src) {
        if (src == null) {
            throw new IllegalArgumentException("src==null");
        }
        this.tree = src.tree;
        this.parser = src.parser;
        this.source = src.source;
    }

    public String getSource() {
        return this.source;
    }

    public AstNode getAst() {
        return this.tree;
    }

    public TemplateParser getParser() {
        return this.parser;
    }

    public Func0<String> evalAndPrint(Func1<String, String> evalCode) {
        if (evalCode == null) {
            throw new IllegalArgumentException("evalCode==null");
        }
        return this.parser.evalAndPrint(this.tree, evalCode);
    }

    public Func0<String> evalAndPrint(Func1<String, String> evalText, Func1<String, String> evalCode) {
        if (evalText == null) {
            throw new IllegalArgumentException("evalText==null");
        }
        if (evalCode == null) {
            throw new IllegalArgumentException("evalCode==null");
        }
        return this.parser.evalAndPrint(this.tree, evalText, evalCode);
    }

    public BasicTemplate clone() {
        return new BasicTemplate(this);
    }

    public String eval(Object context) {
        Object ctx = context;
        Context<?> cctx = this.context(ctx.getClass()).build();
        cctx.context = ctx;
        Func0<String> ev = this.parser.evalAndPrint(this.tree, (Func1<String, String>)((Context)cctx).evalCode);
        return (String)ev.apply();
    }

    public <T> ContextBuilder<T> context(Class<T> ctx) {
        return new ContextBuilder<T>(ctx);
    }

    public static EasyTemplate template(String template) {
        if (template == null) {
            throw new IllegalArgumentException("template==null");
        }
        EasyTemplate et = cache.get(template);
        if (et == null) {
            et = new EasyTemplate(template);
            cache.put(template, et);
        }
        return et;
    }

    public static class EasyTemplate
    extends BasicTemplate {
        private LinkedHashMap<String, Object> contextVars = new LinkedHashMap();
        private boolean align = false;
        private boolean javascript = false;
        private Writer writer = null;
        private boolean flushWriter = false;
        private String endln = EndLine.Default.get();

        public EasyTemplate(String template) {
            super(template);
        }

        public EasyTemplate bind(String varName, Object varValue) {
            if (varName != null) {
                this.contextVars.put(varName, varValue);
            }
            return this;
        }

        public EasyTemplate align() {
            this.align = true;
            return this;
        }

        public EasyTemplate outputFlushing() {
            this.flushWriter = true;
            return this;
        }

        public EasyTemplate endLine(String endl) {
            this.endln = endl;
            return this;
        }

        public EasyTemplate useJavaScript() {
            this.javascript = true;
            return this;
        }

        public EasyTemplate output(Writer writer) {
            this.writer = writer;
            return this;
        }

        public EasyTemplate output(OutputStream output) {
            return this.output(output, null);
        }

        public EasyTemplate output(OutputStream output, Charset cs) {
            if (output == null) {
                throw new IllegalArgumentException("output==null");
            }
            if (cs == null) {
                cs = Charset.defaultCharset();
            }
            this.writer = new OutputStreamWriter(output, cs);
            return this;
        }

        public String eval() {
            ContextBuilder<?> ctxb = this.context(this.contextVars.getClass());
            if (this.align) {
                ctxb = ctxb.align();
            }
            if (this.contextVars != null && !this.contextVars.isEmpty()) {
                for (Map.Entry<String, Object> ve : this.contextVars.entrySet()) {
                    String varn = ve.getKey();
                    if (varn == null) continue;
                    ctxb = ctxb.bind(varn, ve.getValue());
                }
            }
            if (this.javascript) {
                ctxb = ctxb.useJavaScript();
            }
            Context<?> ctx = ctxb.build();
            return ctx.eval(this.contextVars);
        }

        public void println() {
            if (this.writer != null) {
                try {
                    this.writer.write(this.eval());
                    if (this.endln != null) {
                        this.writer.write(this.endln);
                    }
                    if (this.flushWriter) {
                        this.writer.flush();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(BasicTemplate.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                System.out.println(this.eval());
            }
        }

        public void print() {
            if (this.writer != null) {
                try {
                    this.writer.write(this.eval());
                    if (this.flushWriter) {
                        this.writer.flush();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(BasicTemplate.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                System.out.print(this.eval());
            }
        }
    }

    public class ContextBuilder<T> {
        private Class<T> ctx;
        private TypeCastGraph typecast = null;
        private boolean useScript = false;
        private String scriptLang = "JavaScript";
        private Map<String, Object> bindings = new LinkedHashMap<String, Object>();
        private FormatBuilder formatBuilder = null;

        public ContextBuilder(Class<T> context) {
            this.ctx = context;
        }

        public ContextBuilder<T> bind(String name, Object ref) {
            if (name == null) {
                throw new IllegalArgumentException("name==null");
            }
            this.bindings.put(name, ref);
            return this;
        }

        public ContextBuilder<T> useJavaScript() {
            this.useScript = true;
            this.scriptLang = "JavaScript";
            return this;
        }

        public ContextBuilder<T> align() {
            this.formatBuilder = new AlignFormatBuilder();
            return this;
        }

        public ContextBuilder<T> typeCast(TypeCastGraph typeCast) {
            this.typecast = typeCast;
            return this;
        }

        public Context<T> build() {
            Context<T> co = new Context<T>(this.typecast, BasicTemplate.this, this.ctx);
            co.setUsingScriptEngine(this.useScript);
            co.setScriptLanguage(this.scriptLang);
            co.getBindings().putAll(this.bindings);
            co.setFormatBuilder(this.formatBuilder);
            return co;
        }
    }

    public static class Context<T> {
        protected T context;
        protected final Func0<String> evalFun;
        protected final TypeCastGraph typeCast;
        private boolean usingScriptEngine = false;
        private String scriptLanguage = "JavaScript";
        private Map<String, Object> bindings = null;
        private PropertyAccessResolver resolver = null;
        private boolean allowToString = true;
        private FormatBuilder formatBuilder = null;
        private Func0 lasyEvalFunc = null;
        private Func1<String, String> evalCode = new Func1<String, String>(){

            public String apply(String code) {
                try {
                    if (Context.this.usingScriptEngine) {
                        Object val = Context.this.evalCodeByScript(Context.this.context, code, Context.this.getScriptLanguage());
                        if (val == null) {
                            return "null";
                        }
                        if (Context.this.allowToString) {
                            try {
                                String str = (String)Context.this.typeCast.cast(val, String.class);
                                return str;
                            }
                            catch (Throwable t) {
                                return val.toString();
                            }
                        }
                        String str = (String)Context.this.typeCast.cast(val, String.class);
                        return str;
                    }
                    Object val = Context.this.getVarValueByName(code);
                    if (val == null) {
                        return "null";
                    }
                    if (Context.this.allowToString) {
                        try {
                            String str = (String)Context.this.typeCast.cast(val, String.class);
                            return str;
                        }
                        catch (Throwable t) {
                            return val.toString();
                        }
                    }
                    String str = (String)Context.this.typeCast.cast(val, String.class);
                    return str;
                }
                catch (Throwable ex) {
                    Logger.getLogger(BasicTemplate.class.getName()).log(Level.SEVERE, null, ex);
                    return ex.getMessage();
                }
            }
        };
        private ScriptEngine scriptEngine = null;
        private ScriptEngineManager scriptEngineManager = null;

        public Context(TypeCastGraph typeCast, BasicTemplate template, Class<T> clazz) {
            if (typeCast == null) {
                typeCast = new ExtendedCastGraph();
            }
            this.typeCast = typeCast;
            if (template == null) {
                throw new IllegalArgumentException("template==null");
            }
            if (clazz == null) {
                throw new IllegalArgumentException("clazz==null");
            }
            this.context = null;
            this.resolver = new PropertyAccessResolver(clazz);
            this.evalFun = this.lasyEvalFunc(template);
        }

        public Map<String, Object> getBindings() {
            if (this.bindings != null) {
                return this.bindings;
            }
            this.bindings = new LinkedHashMap<String, Object>();
            return this.bindings;
        }

        public void setBindings(Map<String, Object> bindings) {
            this.bindings = bindings;
        }

        public boolean isUsingScriptEngine() {
            return this.usingScriptEngine;
        }

        public void setUsingScriptEngine(boolean usingScriptEngine) {
            this.usingScriptEngine = usingScriptEngine;
        }

        public String getScriptLanguage() {
            if (this.scriptLanguage == null) {
                this.scriptLanguage = "JavaScript";
            }
            return this.scriptLanguage;
        }

        public void setScriptLanguage(String scriptLanguage) {
            this.scriptLanguage = scriptLanguage;
        }

        public boolean isAllowToString() {
            return this.allowToString;
        }

        public void setAllowToString(boolean allowToString) {
            this.allowToString = allowToString;
        }

        public String eval(T context) {
            this.context = context;
            return (String)this.evalFun.apply();
        }

        public FormatBuilder getFormatBuilder() {
            return this.formatBuilder;
        }

        public void setFormatBuilder(FormatBuilder formatBuilder) {
            this.formatBuilder = formatBuilder;
        }

        private Func0 lasyEvalFunc(final BasicTemplate template) {
            return new Func0(){

                public Object apply() {
                    if (Context.this.lasyEvalFunc != null) {
                        return Context.this.lasyEvalFunc.apply();
                    }
                    if (Context.this.formatBuilder != null) {
                        final Func1 f1 = Context.this.formatBuilder.build(template, new Func1<Object, T>(){

                            public Object apply(T arg) {
                                Context.this.context = arg;
                                return null;
                            }
                        }, (Func1<String, String>)Context.this.evalCode);
                        Context.this.lasyEvalFunc = new Func0(){

                            public Object apply() {
                                return f1.apply(Context.this.context);
                            }
                        };
                        return Context.this.lasyEvalFunc.apply();
                    }
                    Context.this.lasyEvalFunc = template.getParser().evalAndPrint(template.getAst(), (Func1<String, String>)Context.this.evalCode);
                    return Context.this.lasyEvalFunc.apply();
                }
            };
        }

        public ScriptEngine getScriptEngine() {
            if (this.scriptEngine != null) {
                return this.scriptEngine;
            }
            if (!this.usingScriptEngine) {
                return null;
            }
            this.scriptEngine = this.getScriptEngineManager().getEngineByName(this.getScriptLanguage());
            return this.scriptEngine;
        }

        public void setScriptEngine(ScriptEngine scriptEngine) {
            this.scriptEngine = scriptEngine;
        }

        public ScriptEngineManager getScriptEngineManager() {
            if (this.scriptEngineManager != null) {
                return this.scriptEngineManager;
            }
            if (!this.usingScriptEngine) {
                return null;
            }
            this.scriptEngineManager = new ScriptEngineManager();
            return this.scriptEngineManager;
        }

        public void setScriptEngineManager(ScriptEngineManager scriptEngineManager) {
            this.scriptEngineManager = scriptEngineManager;
        }

        private Object evalCodeByScript(Object ctx, String code, String lang) {
            String n;
            ScriptEngine se = this.getScriptEngine();
            Bindings bnd = se.getBindings(100);
            if (ctx instanceof Map) {
                for (Map.Entry<Object, Object> entry : ((Map)ctx).entrySet()) {
                    Map.Entry<Object, Object> en;
                    Object oKey;
                    if (!(entry instanceof Map.Entry) || (oKey = (en = entry).getKey()) == null) continue;
                    Object oValue = en.getValue();
                    if (!(oKey instanceof String)) continue;
                    bnd.put((String)oKey, oValue);
                }
            }
            for (Map.Entry<Object, Object> entry : this.resolver.getFields().entrySet()) {
                n = (String)entry.getKey();
                FieldController fc = (FieldController)entry.getValue();
                fc.setOwner(ctx);
                try {
                    Object v = fc.getValue();
                    bnd.put(n, v);
                }
                catch (Throwable ex) {
                    Logger.getLogger(BasicTemplate.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            for (Map.Entry<Object, Object> entry : this.resolver.getProperties().entrySet()) {
                n = (String)entry.getKey();
                PropertyDescriptor pd = (PropertyDescriptor)entry.getValue();
                Method readMethod = pd.getReadMethod();
                if (readMethod == null) continue;
                try {
                    Object v = readMethod.invoke(ctx, new Object[0]);
                    bnd.put(n, v);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(BasicTemplate.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(BasicTemplate.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InvocationTargetException ex) {
                    Logger.getLogger(BasicTemplate.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            for (Map.Entry<Object, Object> entry : this.getBindings().entrySet()) {
                bnd.put((String)entry.getKey(), entry.getValue());
            }
            try {
                Object v = se.eval(code);
                return v;
            }
            catch (ScriptException ex) {
                Logger.getLogger(BasicTemplate.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }

        private Object getVarValueByName(String name) {
            if (name == null) {
                return null;
            }
            String nm = name.trim();
            if (nm.contains(".")) {
                String[] nidx = name.split("\\s*\\.\\s*");
                return this.resolver.resolve(this.context, nidx);
            }
            return this.resolver.resolve(this.context, name);
        }
    }
}

