/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.unix.utils;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TextUtil {
    private static void logFine(String message, Object ... args) {
        Logger.getLogger(TextUtil.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(TextUtil.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(TextUtil.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(TextUtil.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(TextUtil.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(TextUtil.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(TextUtil.class.getName()).log(Level.SEVERE, null, ex);
    }

    public static String[] splitNewLines(String line) {
        if (line == null) {
            throw new IllegalArgumentException("line==null");
        }
        int idx = 0;
        int len = line.length();
        StringBuilder buff = new StringBuilder();
        ArrayList<String> lines = new ArrayList<String>();
        while (idx < len) {
            char c2;
            char c1 = line.charAt(idx);
            char c = c2 = idx < len - 1 ? line.charAt(idx + 1) : (char)'\u0000';
            if (c1 == '\r' && c2 == '\n') {
                lines.add(buff.toString());
                buff.setLength(0);
                idx += 2;
                continue;
            }
            if (c1 == '\n' && c2 == '\r') {
                lines.add(buff.toString());
                buff.setLength(0);
                idx += 2;
                continue;
            }
            if (c1 == '\r' && c2 != '\n') {
                lines.add(buff.toString());
                buff.setLength(0);
                ++idx;
                continue;
            }
            if (c1 == '\n' && c2 != '\r') {
                lines.add(buff.toString());
                buff.setLength(0);
                ++idx;
                continue;
            }
            buff.append(c1);
            ++idx;
        }
        lines.add(buff.toString());
        return lines.toArray(new String[0]);
    }

    public static String getHex(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes==null");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(TextUtil.getHex(bytes[i]));
        }
        return sb.toString();
    }

    public static String getHex(byte byteValue) {
        return Integer.toString((byteValue & 0xFF) + 256, 16).substring(1).toUpperCase();
    }

    public static String encodeHex(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes==null");
        }
        return TextUtil.getHex(bytes);
    }

    public static byte[] decodeHex(String bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("bytes==null");
        }
        int len = bytes.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(bytes.charAt(i), 16) << 4) + Character.digit(bytes.charAt(i + 1), 16));
        }
        return data;
    }

    public static String trimStart(String text, String trimText) {
        int cutlength;
        if (text == null) {
            throw new IllegalArgumentException("text == null");
        }
        if (trimText == null) {
            throw new IllegalArgumentException("trimText == null");
        }
        if (trimText.length() < 1 || text.length() < 1) {
            return text;
        }
        String result = text;
        while (result.length() > 0 && result.startsWith(trimText) && (cutlength = trimText.length()) <= result.length()) {
            if (cutlength == result.length()) {
                result = "";
                break;
            }
            result = result.substring(cutlength);
        }
        return result;
    }

    public static String trimEnd(String text, String trimText) {
        int endindex;
        if (text == null) {
            throw new IllegalArgumentException("text == null");
        }
        if (trimText == null) {
            throw new IllegalArgumentException("trimText == null");
        }
        if (trimText.length() < 1 || text.length() < 1) {
            return text;
        }
        String result = text;
        while (result.length() > 0 && result.endsWith(trimText) && (endindex = result.length() - trimText.length()) >= 0) {
            result = result.substring(0, endindex);
        }
        return result;
    }
}

