/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.unix.linux;

import java.io.File;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.cofe.unix.linux.TcpSocket;
import xyz.cofe.unix.linux.UdpSocket;
import xyz.cofe.unix.utils.FileUtil;
import xyz.cofe.unix.utils.Func1;
import xyz.cofe.unix.utils.TextUtil;

public class Socket {
    protected int sl = 0;
    protected String f_local_address = null;
    protected String f_rem_address = null;
    protected int st = 0;
    protected String f_tx_queue = null;
    protected String f_rx_queue = null;
    protected String f_tr = null;
    protected String f_tm_when = null;
    protected String f_retrnsmt = null;
    protected int uid = 0;
    protected String f_timeout = null;
    protected long inode = 0L;
    protected InetSocketAddress localAddress = null;
    protected boolean parseLocalAddr = true;
    protected InetSocketAddress remoteAddress = null;
    protected boolean parseRemoteAddr = true;
    private static final String hex = "[0-9a-fA-F]";
    private static final Pattern ptrn = Pattern.compile("(?is)^\\s*(\\d+):\\s+(([0-9a-fA-F]+):([0-9a-fA-F]+))\\s+(([0-9a-fA-F]+):([0-9a-fA-F]+))\\s+([0-9a-fA-F]+)\\s+((\\w+):(\\w+))\\s+((\\w+):(\\w+))\\s+(\\w+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+).*");

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(Socket.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(Socket.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(Socket.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(Socket.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(Socket.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(Socket.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(Socket.class.getName()).log(Level.SEVERE, null, ex);
    }

    protected Socket(ParsedSocketLine parsedLine) {
        this.sl = parsedLine.sl;
        this.f_local_address = parsedLine.f_local_address;
        this.f_rem_address = parsedLine.f_rem_address;
        this.st = parsedLine.st;
        this.f_tx_queue = parsedLine.f_tx_queue;
        this.f_rx_queue = parsedLine.f_rx_queue;
        this.f_tr = parsedLine.f_tr;
        this.f_tm_when = parsedLine.f_tm_when;
        this.f_retrnsmt = parsedLine.f_retrnsmt;
        this.uid = parsedLine.uid;
        this.f_timeout = parsedLine.f_timeout;
        this.inode = parsedLine.inode;
    }

    public InetSocketAddress getLocalAddress() {
        if (this.localAddress != null) {
            return this.localAddress;
        }
        if (!this.parseLocalAddr) {
            return null;
        }
        String[] strs = this.f_local_address.split(":", 2);
        if (strs != null && strs.length == 2) {
            byte[] ip = TextUtil.decodeHex(strs[0]);
            byte[] reord_ip = new byte[ip.length];
            for (int i = 0; i < reord_ip.length; ++i) {
                reord_ip[i] = ip[ip.length - i - 1];
            }
            int port = Integer.parseInt(strs[1], 16);
            try {
                InetAddress addr = InetAddress.getByAddress(reord_ip);
                this.localAddress = new InetSocketAddress(addr, port);
            }
            catch (UnknownHostException ex) {
                Socket.logException(ex);
                this.parseLocalAddr = false;
            }
        }
        return this.localAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        if (this.remoteAddress != null) {
            return this.remoteAddress;
        }
        if (!this.parseRemoteAddr) {
            return null;
        }
        String[] strs = this.f_rem_address.split(":", 2);
        if (strs != null && strs.length == 2) {
            byte[] ip = TextUtil.decodeHex(strs[0]);
            byte[] reord_ip = new byte[ip.length];
            for (int i = 0; i < reord_ip.length; ++i) {
                reord_ip[i] = ip[ip.length - i - 1];
            }
            int port = Integer.parseInt(strs[1], 16);
            try {
                InetAddress addr = InetAddress.getByAddress(reord_ip);
                this.remoteAddress = new InetSocketAddress(addr, port);
            }
            catch (UnknownHostException ex) {
                Socket.logException(ex);
                this.parseRemoteAddr = false;
            }
        }
        return this.remoteAddress;
    }

    public long getInode() {
        return this.inode;
    }

    protected static List<Socket> createSnapshot(Func1<Socket, ParsedSocketLine> createSocketObj, String ... fileNames) {
        ArrayList<Socket> sockets = new ArrayList<Socket>();
        ArrayList<String[]> matched = new ArrayList<String[]>();
        for (String fileName : fileNames) {
            String socketTxt;
            File file = new File(fileName);
            if (!file.exists() || (socketTxt = FileUtil.readAsString(file)) == null) continue;
            String[] flines = TextUtil.splitNewLines(socketTxt);
            for (int lineIdx = 1; lineIdx < flines.length; ++lineIdx) {
                String fline = flines[lineIdx];
                Matcher mtch = ptrn.matcher(fline);
                if (!mtch.matches()) continue;
                int grpCount = mtch.groupCount();
                String[] groups = new String[grpCount + 1];
                for (int g = 0; g <= grpCount; ++g) {
                    groups[g] = mtch.group(g);
                }
                matched.add(groups);
            }
        }
        for (String[] mtch : matched) {
            String f_sl = mtch[1];
            int sl = Integer.parseInt(f_sl);
            String f_local_address = mtch[2];
            String f_rem_address = mtch[5];
            String f_st = mtch[8];
            int st = Integer.parseInt(TextUtil.trimStart(f_st, "0"), 16);
            String f_tx_queue = mtch[10];
            String f_rx_queue = mtch[11];
            String f_tr = mtch[13];
            String f_tr_when = mtch[14];
            String f_retrnsmt = mtch[15];
            String f_uid = mtch[16];
            int uid = Integer.parseInt(f_uid);
            String f_timeout = mtch[17];
            String f_inode = mtch[18];
            long inode = Long.parseLong(f_inode);
            ParsedSocketLine pSocLine = new ParsedSocketLine();
            pSocLine.sl = sl;
            pSocLine.f_local_address = f_local_address;
            pSocLine.f_rem_address = f_rem_address;
            pSocLine.st = st;
            pSocLine.f_tx_queue = f_tx_queue;
            pSocLine.f_rx_queue = f_rx_queue;
            pSocLine.f_tr = f_tr;
            pSocLine.f_tm_when = f_tr_when;
            pSocLine.f_retrnsmt = f_retrnsmt;
            pSocLine.uid = uid;
            pSocLine.f_timeout = f_timeout;
            pSocLine.inode = inode;
            sockets.add(createSocketObj.apply(pSocLine));
        }
        return sockets;
    }

    public static List<Socket> createSnapshot() {
        List<TcpSocket> tcpSockets = TcpSocket.createTcpSnapshot();
        List<UdpSocket> udpSockets = UdpSocket.createUdpSnapshot();
        ArrayList<Socket> res = new ArrayList<Socket>();
        for (TcpSocket ts : tcpSockets) {
            res.add(ts);
        }
        for (UdpSocket us : udpSockets) {
            res.add(us);
        }
        return res;
    }

    protected static class ParsedSocketLine {
        public int sl;
        public String f_local_address;
        public String f_rem_address;
        public int st;
        public String f_tx_queue;
        public String f_rx_queue;
        public String f_tr;
        public String f_tm_when;
        public String f_retrnsmt;
        public int uid;
        public String f_timeout;
        public long inode;

        protected ParsedSocketLine() {
        }
    }
}

