/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.unix.linux;

import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.cofe.unix.linux.Process;

public class ProcessList
extends ArrayList<Process> {
    private static Pattern procFileNamePattern = Pattern.compile("^(\\d+)$");

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(ProcessList.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(ProcessList.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(ProcessList.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(ProcessList.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(ProcessList.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(ProcessList.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(ProcessList.class.getName()).log(Level.SEVERE, null, ex);
    }

    public Process getProcessByPID(int pid) {
        for (Process p : this) {
            if (p.getPID() != pid) continue;
            return p;
        }
        return null;
    }

    private static File getProcDirectory() {
        return new File("/proc");
    }

    private static Pattern getProcFileNamePattern() {
        return procFileNamePattern;
    }

    private Process createProcessFrom(File f) {
        if (f == null) {
            return null;
        }
        return Process.createFrom(this, f);
    }

    public static ProcessList createSnapshot() {
        ProcessList res = new ProcessList();
        File procDir = ProcessList.getProcDirectory();
        Pattern procFileNamePtrn = ProcessList.getProcFileNamePattern();
        if (procDir != null && procDir.exists()) {
            for (File f : procDir.listFiles()) {
                String fileName = f.getName();
                if (procFileNamePtrn != null) {
                    Process p;
                    Matcher m = procFileNamePtrn.matcher(fileName);
                    if (!m.matches() || (p = res.createProcessFrom(f)) == null) continue;
                    res.add(p);
                    continue;
                }
                Process p = res.createProcessFrom(f);
                if (p == null) continue;
                res.add(p);
            }
        }
        return res;
    }
}

