/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.unix.linux;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.cofe.unix.libc.FileStat;
import xyz.cofe.unix.libc.FileStatMode;
import xyz.cofe.unix.libc.UnixFileIO;
import xyz.cofe.unix.utils.FileUtil;

public class FileDescriptor {
    private static UnixFileIO io = new UnixFileIO();
    protected String target = null;
    protected String path = null;
    protected boolean isSocket = false;
    protected boolean isPipe = false;
    protected long socketInode = 0L;
    protected long pipeInode = 0L;
    protected static final Pattern socketPattern = Pattern.compile("(?is)^socket:\\[(\\d+)\\].*");
    protected static final Pattern pipePattern = Pattern.compile("(?is)^pipe:\\[(\\d+)\\].*");

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(FileDescriptor.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(FileDescriptor.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(FileDescriptor.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(FileDescriptor.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(FileDescriptor.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(FileDescriptor.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(FileDescriptor.class.getName()).log(Level.SEVERE, null, ex);
    }

    public FileDescriptor(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path==null");
        }
        this.path = path;
        FileStat fstat = null;
        try {
            fstat = io.lstat(path);
        }
        catch (Throwable ex) {
            fstat = null;
        }
        if (fstat != null) {
            int mode = fstat.getMode();
            if (FileStatMode.isSymbolicLink(fstat)) {
                try {
                    this.target = io.readlink(path);
                }
                catch (Throwable ex) {
                    this.target = null;
                }
            } else if (FileStatMode.isRegularFile(fstat)) {
                this.target = FileUtil.readAsString(path);
            }
        }
        if (this.target != null) {
            Matcher mSocket = socketPattern.matcher(this.target);
            Matcher mPipe = pipePattern.matcher(this.target);
            if (mSocket.matches()) {
                this.isSocket = true;
                this.socketInode = Long.parseLong(mSocket.group(1));
            } else if (mPipe.matches()) {
                this.isPipe = true;
                this.pipeInode = Long.parseLong(mPipe.group(1));
            }
        }
    }

    public FileDescriptor(File path) {
        this(path.toString());
    }

    public String getDesc() {
        return new File(this.path).getName();
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isSocket() {
        return this.isSocket;
    }

    public boolean isPipe() {
        return this.isPipe;
    }

    public long getSocketInode() {
        return this.socketInode;
    }

    public long getPipeInode() {
        return this.pipeInode;
    }
}

