/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.unix.libc;

import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.unix.libc.GroupInfo;
import xyz.cofe.unix.libc.UserInfo;
import xyz.cofe.unix.libc.jna.Group;
import xyz.cofe.unix.libc.jna.LibC;
import xyz.cofe.unix.libc.jna.Passwd;

public class UserGroupInfo {
    private static final Object syncObj = LibC.class;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(UserGroupInfo.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(UserGroupInfo.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(UserGroupInfo.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(UserGroupInfo.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(UserGroupInfo.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(UserGroupInfo.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(UserGroupInfo.class.getName()).log(Level.SEVERE, null, ex);
    }

    private static UserInfo createUser(final Passwd pswd) {
        UserInfo usr = new UserInfo(){

            @Override
            public String getName() {
                return pswd.pw_name;
            }

            @Override
            public int getUID() {
                return pswd.pw_uid;
            }

            @Override
            public int getGID() {
                return pswd.pw_gid;
            }

            @Override
            public String getGECOS() {
                return pswd.pw_gecos;
            }

            @Override
            public String getDir() {
                return pswd.pw_dir;
            }

            @Override
            public String getShell() {
                return pswd.pw_shell;
            }
        };
        return usr;
    }

    private static UserInfo[] getUsers_unsync() {
        Passwd pswd;
        ArrayList<UserInfo> users = new ArrayList<UserInfo>();
        LibC.setpwent();
        while ((pswd = LibC.getpwent()) != null) {
            UserInfo usr = UserGroupInfo.createUser(pswd);
            if (usr == null) continue;
            users.add(usr);
        }
        LibC.endpwent();
        return users.toArray(new UserInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserInfo[] getUsers() {
        Object object = syncObj;
        synchronized (object) {
            return UserGroupInfo.getUsers_unsync();
        }
    }

    private static GroupInfo createGroup(Group grp) {
        final int gid = grp.gr_gid;
        final String name = grp.gr_name;
        String[] users = null;
        Pointer ptrMembers = grp.gr_mem;
        users = ptrMembers != null ? ptrMembers.getStringArray(0L) : new String[]{};
        final String[] fusers = users;
        GroupInfo gr = new GroupInfo(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getGID() {
                return gid;
            }

            @Override
            public String[] getUsers() {
                return fusers;
            }
        };
        return gr;
    }

    private static GroupInfo[] getGroups_unsync() {
        Group g;
        ArrayList<GroupInfo> groups = new ArrayList<GroupInfo>();
        LibC.setgrent();
        while ((g = LibC.getgrent()) != null) {
            GroupInfo grp = UserGroupInfo.createGroup(g);
            if (grp == null) continue;
            groups.add(grp);
        }
        LibC.endpwent();
        return groups.toArray(new GroupInfo[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GroupInfo[] getGroups() {
        Object object = syncObj;
        synchronized (object) {
            return UserGroupInfo.getGroups_unsync();
        }
    }
}

