/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.unix.libc;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.unix.libc.GroupInfo;
import xyz.cofe.unix.libc.UserGroupInfo;
import xyz.cofe.unix.libc.UserInfo;

public class UserGroupData {
    private UserInfo[] usersInfo = null;
    private GroupInfo[] groupsInfo = null;
    private Date refreshDate = null;
    private long maxCahceTime = 900000L;
    private Map<Integer, UserInfo[]> userByID = new HashMap<Integer, UserInfo[]>();
    private Map<Integer, GroupInfo[]> groupByID = new HashMap<Integer, GroupInfo[]>();
    private Map<String, UserInfo[]> userByName = new HashMap<String, UserInfo[]>();
    private Map<String, GroupInfo[]> groupByName = new HashMap<String, GroupInfo[]>();
    private Map<UserInfo, GroupInfo[]> groupByUser = new HashMap<UserInfo, GroupInfo[]>();
    private Map<GroupInfo, UserInfo[]> userByGroup = new HashMap<GroupInfo, UserInfo[]>();

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(UserGroupData.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(UserGroupData.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(UserGroupData.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(UserGroupData.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(UserGroupData.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(UserGroupData.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(UserGroupData.class.getName()).log(Level.SEVERE, null, ex);
    }

    public long getMaxCahceTime() {
        return this.maxCahceTime;
    }

    public void setMaxCahceTime(long maxCahceTime) {
        this.maxCahceTime = maxCahceTime;
    }

    private synchronized void rebuild_userByName() {
        this.userByName.clear();
        for (UserInfo ui : this.usersInfo) {
            UserInfo[] ua;
            String name = ui.getName();
            UserInfo[] userInfoArray = ua = this.userByName.containsKey(name) ? this.userByName.get(name) : null;
            if (ua == null) {
                ua = new UserInfo[]{};
            }
            UserInfo[] nua = Arrays.copyOf(ua, ua.length + 1);
            nua[nua.length - 1] = ui;
            this.userByName.put(name, nua);
        }
    }

    private synchronized void rebuild_groupByName() {
        this.groupByName.clear();
        for (GroupInfo gi : this.groupsInfo) {
            GroupInfo[] ga;
            String name = gi.getName();
            GroupInfo[] groupInfoArray = ga = this.groupByName.containsKey(name) ? this.groupByName.get(name) : null;
            if (ga == null) {
                ga = new GroupInfo[]{};
            }
            GroupInfo[] nga = Arrays.copyOf(ga, ga.length + 1);
            nga[nga.length - 1] = gi;
            this.groupByName.put(name, nga);
        }
    }

    private synchronized void rebuild_userByID() {
        this.userByID.clear();
        for (UserInfo ui : this.usersInfo) {
            UserInfo[] ua;
            int uid = ui.getUID();
            UserInfo[] userInfoArray = ua = this.userByID.containsKey(uid) ? this.userByID.get(uid) : null;
            if (ua == null) {
                ua = new UserInfo[]{};
            }
            UserInfo[] nua = Arrays.copyOf(ua, ua.length + 1);
            nua[nua.length - 1] = ui;
            this.userByID.put(uid, nua);
        }
    }

    private synchronized void rebuild_groupByID() {
        this.groupByID.clear();
        for (GroupInfo gi : this.groupsInfo) {
            GroupInfo[] ga;
            int gid = gi.getGID();
            GroupInfo[] groupInfoArray = ga = this.groupByID.containsKey(gid) ? this.groupByID.get(gid) : null;
            if (ga == null) {
                ga = new GroupInfo[]{};
            }
            GroupInfo[] nga = Arrays.copyOf(ga, ga.length + 1);
            nga[nga.length - 1] = gi;
            this.groupByID.put(gid, nga);
        }
    }

    public synchronized void refresh() {
        this.refreshDate = new Date();
        this.usersInfo = UserGroupInfo.getUsers();
        this.groupsInfo = UserGroupInfo.getGroups();
        this.groupByUser.clear();
        this.userByGroup.clear();
        this.rebuild_userByID();
        this.rebuild_groupByID();
        this.rebuild_userByName();
        this.rebuild_groupByName();
    }

    private synchronized void checkCache() {
        Date now;
        long delta;
        if (this.refreshDate == null) {
            this.refresh();
            return;
        }
        if (this.maxCahceTime == 0L) {
            this.refresh();
            return;
        }
        if (this.maxCahceTime > 0L && (delta = (now = new Date()).getTime() - this.refreshDate.getTime()) > 0L && delta > this.maxCahceTime) {
            this.refresh();
            return;
        }
    }

    public UserInfo[] getUserInfos() {
        this.checkCache();
        return this.usersInfo;
    }

    public GroupInfo[] getGroupInfos() {
        this.checkCache();
        return this.groupsInfo;
    }

    public UserInfo getUserInfoByID(int uid) {
        this.checkCache();
        if (this.userByID.containsKey(uid)) {
            UserInfo[] ua = this.userByID.get(uid);
            if (ua != null && ua.length > 0) {
                return ua[0];
            }
            return null;
        }
        return null;
    }

    public UserInfo getUserInfoByName(String name) {
        UserInfo[] ua;
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        this.checkCache();
        if (this.userByName.containsKey(name) && (ua = this.userByName.get(name)) != null && ua.length > 0) {
            return ua[0];
        }
        return null;
    }

    public UserInfo[] getUsersInfoByID(int uid) {
        this.checkCache();
        if (this.userByID.containsKey(uid)) {
            UserInfo[] ua = this.userByID.get(uid);
            return ua;
        }
        return new UserInfo[0];
    }

    public UserInfo[] getUsersInfoByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        this.checkCache();
        if (this.userByName.containsKey(name)) {
            UserInfo[] ua = this.userByName.get(name);
            return ua;
        }
        return new UserInfo[0];
    }

    public GroupInfo getGroupInfoByID(int gid) {
        this.checkCache();
        if (this.groupByID.containsKey(gid)) {
            GroupInfo[] ga = this.groupByID.get(gid);
            if (ga != null && ga.length > 0) {
                return ga[0];
            }
            return null;
        }
        return null;
    }

    public GroupInfo[] getGroupsInfoByID(int gid) {
        this.checkCache();
        if (this.groupByID.containsKey(gid)) {
            GroupInfo[] ga = this.groupByID.get(gid);
            return ga;
        }
        return new GroupInfo[0];
    }

    public GroupInfo getGroupInfoByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        this.checkCache();
        if (this.groupByName.containsKey(name)) {
            GroupInfo[] ga = this.groupByName.get(name);
            if (ga != null && ga.length > 0) {
                return ga[0];
            }
            return null;
        }
        return null;
    }

    public GroupInfo[] getGroupsInfoByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        this.checkCache();
        if (this.groupByName.containsKey(name)) {
            GroupInfo[] ga = this.groupByName.get(name);
            return ga;
        }
        return new GroupInfo[0];
    }

    public GroupInfo[] getUserGroups(UserInfo ui) {
        if (ui == null) {
            throw new IllegalArgumentException("ui==null");
        }
        if (this.groupByUser.containsKey(ui)) {
            return this.groupByUser.get(ui);
        }
        GroupInfo[] gia = this.getUserGroups_0(ui);
        this.groupByUser.put(ui, gia);
        return gia;
    }

    private GroupInfo[] getUserGroups_0(UserInfo ui) {
        if (ui == null) {
            throw new IllegalArgumentException("ui==null");
        }
        HashSet<GroupInfo> res = new HashSet<GroupInfo>();
        for (GroupInfo gi : this.groupsInfo) {
            if (ui.getGID() == gi.getGID()) {
                res.add(gi);
            }
            String userName = ui.getName();
            for (String gu : gi.getUsers()) {
                if (!userName.equals(gu)) continue;
                res.add(gi);
            }
        }
        return res.toArray(new GroupInfo[0]);
    }

    public UserInfo[] getGroupUsers(GroupInfo gi) {
        if (gi == null) {
            throw new IllegalArgumentException("gi==null");
        }
        if (this.userByGroup.containsKey(gi)) {
            return this.userByGroup.get(gi);
        }
        UserInfo[] uia = this.getGroupUsers_0(gi);
        this.userByGroup.put(gi, uia);
        return uia;
    }

    private UserInfo[] getGroupUsers_0(GroupInfo gi) {
        if (gi == null) {
            throw new IllegalArgumentException("gi==null");
        }
        HashSet<UserInfo> res = new HashSet<UserInfo>();
        for (String gu : gi.getUsers()) {
            UserInfo[] ua;
            if (!this.userByName.containsKey(gu)) continue;
            for (UserInfo ui : ua = this.getUsersInfoByName(gu)) {
                res.add(ui);
            }
        }
        return res.toArray(new UserInfo[0]);
    }
}

