/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.unix.libc;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jruby.ext.posix.LinuxLibC;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXFactory;
import org.jruby.ext.posix.POSIXHandler;
import xyz.cofe.unix.libc.FileStat;
import xyz.cofe.unix.libc.StdErr;
import xyz.cofe.unix.libc.jna.LibC;

public class UnixFileIO {
    private static POSIX posix = null;
    private static final Object syncObj = LibC.class;
    private Charset cs = null;
    private int readlink_buffSize = 1024;
    private final int readlink_buffSize_inc = 1024;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(UnixFileIO.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(UnixFileIO.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(UnixFileIO.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(UnixFileIO.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(UnixFileIO.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(UnixFileIO.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(UnixFileIO.class.getName()).log(Level.SEVERE, null, ex);
    }

    private static synchronized void initLinuxLibC() {
        if (posix != null) {
            return;
        }
        LinuxLibC libclinux = null;
        POSIXHandler posixHandler = null;
        if (libclinux == null) {
            LinuxLibC libc;
            libclinux = libc = (LinuxLibC)Native.loadLibrary((String)"c", LinuxLibC.class);
        }
        if (posixHandler == null) {
            posixHandler = new POSIXHandler(){

                public void error(POSIX.ERRORS errors, String string) {
                    System.err.println("error( " + errors + ", " + string + " )");
                }

                public void unimplementedError(String string) {
                    System.err.println("unimplementedError( " + string + " )");
                }

                public void warn(POSIXHandler.WARNING_ID wrngd, String string, Object ... os) {
                    System.err.println("warn( " + wrngd + ", " + string + ", " + os + " )");
                }

                public boolean isVerbose() {
                    return false;
                }

                public File getCurrentWorkingDirectory() {
                    return new File(".");
                }

                public String[] getEnv() {
                    return new String[0];
                }

                public InputStream getInputStream() {
                    return System.in;
                }

                public PrintStream getOutputStream() {
                    return System.out;
                }

                public int getPID() {
                    return 2;
                }

                public PrintStream getErrorStream() {
                    return System.err;
                }
            };
        }
        posix = POSIXFactory.getPOSIX(posixHandler, (boolean)true);
    }

    public UnixFileIO() {
        UnixFileIO.initLinuxLibC();
        this.cs = Charset.defaultCharset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getcwd() {
        String dirName = null;
        int errno = 0;
        String errstr = null;
        Object object = syncObj;
        synchronized (object) {
            Pointer ptr = null;
            try {
                ptr = LibC.get_current_dir_name();
                if (ptr == null || Pointer.nativeValue((Pointer)ptr) == 0L) {
                    errno = LibC.errno();
                    errstr = LibC.strerror(errno);
                    throw new StdErr(errno, errstr);
                }
                dirName = ptr.getString(0L);
                if (dirName == null) {
                    errno = LibC.errno();
                    errstr = LibC.strerror(errno);
                    throw new StdErr(errno, errstr);
                }
            }
            finally {
                if (ptr != null) {
                    Native.free((long)Pointer.nativeValue((Pointer)ptr));
                }
            }
        }
        if (errstr != null) {
            throw new StdErr(errno, errstr);
        }
        return dirName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chdir(String dirName) {
        if (dirName == null) {
            throw new IllegalArgumentException("dirName==null");
        }
        int errno = 0;
        String errstr = null;
        Object object = syncObj;
        synchronized (object) {
            int r = LibC.chdir(dirName);
            if (r != 0) {
                errno = LibC.errno();
                errstr = LibC.strerror(errno);
            }
        }
        if (errstr != null) {
            throw new StdErr(errno, errstr);
        }
    }

    public String[] readdir(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path==null");
        }
        File f = new File(path);
        return f.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileStat lstat(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("filename==null");
        }
        org.jruby.ext.posix.FileStat fstat = null;
        Object object = syncObj;
        synchronized (object) {
            fstat = posix.lstat(filename);
            if (fstat == null) {
                int errno = posix.errno();
                throw new StdErr(errno, LibC.strerror(errno));
            }
        }
        return new LinuxFileStatImpl(fstat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readlink(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("fileName==null");
        }
        String result = null;
        Object object = syncObj;
        synchronized (object) {
            ByteBuffer byteBuff;
            int readed;
            int buffsize = this.readlink_buffSize;
            while (true) {
                if ((readed = LibC.readlink(fileName, byteBuff = ByteBuffer.allocate(buffsize), buffsize)) == -1) {
                    int errno = LibC.errno();
                    String errtext = LibC.strerror(errno);
                    throw new StdErr(errno, errtext);
                }
                if (readed != buffsize) break;
                this.readlink_buffSize = buffsize += 1024;
            }
            if (readed < 0) {
                throw new StdErr("readed (return from readlink(\"" + fileName + "\")=" + readed + ") less then zero bytes");
            }
            byte[] bytedata = new byte[readed];
            byteBuff.get(bytedata);
            result = new String(bytedata, this.cs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void symlink(String oldname, String newname) {
        if (oldname == null) {
            throw new IllegalArgumentException("oldname==null");
        }
        if (newname == null) {
            throw new IllegalArgumentException("newname==null");
        }
        Object object = syncObj;
        synchronized (object) {
            boolean succ;
            boolean bl = succ = LibC.symlink(oldname, newname) == 0;
            if (!succ) {
                int errno = LibC.errno();
                String errtext = LibC.strerror(errno);
                throw new StdErr(errno, errtext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlink(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("filename==null");
        }
        Object object = syncObj;
        synchronized (object) {
            boolean succ;
            boolean bl = succ = LibC.unlink(filename) == 0;
            if (!succ) {
                int errno = LibC.errno();
                String errtext = LibC.strerror(errno);
                throw new StdErr(errno, errtext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rmdir(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        Object object = syncObj;
        synchronized (object) {
            boolean succ = false;
            boolean bl = succ = LibC.rmdir(name) == 0;
            if (!succ) {
                int errno = LibC.errno();
                String errtext = LibC.strerror(errno);
                throw new StdErr(errno, errtext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String canonicalizeFileName(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("name==null");
        }
        Object object = syncObj;
        synchronized (object) {
            Pointer ptr = LibC.canonicalize_file_name(filename);
            if (ptr == null) {
                return null;
            }
            if (Pointer.nativeValue((Pointer)ptr) == 0L) {
                return null;
            }
            String name2 = ptr.getString(0L);
            Native.free((long)Pointer.nativeValue((Pointer)ptr));
            return name2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int umask(int umask) {
        int res = 0;
        Object object = syncObj;
        synchronized (object) {
            res = LibC.umask(umask);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mkdir(String name, int mode) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        Object object = syncObj;
        synchronized (object) {
            boolean succ = false;
            boolean bl = succ = LibC.mkdir(name, mode) == 0;
            if (!succ) {
                int errno = LibC.errno();
                String errtext = LibC.strerror(errno);
                throw new StdErr(errno, errtext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chown(String name, int owner, int group) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        boolean succ = false;
        Object object = syncObj;
        synchronized (object) {
            boolean bl = succ = LibC.chown(name, owner, group) == 0;
            if (!succ) {
                int errno = LibC.errno();
                String errtext = LibC.strerror(errno);
                throw new StdErr(errno, errtext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chmod(String name, int mode) {
        if (name == null) {
            throw new IllegalArgumentException("name==null");
        }
        Object object = syncObj;
        synchronized (object) {
            boolean succ = false;
            boolean bl = succ = LibC.chmod(name, mode) == 0;
            if (!succ) {
                int errno = LibC.errno();
                String errtext = LibC.strerror(errno);
                throw new StdErr(errno, errtext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(String oldname, String newname) {
        if (oldname == null) {
            throw new IllegalArgumentException("oldname==null");
        }
        if (newname == null) {
            throw new IllegalArgumentException("newname==null");
        }
        Object object = syncObj;
        synchronized (object) {
            boolean succ = false;
            boolean bl = succ = LibC.rename(oldname, newname) != -1;
            if (!succ) {
                int errno = LibC.errno();
                String errtext = LibC.strerror(errno);
                throw new StdErr(errno, errtext);
            }
        }
    }

    public boolean exists(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("filename==null");
        }
        File f = new File(filename);
        return f.exists();
    }

    private static class LinuxFileStatImpl
    implements FileStat {
        private org.jruby.ext.posix.FileStat stat = null;

        public LinuxFileStatImpl(org.jruby.ext.posix.FileStat stat) {
            this.stat = stat;
        }

        @Override
        public long getSize() {
            return this.stat.st_size();
        }

        @Override
        public int getMode() {
            return this.stat.mode();
        }

        @Override
        public long getINO() {
            return this.stat.ino();
        }

        @Override
        public int getNlink() {
            return this.stat.nlink();
        }

        @Override
        public int getUID() {
            return this.stat.uid();
        }

        @Override
        public int getGID() {
            return this.stat.gid();
        }

        @Override
        public long getAccessTime() {
            return this.stat.atime();
        }

        @Override
        public long getModifyTime() {
            return this.stat.mtime();
        }

        @Override
        public long getCreateTime() {
            return this.stat.ctime();
        }

        @Override
        public long getBlocks() {
            return this.stat.blocks();
        }

        @Override
        public long getBlockSize() {
            return this.stat.blockSize();
        }

        @Override
        public long getDev() {
            return this.stat.dev();
        }

        @Override
        public long getRDev() {
            return this.stat.rdev();
        }

        @Override
        public int getMajor(long dev) {
            return this.stat.major(dev);
        }

        @Override
        public int getMinor(long dev) {
            return this.stat.minor(dev);
        }
    }
}

