/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.unix.libc;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.unix.libc.FileStat;

public class FileStatMode {
    public static final int DIRECTORY = 16384;
    public static final int CHAR_DEVICE = 8192;
    public static final int BLOCK_DEVICE = 24576;
    public static final int REGULAR_FILE = 32768;
    public static final int FIFO = 4096;
    public static final int SYMBOLIC_LINK = 40960;
    public static final int SOCKET = 49152;
    public static final int USER_READ = 256;
    public static final int USER_WRITE = 128;
    public static final int USER_EXEC = 64;
    public static final int GROUP_READ = 32;
    public static final int GROUP_WRITE = 16;
    public static final int GROUP_EXEC = 8;
    public static final int OTHER_READ = 4;
    public static final int OTHER_WRITE = 2;
    public static final int OTHER_EXEC = 1;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(FileStatMode.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(FileStatMode.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(FileStatMode.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(FileStatMode.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(FileStatMode.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(FileStatMode.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(FileStatMode.class.getName()).log(Level.SEVERE, null, ex);
    }

    public static boolean checkFlag(int mode, int flag) {
        return (mode & flag) == flag;
    }

    public static int setFlag(int mode, int flag) {
        return mode | flag;
    }

    public static int resetFlag(int mode, int flag) {
        return mode ^ flag;
    }

    public static boolean isUserRead(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("fstat==null");
        }
        return FileStatMode.checkFlag(fstat.getMode(), 256);
    }

    public static boolean isUserWrite(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("fstat==null");
        }
        return FileStatMode.checkFlag(fstat.getMode(), 128);
    }

    public static boolean isUserExec(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("fstat==null");
        }
        return FileStatMode.checkFlag(fstat.getMode(), 64);
    }

    public static boolean isGroupRead(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("fstat==null");
        }
        return FileStatMode.checkFlag(fstat.getMode(), 32);
    }

    public static boolean isGroupWrite(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("fstat==null");
        }
        return FileStatMode.checkFlag(fstat.getMode(), 16);
    }

    public static boolean isGroupExec(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("fstat==null");
        }
        return FileStatMode.checkFlag(fstat.getMode(), 8);
    }

    public static boolean isOtherRead(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("fstat==null");
        }
        return FileStatMode.checkFlag(fstat.getMode(), 4);
    }

    public static boolean isOtherWrite(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("fstat==null");
        }
        return FileStatMode.checkFlag(fstat.getMode(), 2);
    }

    public static boolean isOtherExec(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("fstat==null");
        }
        return FileStatMode.checkFlag(fstat.getMode(), 1);
    }

    public static boolean isDirectory(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("fstat==null");
        }
        return FileStatMode.checkFlag(fstat.getMode(), 16384);
    }

    public static boolean isCharDevice(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("fstat==null");
        }
        return FileStatMode.checkFlag(fstat.getMode(), 8192);
    }

    public static boolean isBlockDevice(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("fstat==null");
        }
        return FileStatMode.checkFlag(fstat.getMode(), 24576);
    }

    public static boolean isRegularFile(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("fstat==null");
        }
        return FileStatMode.checkFlag(fstat.getMode(), 32768);
    }

    public static boolean isFifo(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("fstat==null");
        }
        return FileStatMode.checkFlag(fstat.getMode(), 4096);
    }

    public static boolean isSymbolicLink(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("fstat==null");
        }
        return FileStatMode.checkFlag(fstat.getMode(), 40960);
    }

    public static boolean isSocket(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("fstat==null");
        }
        return FileStatMode.checkFlag(fstat.getMode(), 49152);
    }

    public static Type getType(FileStat fstat) {
        if (fstat == null) {
            throw new IllegalArgumentException("stat==null");
        }
        if (FileStatMode.isBlockDevice(fstat)) {
            return Type.BlockDevice;
        }
        if (FileStatMode.isCharDevice(fstat)) {
            return Type.CharDevice;
        }
        if (FileStatMode.isFifo(fstat)) {
            return Type.Fifo;
        }
        if (FileStatMode.isSocket(fstat)) {
            return Type.Socket;
        }
        if (FileStatMode.isSymbolicLink(fstat)) {
            return Type.SymbolicLink;
        }
        if (FileStatMode.isDirectory(fstat)) {
            return Type.Directory;
        }
        if (FileStatMode.isRegularFile(fstat)) {
            return Type.RegularFile;
        }
        return Type.Unknow;
    }

    public static enum Type {
        Unknow,
        RegularFile,
        Directory,
        SymbolicLink,
        Socket,
        BlockDevice,
        CharDevice,
        Fifo;

    }
}

