/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.io.fs;

import java.io.IOError;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.cbuffer.SBCBuffer;
import xyz.cofe.io.fs.ClosedChannelError;
import xyz.cofe.io.fs.File;

public class FChannelBuffer
extends SBCBuffer {
    private static final Logger logger = Logger.getLogger(FChannelBuffer.class.getName());
    private static final Level logLevel = logger.getLevel();
    private static final boolean isLogSevere;
    private static final boolean isLogWarning;
    private static final boolean isLogInfo;
    private static final boolean isLogFine;
    private static final boolean isLogFiner;
    private static final boolean isLogFinest;

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(FChannelBuffer.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(FChannelBuffer.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(FChannelBuffer.class.getName(), method, result);
    }

    public FChannelBuffer(FileChannel channel) {
        super((SeekableByteChannel)channel);
    }

    public static FChannelBuffer open(Path path, OpenOption ... options) {
        try {
            FileChannel fc = FileChannel.open(path, options);
            return new FChannelBuffer(fc);
        }
        catch (IOException ex) {
            Logger.getLogger(FChannelBuffer.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public static FChannelBuffer open(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        try {
            FileChannel fc = FileChannel.open(path, options, attrs);
            return new FChannelBuffer(fc);
        }
        catch (IOException ex) {
            Logger.getLogger(FChannelBuffer.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public static FChannelBuffer open(File file, OpenOption ... options) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return FChannelBuffer.open(file.path, options);
    }

    public static FChannelBuffer open(File file, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        if (file == null) {
            throw new IllegalArgumentException("file == null");
        }
        return FChannelBuffer.open(file.path, options, attrs);
    }

    private FileChannel fc() {
        return (FileChannel)this.channel;
    }

    public FileChannel getFileChannel() {
        return this.fc();
    }

    public synchronized FileLock lock() {
        try {
            return this.fc().lock();
        }
        catch (ClosedChannelException ex) {
            throw new ClosedChannelError(ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FChannelBuffer.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public synchronized FileLock lock(long position, long size, boolean shared) {
        try {
            return this.fc().lock(position, size, shared);
        }
        catch (ClosedChannelException ex) {
            throw new ClosedChannelError(ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FChannelBuffer.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public synchronized FileLock tryLock() {
        try {
            return this.fc().tryLock();
        }
        catch (ClosedChannelException ex) {
            throw new ClosedChannelError(ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FChannelBuffer.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public synchronized FileLock tryLock(long position, long size, boolean shared) {
        try {
            return this.fc().tryLock(position, size, shared);
        }
        catch (ClosedChannelException ex) {
            throw new ClosedChannelError(ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FChannelBuffer.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public synchronized void force(boolean metaData) {
        try {
            this.fc().force(metaData);
        }
        catch (ClosedChannelException ex) {
            throw new ClosedChannelError(ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FChannelBuffer.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public synchronized void flush() {
        this.force(true);
        super.flush();
    }

    public synchronized MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) {
        try {
            return this.fc().map(mode, position, size);
        }
        catch (ClosedChannelException ex) {
            throw new ClosedChannelError(ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FChannelBuffer.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public synchronized long transferFrom(ReadableByteChannel src, long position, long count) {
        try {
            return this.fc().transferFrom(src, position, count);
        }
        catch (ClosedChannelException ex) {
            throw new ClosedChannelError(ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FChannelBuffer.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    public synchronized long transferTo(long position, long count, WritableByteChannel target) {
        try {
            return this.fc().transferTo(position, count, target);
        }
        catch (ClosedChannelException ex) {
            throw new ClosedChannelError(ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FChannelBuffer.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOError(ex);
        }
    }

    static {
        boolean bl = logLevel == null ? true : (isLogSevere = logLevel.intValue() <= Level.SEVERE.intValue());
        boolean bl2 = logLevel == null ? true : (isLogWarning = logLevel.intValue() <= Level.WARNING.intValue());
        boolean bl3 = logLevel == null ? true : (isLogInfo = logLevel.intValue() <= Level.INFO.intValue());
        boolean bl4 = logLevel == null ? true : (isLogFine = logLevel.intValue() <= Level.FINE.intValue());
        boolean bl5 = logLevel == null ? true : (isLogFiner = logLevel.intValue() <= Level.FINER.intValue());
        isLogFinest = logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }
}

