/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.io.fs;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.io.fs.DirFollow;

public class DirFollowBuilder {
    private static final Logger logger = Logger.getLogger(DirFollowBuilder.class.getName());
    protected boolean checkCycle = true;
    protected boolean followLinks = true;
    protected DirFollow.ErrorBehavior errorBehavior;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DirFollowBuilder.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(DirFollowBuilder.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DirFollowBuilder.class.getName(), method, result);
    }

    public DirFollowBuilder() {
    }

    public DirFollowBuilder(DirFollowBuilder sample) {
        if (sample != null) {
            this.checkCycle = sample.checkCycle;
            this.followLinks = sample.followLinks;
            this.errorBehavior = sample.errorBehavior;
        }
    }

    public DirFollowBuilder clone() {
        return new DirFollowBuilder(this);
    }

    public boolean isCheckCycle() {
        return this.checkCycle;
    }

    public void setCheckCycle(boolean checkCycle) {
        this.checkCycle = checkCycle;
    }

    public DirFollowBuilder checkCycle(boolean check) {
        this.checkCycle = check;
        return this;
    }

    public boolean isFollowLinks() {
        return this.followLinks;
    }

    public void setFollowLinks(boolean followLinks) {
        this.followLinks = followLinks;
    }

    public DirFollowBuilder followLinks(boolean follow) {
        this.followLinks = follow;
        return this;
    }

    public DirFollow.ErrorBehavior getErrorBehavior() {
        return this.errorBehavior;
    }

    public void setErrorBehavior(DirFollow.ErrorBehavior errorBehavior) {
        this.errorBehavior = errorBehavior;
    }

    public DirFollowBuilder errorBehavior(DirFollow.ErrorBehavior errorBehavior) {
        this.setErrorBehavior(errorBehavior);
        return this;
    }

    public DirFollow build() {
        DirFollow df = new DirFollow();
        df.setCheckCycle(this.checkCycle);
        df.setFollowLinks(this.followLinks);
        if (this.errorBehavior != null) {
            df.setErrorBehavior(this.errorBehavior);
        }
        return df;
    }
}

