/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.io.fs;

import java.io.Closeable;
import java.io.IOError;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.NodesExtracter;
import xyz.cofe.io.fs.DirIterator;
import xyz.cofe.io.fs.File;
import xyz.cofe.iter.Eterable;

public class DirFollow
implements NodesExtracter<File, File> {
    private static final Logger logger = Logger.getLogger(DirFollow.class.getName());
    protected volatile boolean checkDir = true;
    protected boolean checkCycle = true;
    protected volatile Set<File> visited;
    protected volatile ErrorBehavior errorBehavior;
    protected volatile boolean followLinks = true;

    private static Level logLevel() {
        return logger.getLevel();
    }

    private static boolean isLogSevere() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.SEVERE.intValue();
    }

    private static boolean isLogWarning() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.WARNING.intValue();
    }

    private static boolean isLogInfo() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.INFO.intValue();
    }

    private static boolean isLogFine() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINE.intValue();
    }

    private static boolean isLogFiner() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINER.intValue();
    }

    private static boolean isLogFinest() {
        Level logLevel = logger.getLevel();
        return logLevel == null ? true : logLevel.intValue() <= Level.FINEST.intValue();
    }

    private static void logFine(String message, Object ... args) {
        logger.log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        logger.log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        logger.log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        logger.log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        logger.log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        logger.log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        logger.log(Level.SEVERE, null, ex);
    }

    private static void logEntering(String method, Object ... params) {
        logger.entering(DirFollow.class.getName(), method, params);
    }

    private static void logExiting(String method) {
        logger.exiting(DirFollow.class.getName(), method);
    }

    private static void logExiting(String method, Object result) {
        logger.exiting(DirFollow.class.getName(), method, result);
    }

    public DirFollow() {
    }

    protected DirFollow(DirFollow sample) {
        if (sample != null) {
            this.followLinks = sample.followLinks;
            this.errorBehavior = sample.errorBehavior;
            this.checkCycle = sample.checkCycle;
            this.checkDir = sample.checkDir;
        }
    }

    public DirFollow clone() {
        return new DirFollow(this);
    }

    public synchronized boolean isCheckDir() {
        return this.checkDir;
    }

    public synchronized void setCheckDir(boolean checkDir) {
        this.checkDir = checkDir;
    }

    public synchronized boolean isCheckCycle() {
        return this.checkCycle;
    }

    public synchronized void setCheckCycle(boolean checkCycle) {
        this.checkCycle = checkCycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<File> getVisited() {
        if (this.visited != null) {
            return this.visited;
        }
        DirFollow dirFollow = this;
        synchronized (dirFollow) {
            if (this.visited != null) {
                return this.visited;
            }
            this.visited = new ConcurrentSkipListSet<File>();
            return this.visited;
        }
    }

    public synchronized ErrorBehavior getErrorBehavior() {
        if (this.errorBehavior == null) {
            return ErrorBehavior.Continue;
        }
        return this.errorBehavior;
    }

    public synchronized void setErrorBehavior(ErrorBehavior errorBehavior) {
        this.errorBehavior = errorBehavior;
    }

    public synchronized boolean isFollowLinks() {
        return this.followLinks;
    }

    public synchronized void setFollowLinks(boolean followLinks) {
        this.followLinks = followLinks;
    }

    public synchronized Eterable<File> extract(File from) {
        block8: {
            if (from == null) {
                return null;
            }
            if (this.checkCycle && this.getVisited().contains(from)) {
                return null;
            }
            if (this.checkDir && !from.isDir()) {
                return null;
            }
            if (this.checkCycle) {
                this.getVisited().add(from);
            }
            try {
                DirIterator dirIter = new DirIterator(from);
                return new DirIterable(dirIter);
            }
            catch (IOException ex) {
                Logger.getLogger(DirFollow.class.getName()).log(Level.SEVERE, null, ex);
                if (this.getErrorBehavior() == ErrorBehavior.Stop) {
                    throw new IOError(ex);
                }
            }
            catch (IOError err) {
                Logger.getLogger(DirFollow.class.getName()).log(Level.SEVERE, null, err);
                if (this.getErrorBehavior() != ErrorBehavior.Stop) break block8;
                throw err;
            }
        }
        return null;
    }

    private static class DirIterable
    implements Eterable<File>,
    Closeable {
        private DirIterator diter;

        public DirIterable(DirIterator diritr) {
            this.diter = diritr;
        }

        public Iterator<File> iterator() {
            return this.diter;
        }

        @Override
        public void close() throws IOException {
            if (this.diter != null) {
                this.diter.close();
                this.diter = null;
            }
        }
    }

    public static enum ErrorBehavior {
        Continue,
        Stop;

    }
}

