/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.fs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Iterators;

public class UnixPath
implements Comparable<UnixPath> {
    private static final String filesep = "/";
    private static final String current = ".";
    private static final String parent = "..";
    private static final String empty = "";
    private String[] components = null;
    private final boolean useEscape = true;
    private final char escape = (char)92;

    private static void logFine(String message, Object ... args) {
        Logger.getLogger(UnixPath.class.getName()).log(Level.FINE, message, args);
    }

    private static void logFiner(String message, Object ... args) {
        Logger.getLogger(UnixPath.class.getName()).log(Level.FINER, message, args);
    }

    private static void logFinest(String message, Object ... args) {
        Logger.getLogger(UnixPath.class.getName()).log(Level.FINEST, message, args);
    }

    private static void logInfo(String message, Object ... args) {
        Logger.getLogger(UnixPath.class.getName()).log(Level.INFO, message, args);
    }

    private static void logWarning(String message, Object ... args) {
        Logger.getLogger(UnixPath.class.getName()).log(Level.WARNING, message, args);
    }

    private static void logSevere(String message, Object ... args) {
        Logger.getLogger(UnixPath.class.getName()).log(Level.SEVERE, message, args);
    }

    private static void logException(Throwable ex) {
        Logger.getLogger(UnixPath.class.getName()).log(Level.SEVERE, null, ex);
    }

    private static String[] split(String src, String splitter) {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        if (splitter == null) {
            throw new IllegalArgumentException("splitter == null");
        }
        ArrayList<String> result = new ArrayList<String>();
        if (splitter.equals(src)) {
            result.add(empty);
        } else if (splitter.length() > src.length()) {
            result.add(src);
        } else {
            int offset = 0;
            while (offset <= src.length()) {
                String s;
                if (offset == src.length()) {
                    result.add(empty);
                    break;
                }
                int next = src.indexOf(splitter, offset);
                if (next < 0) {
                    s = src.substring(offset, src.length());
                    result.add(s);
                    break;
                }
                s = src.substring(offset, next);
                result.add(s);
                offset = next + splitter.length();
            }
        }
        return result.toArray(new String[0]);
    }

    private static Iterable<String> splitIterable(String src, String splitter) {
        Object[] arr = UnixPath.split(src, splitter);
        return Iterators.array((Object[])arr);
    }

    private static String join(Iterable<String> lines, String glue) {
        if (lines == null) {
            throw new IllegalArgumentException("lines == null");
        }
        if (glue == null) {
            throw new IllegalArgumentException("glue == null");
        }
        StringBuilder res = new StringBuilder();
        int idx = -1;
        for (String line : lines) {
            if (++idx > 0) {
                res.append(glue);
            }
            if (line == null) continue;
            res.append(line);
        }
        return res.toString();
    }

    private static String join(String[] lines, String glue, int from, int count) {
        if (lines == null) {
            throw new IllegalArgumentException("lines == null");
        }
        if (glue == null) {
            throw new IllegalArgumentException("glue == null");
        }
        String res = empty;
        for (int i = 0; i < count; ++i) {
            String line;
            int idx = from + i;
            String string = line = idx >= 0 && idx < lines.length ? lines[idx] : empty;
            if (line == null) {
                line = empty;
            }
            if (i > 0) {
                res = res + glue;
            }
            res = res + line;
        }
        return res;
    }

    private static String join(String[] lines, String glue) {
        if (lines == null) {
            throw new IllegalArgumentException("lines == null");
        }
        if (glue == null) {
            throw new IllegalArgumentException("glue == null");
        }
        return UnixPath.join(lines, glue, 0, lines.length);
    }

    private static String lookupText(String source, int beginIndex, int len) {
        if (source == null) {
            throw new IllegalArgumentException("source==null");
        }
        if (len < 0) {
            throw new IllegalArgumentException("len<0");
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("beginIndex<0");
        }
        if (beginIndex >= source.length()) {
            return empty;
        }
        if (beginIndex + len > source.length()) {
            len = source.length() - beginIndex;
        }
        return source.substring(beginIndex, beginIndex + len);
    }

    protected UnixPath(String[] components) {
        if (components == null) {
            throw new IllegalArgumentException("components==null");
        }
        for (int i = 0; i < components.length; ++i) {
            if (components[i] != null) continue;
            throw new IllegalArgumentException("components[" + i + "]==null");
        }
        this.components = components;
    }

    public UnixPath(String path, boolean useEscape, char escapeChar, char fileSepChar) {
        if (path == null) {
            throw new IllegalArgumentException("path==null");
        }
        this.components = useEscape ? UnixPath.parse(path, escapeChar, fileSepChar) : (path.contains(empty + fileSepChar) ? UnixPath.split(path, empty + fileSepChar) : new String[]{path});
    }

    public UnixPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path==null");
        }
        this.components = UnixPath.parse(path, '\\', filesep.charAt(0));
    }

    private static String[] parse(String path, char escape, char filesep) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c0;
            String lt = UnixPath.lookupText(path, i, 2);
            if (lt.length() == 2) {
                c0 = lt.charAt(0);
                char c1 = lt.charAt(1);
                if (c0 == escape) {
                    buff.append(c1);
                    ++i;
                    continue;
                }
                if (c0 == filesep) {
                    list.add(buff.toString());
                    buff.setLength(0);
                    continue;
                }
                buff.append(c0);
                continue;
            }
            if (lt.length() != 1 || (c0 = lt.charAt(0)) == escape) continue;
            if (c0 == filesep) {
                list.add(buff.toString());
                buff.setLength(0);
                continue;
            }
            buff.append(c0);
        }
        if (buff.length() > 0) {
            list.add(buff.toString());
        }
        return list.toArray(new String[0]);
    }

    public UnixPath(UnixPath src) {
        if (src == null) {
            throw new IllegalArgumentException("src==null");
        }
        this.components = src.components;
    }

    public UnixPath(UnixPath base, String child) {
        if (base == null) {
            throw new IllegalArgumentException("base==null");
        }
        if (child == null) {
            throw new IllegalArgumentException("child==null");
        }
        UnixPath childPath = new UnixPath(child);
        String[] cmpts = Arrays.copyOf(base.components, base.components.length + childPath.components.length);
        System.arraycopy(childPath.components, 0, cmpts, base.components.length, childPath.components.length);
        this.components = cmpts;
    }

    public String[] getComponents() {
        return this.components;
    }

    public String[] getComponents(int beginIndex) {
        if (beginIndex <= 0) {
            return this.components;
        }
        if (beginIndex >= this.components.length) {
            return new String[0];
        }
        return Arrays.copyOfRange(this.components, beginIndex, this.components.length);
    }

    private String encodeComponent(String component) {
        StringBuilder sb = new StringBuilder();
        char file_sep = filesep.charAt(0);
        for (int i = 0; i < component.length(); ++i) {
            char c0 = component.charAt(i);
            if (c0 == '\\') {
                sb.append('\\').append('\\');
                continue;
            }
            if (c0 == file_sep) {
                sb.append('\\').append(filesep);
                continue;
            }
            sb.append(c0);
        }
        return sb.toString();
    }

    public String toString() {
        if (this.components.length == 1 && this.components[0] != null && this.components[0].equals(empty)) {
            return filesep;
        }
        StringBuilder path = new StringBuilder();
        String sep = filesep;
        int i = -1;
        for (String cmpt : this.components) {
            if (++i > 0) {
                path.append(sep);
            }
            path.append(this.encodeComponent(cmpt));
        }
        return path.toString();
    }

    public boolean isAbsolute() {
        return this.components.length > 0 && this.components[0] != null && this.components[0].length() == 0;
    }

    private boolean getAbsolute_allowRetNull() {
        return false;
    }

    public UnixPath getAbsolute(UnixPath currentDir) {
        if (this.isAbsolute()) {
            return this;
        }
        if (currentDir == null) {
            throw new IllegalArgumentException("currentDir==null");
        }
        if (!currentDir.isAbsolute()) {
            throw new IllegalArgumentException("!currentDir.isAbsolute()");
        }
        ArrayList<String> cmpts = new ArrayList<String>();
        for (String c : currentDir.getComponents()) {
            cmpts.add(c);
        }
        for (String c : this.getComponents()) {
            cmpts.add(c);
        }
        return new UnixPath(cmpts.toArray(new String[0]));
    }

    public boolean isRelative() {
        return !this.isAbsolute();
    }

    public UnixPath getParent() {
        if (this.components.length <= 1) {
            return null;
        }
        return new UnixPath(Arrays.copyOf(this.components, this.components.length - 1));
    }

    public UnixPath clone() {
        return new UnixPath(this);
    }

    public int hashCode() {
        int hash = 3;
        hash = 13 * hash + Arrays.deepHashCode(this.components);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnixPath other = (UnixPath)obj;
        return Arrays.deepEquals(this.components, other.components);
    }

    private boolean resolveLink_allowRetNull() {
        return false;
    }

    public UnixPath resolveLink(UnixPath link, UnixPath currentDir) {
        if (currentDir == null) {
            throw new IllegalArgumentException("currentDir==null");
        }
        if (link == null) {
            throw new IllegalArgumentException("path==null");
        }
        if (link.isAbsolute()) {
            return link;
        }
        UnixPath p = !this.isAbsolute() ? this.getAbsolute(currentDir) : this;
        ArrayList<String> cmpts = new ArrayList<String>();
        cmpts.addAll(Arrays.asList(p.getComponents()));
        if (cmpts.size() > 0) {
            cmpts.remove(cmpts.size() - 1);
        }
        for (String cmpt : link.getComponents()) {
            if (cmpt.equals(current) || cmpt.equals(empty)) continue;
            if (cmpt.equals(parent)) {
                if (cmpts.size() > 1) {
                    cmpts.remove(cmpts.size() - 1);
                    continue;
                }
                if (!this.resolveLink_allowRetNull()) continue;
                return null;
            }
            cmpts.add(cmpt);
        }
        return new UnixPath(cmpts.toArray(new String[0]));
    }

    public UnixPath getCanonical() {
        if (this.components != null && this.components.length == 1 && this.components[0] != null && this.components[0].equals(current)) {
            return this;
        }
        if (this.components != null && this.components.length == 1 && this.components[0] != null && this.components[0].length() == 0) {
            return this;
        }
        ArrayList<String> cmpts = new ArrayList<String>();
        cmpts.addAll(Arrays.asList(this.getComponents()));
        cmpts = this.removeCurrent(cmpts);
        this.removeEmpties(cmpts);
        this.removeParent(cmpts);
        return new UnixPath(cmpts.toArray(new String[0]));
    }

    private void removeTrailEmpties(ArrayList<String> components) {
        String cmpt0;
        int i;
        ArrayList cmpts = new ArrayList();
        int begin = -1;
        int endExc = -1;
        for (i = components.size() - 1; i >= 0 && (cmpt0 = components.get(i)).equals(empty); ++i) {
            if (endExc < 0) {
                begin = i;
                endExc = i + 1;
                continue;
            }
            begin = i;
        }
        if (begin > 0 && endExc > 0 && endExc > begin) {
            for (i = 0; i < endExc - begin; ++i) {
                components.remove(begin);
            }
        }
    }

    private void removeParent(ArrayList<String> components) {
        boolean abs = components.size() > 0 && components.get(0).length() == 0;
        int begin = -1;
        int endExc = -1;
        int state = 0;
        block4: while (state != 99) {
            switch (state) {
                case 0: {
                    int i;
                    begin = -1;
                    int n = i = abs ? 1 : 0;
                    while (i < components.size() - 1) {
                        String cmpt0 = components.get(i);
                        String cmpt1 = components.get(i + 1);
                        if (!cmpt0.equals(parent) && cmpt1.equals(parent)) {
                            begin = i;
                            endExc = i + 2;
                            break;
                        }
                        ++i;
                    }
                    if (begin < 0) {
                        state = 99;
                        continue block4;
                    }
                    state = 2;
                    continue block4;
                }
                case 2: {
                    int i;
                    for (i = 0; i < endExc - begin; ++i) {
                        components.remove(begin);
                    }
                    state = 0;
                    continue block4;
                }
            }
            state = 99;
        }
    }

    private void removeEmpties(ArrayList<String> components) {
        boolean abs = components.size() > 0 && components.get(0).length() == 0;
        int del = -1;
        int state = 0;
        block4: while (state != 99) {
            switch (state) {
                case 0: {
                    int i;
                    del = -1;
                    int n = i = abs ? 1 : 0;
                    while (i < components.size()) {
                        String cmpt0 = components.get(i);
                        if (cmpt0.equals(empty)) {
                            del = i;
                            break;
                        }
                        ++i;
                    }
                    if (del >= 0) {
                        state = 1;
                        continue block4;
                    }
                    state = 99;
                    continue block4;
                }
                case 1: {
                    components.remove(del);
                    state = 0;
                    continue block4;
                }
            }
            state = 99;
        }
    }

    private void removeDiplicateEmpties(ArrayList<String> components) {
        boolean abs = components.size() > 0 && components.get(0).length() == 0;
        int begin = -1;
        int endExc = -1;
        int state = 0;
        block5: while (state != 99) {
            switch (state) {
                case 0: {
                    String cmpt1;
                    String cmpt0;
                    int i;
                    begin = -1;
                    int n = i = abs ? 1 : 0;
                    while (i < components.size() - 1) {
                        cmpt0 = components.get(i);
                        cmpt1 = components.get(i + 1);
                        if (cmpt0.equals(empty) && cmpt1.equals(empty)) {
                            begin = i;
                            break;
                        }
                        ++i;
                    }
                    if (begin < 0) {
                        state = 99;
                        continue block5;
                    }
                    state = 1;
                    continue block5;
                }
                case 1: {
                    String cmpt1;
                    String cmpt0;
                    int i;
                    endExc = -1;
                    for (i = begin; i < components.size() - 1; ++i) {
                        cmpt0 = components.get(i);
                        cmpt1 = components.get(i + 1);
                        if (!cmpt0.equals(empty) || cmpt1.equals(empty)) continue;
                        endExc = i + 1;
                        break;
                    }
                    if (endExc < 0) {
                        endExc = components.size();
                    }
                    state = 2;
                    continue block5;
                }
                case 2: {
                    int i;
                    for (i = 0; i < endExc - begin; ++i) {
                        components.remove(begin);
                    }
                    state = 0;
                    continue block5;
                }
            }
            state = 99;
        }
    }

    private ArrayList<String> removeCurrent(ArrayList<String> components) {
        ArrayList<String> cmpts = new ArrayList<String>();
        for (String cmpt : components) {
            if (cmpt.equals(current)) continue;
            cmpts.add(cmpt);
        }
        return cmpts;
    }

    @Override
    public int compareTo(UnixPath o) {
        String p1 = this.toString();
        String p2 = o.toString();
        return p1.compareTo(p2);
    }

    public String getName() {
        String[] cmpts;
        if (this.components.length == 0) {
            return empty;
        }
        if (this.components.length == 1) {
            return this.components[0];
        }
        UnixPath canon = this.getCanonical();
        if (canon != null && (cmpts = canon.getComponents()) != null && cmpts.length > 0) {
            return cmpts[cmpts.length - 1];
        }
        return this.components[this.components.length - 1];
    }
}

