/*
 * Decompiled with CFR 0.152.
 */
package xyz.cofe.fs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.cofe.collection.Func1;
import xyz.cofe.collection.Func2;
import xyz.cofe.fs.File;
import xyz.cofe.io.IOFun;

public class FileHelper {
    public final File file;

    public FileHelper(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file==null");
        }
        this.file = file;
    }

    public String readText(Charset cs, int maxSize, int blockSize, Func2<Object, Long, Long> progress) {
        try {
            final Func2<Object, Long, Long> fprogress = progress;
            final int max = maxSize;
            BufferedInputStream input = this.file.openRead();
            String txt = IOFun.readText((InputStream)input, (Charset)cs, (int)maxSize, (int)blockSize, (Func1)new Func1<Object, Long>(){

                public Object apply(Long readed) {
                    try {
                        if (fprogress == null) {
                            return null;
                        }
                        long tot = max >= 0 ? (long)max : FileHelper.this.file.getLength();
                        fprogress.apply((Object)readed, (Object)tot);
                    }
                    catch (Throwable err) {
                        Logger.getLogger(FileHelper.class.getName()).log(Level.WARNING, err.getMessage(), err);
                    }
                    return null;
                }
            });
            ((InputStream)input).close();
            return txt;
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public String readText(Charset cs, int maxSize) {
        return this.readText(cs, maxSize, -1, null);
    }

    public String readText(Charset cs) {
        return this.readText(cs, -1, -1, null);
    }

    public void writeText(String text, Charset cs, int blockSize, Func2<Object, Long, Long> progress) {
        try {
            if (text == null) {
                throw new IllegalArgumentException("text==null");
            }
            BufferedOutputStream out = this.file.openWrite();
            IOFun.writeText((OutputStream)out, (String)text, (Charset)cs, (int)blockSize, progress);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public void writeText(String text, Charset cs) {
        this.writeText(text, cs, -1, null);
    }

    public void appendText(String text, Charset cs, int blockSize, Func2<Object, Long, Long> progress) {
        try {
            if (text == null) {
                throw new IllegalArgumentException("text==null");
            }
            BufferedOutputStream out = this.file.openAppend();
            IOFun.writeText((OutputStream)out, (String)text, (Charset)cs, (int)blockSize, progress);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public void appendText(String text, Charset cs) {
        this.appendText(text, cs, -1, null);
    }

    public byte[] readBytes(int maxSize, int blockSize, Func2<Object, Long, Long> progress) {
        try {
            final Func2<Object, Long, Long> fprogress = progress;
            final int max = maxSize;
            BufferedInputStream input = this.file.openRead();
            byte[] data = IOFun.readBytes((InputStream)input, (int)maxSize, (int)blockSize, (Func1)new Func1<Object, Long>(){

                public Object apply(Long readed) {
                    try {
                        if (fprogress == null) {
                            return null;
                        }
                        long tot = max >= 0 ? (long)max : FileHelper.this.file.getLength();
                        fprogress.apply((Object)readed, (Object)tot);
                    }
                    catch (Throwable err) {
                        Logger.getLogger(FileHelper.class.getName()).log(Level.WARNING, err.getMessage(), err);
                    }
                    return null;
                }
            });
            ((InputStream)input).close();
            return data;
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public byte[] readBytes(int maxSize) {
        return this.readBytes(maxSize, -1, null);
    }

    public byte[] readBytes() {
        return this.readBytes(-1, -1, null);
    }

    public void writeBytes(byte[] data, int offset, int dataSize, int blockSize, Func2<Object, Long, Long> progress) {
        try {
            if (data == null) {
                throw new IllegalArgumentException("data==null");
            }
            BufferedOutputStream out = this.file.openWrite();
            IOFun.writeBytes((OutputStream)out, (byte[])data, (int)offset, (int)dataSize, (int)blockSize, progress);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public void writeBytes(byte[] data, int offset, int dataSize) {
        this.writeBytes(data, offset, dataSize, -1, null);
    }

    public void writeBytes(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        this.writeBytes(data, 0, data.length, -1, null);
    }

    public void appendBytes(byte[] data, int offset, int dataSize, int blockSize, Func2<Object, Long, Long> progress) {
        try {
            if (data == null) {
                throw new IllegalArgumentException("data==null");
            }
            BufferedOutputStream out = this.file.openAppend();
            IOFun.writeBytes((OutputStream)out, (byte[])data, (int)offset, (int)dataSize, (int)blockSize, progress);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            throw new IOError(ex);
        }
    }

    public void appendBytes(byte[] data, int offset, int dataSize) {
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        this.appendBytes(data, offset, dataSize, -1, null);
    }

    public void appendBytes(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data==null");
        }
        this.appendBytes(data, 0, data.length, -1, null);
    }
}

