/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.menu;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupHeader;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupHeaderFactory;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenu;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuCallback;
import bibliothek.gui.dock.station.toolbar.menu.CustomizationMenuContent;
import bibliothek.gui.dock.util.icon.DockIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

public class CustomizationButton
implements ToolbarGroupHeaderFactory {
    private DockController controller;
    private CustomizationMenu menu;
    private CustomizationMenuContent content;

    public CustomizationButton(DockController controller) {
        this.controller = controller;
    }

    @Override
    public ToolbarGroupHeader create(ToolbarGroupDockStation station) {
        return new Button(station);
    }

    public void setMenu(CustomizationMenu menu) {
        if (this.menu != null) {
            this.menu.close();
            this.menu.setController(null);
        }
        this.menu = menu;
        if (menu != null) {
            menu.setController(this.controller);
            menu.setContent(this.content);
        }
    }

    public void setContent(CustomizationMenuContent content) {
        if (this.menu != null) {
            this.menu.setContent(content);
        }
        this.content = content;
    }

    protected class Button
    implements ToolbarGroupHeader,
    CustomizationMenuCallback {
        private JToggleButton toggle;
        private Orientation orientation;
        private boolean open = false;
        private ToolbarGroupDockStation station;
        private boolean mousePressed = false;
        private DockIcon toolIcon = new DockIcon("toolbar.customization.preferences", DockIcon.KIND_ICON){

            protected void changed(Icon oldValue, Icon newValue) {
                if (Button.this.toggle != null) {
                    Button.this.toggle.setIcon(newValue);
                }
            }
        };

        public Button(ToolbarGroupDockStation station) {
            this.station = station;
            this.toolIcon.setController(CustomizationButton.this.controller);
            this.toggle = new JToggleButton();
            this.toggle.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.toggle.setIcon((Icon)this.toolIcon.value());
            this.toggle.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Button.this.toggle.isSelected()) {
                        Button.this.showMenu();
                    } else if (Button.this.open) {
                        CustomizationButton.this.menu.close();
                    }
                }
            });
            this.toggle.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Button.this.mousePressed = true;
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if ((e.getModifiersEx() & 0x1C00) == 0) {
                        Button.this.mousePressed = false;
                    }
                }
            });
        }

        @Override
        public void destroy() {
            this.toolIcon.setController(null);
        }

        private void showMenu() {
            if (CustomizationButton.this.menu == null) {
                throw new IllegalStateException("there is no menu set");
            }
            Point location = new Point(0, 0);
            SwingUtilities.convertPointToScreen(location, this.toggle);
            if (this.orientation == Orientation.HORIZONTAL) {
                location.y += this.toggle.getHeight();
            } else {
                location.x += this.toggle.getWidth();
            }
            this.open = true;
            CustomizationButton.this.menu.open(location.x, location.y, this);
        }

        @Override
        public Component getComponent() {
            return this.toggle;
        }

        @Override
        public void setOrientation(Orientation orientation) {
            this.orientation = orientation;
        }

        @Override
        public Rectangle getButton() {
            Point location = new Point(0, 0);
            SwingUtilities.convertPointToScreen(location, this.toggle);
            return new Rectangle(location, this.toggle.getSize());
        }

        @Override
        public Component getParent() {
            return this.toggle;
        }

        @Override
        public DockStation getOwner() {
            return this.station;
        }

        @Override
        public void append(Dockable dockable) {
            ToolbarGroupDockStation parent = this.station;
            while (true) {
                if (parent.getDockableCount() == 0) {
                    parent.drop(dockable);
                    return;
                }
                Dockable child = parent.getDockable(parent.getDockableCount() - 1);
                if (child.asDockStation() == null) break;
                parent = child.asDockStation();
            }
            parent.drop(dockable);
        }

        @Override
        public boolean isAutoCloseAllowed() {
            return !this.mousePressed;
        }

        @Override
        public void closed() {
            this.open = false;
            this.toggle.setSelected(false);
        }
    }
}

