/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layout;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupDividerStrategy;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupSpanStrategy;
import bibliothek.gui.dock.station.toolbar.layout.DockablePlaceholderToolbarGrid;
import bibliothek.gui.dock.station.toolbar.layout.ToolbarGridLayoutManagerListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public abstract class ToolbarGridLayoutManager<P extends PlaceholderListItem<Dockable>>
implements LayoutManager2 {
    private final DockablePlaceholderToolbarGrid<P> grid;
    private final Orientation orientation;
    private Container parent;
    private ToolbarGroupSpanStrategy<P> spans;
    private boolean useScrollbars = true;
    private Wrapper[][] cachedComponents;
    private List<ToolbarGridLayoutManagerListener> listeners = new ArrayList<ToolbarGridLayoutManagerListener>();

    public ToolbarGridLayoutManager(Container parent, Orientation orientation, DockablePlaceholderToolbarGrid<P> grid, ToolbarGroupDockStation station) {
        if (orientation == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        if (grid == null) {
            throw new IllegalArgumentException("grid must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("parent must not be null");
        }
        this.orientation = orientation;
        this.grid = grid;
        this.parent = parent;
        this.spans = new ToolbarGroupSpanStrategy<P>(grid, station){

            @Override
            protected void handleResized() {
                Container p = ToolbarGridLayoutManager.this.parent;
                if (p instanceof JComponent) {
                    ((JComponent)p).revalidate();
                }
            }
        };
    }

    public void setController(DockController controller) {
        this.spans.setController(controller);
    }

    public void setDividerStrategy(ToolbarGroupDividerStrategy dividers) {
        this.spans.setDividers(dividers);
    }

    public void mutate() {
        this.mutate(-1);
    }

    public void mutate(int column) {
        this.spans.mutate(column);
    }

    public void mutate(int column, int line) {
        this.spans.mutate(column, line);
    }

    protected abstract Component toComponent(P var1);

    protected abstract void setShowScrollbar(int var1, boolean var2);

    protected abstract int getScrollbarValue(int var1, int var2, int var3);

    protected abstract Component getScrollbar(int var1);

    protected Wrapper[][] layout() {
        if (this.cachedComponents != null) {
            if (this.cachedComponents.length != this.grid.getColumnCount()) {
                this.cachedComponents = null;
            } else {
                int n = this.cachedComponents.length;
                for (int i = 0; i < n && this.cachedComponents != null; ++i) {
                    if (this.cachedComponents[i].length == this.grid.getColumn(i).dockables().size()) continue;
                    this.cachedComponents = null;
                }
            }
        }
        if (this.cachedComponents == null) {
            Wrapper[][] components = new Wrapper[this.grid.getColumnCount()][];
            for (int i = 0; i < components.length; ++i) {
                ArrayList<Wrapper> list = new ArrayList<Wrapper>();
                Iterator iter = this.grid.getColumnContent(i);
                while (iter.hasNext()) {
                    list.add(new Wrapper(this.toComponent((PlaceholderListItem)iter.next())));
                }
                components[i] = list.toArray(new Wrapper[list.size()]);
            }
            this.cachedComponents = components;
        }
        return this.cachedComponents;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.cachedComponents = null;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.cachedComponents = null;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        this.cachedComponents = null;
    }

    public int getColumnAt(int location) {
        int index = 0;
        int n = this.grid.getColumnCount();
        for (int i = 0; i < n; ++i) {
            index = i;
            Rectangle bounds = this.getBounds(i);
            if (this.orientation == Orientation.VERTICAL ? bounds.x + bounds.width > location : bounds.y + bounds.height > location) break;
        }
        return index;
    }

    public boolean isColumnAt(int location) {
        int n = this.grid.getColumnCount();
        for (int i = 0; i < n; ++i) {
            Rectangle bounds = this.getBounds(i);
            if (!(this.orientation == Orientation.VERTICAL ? bounds.x <= location && bounds.x + bounds.width > location : bounds.y <= location && bounds.y + bounds.height > location)) continue;
            return true;
        }
        return false;
    }

    public int getInsertionLineAt(int column, int location) {
        int count = this.grid.getLineCount(column);
        for (int i = 0; i < count; ++i) {
            Rectangle bounds = this.getBounds(column, i);
            if (!(this.orientation == Orientation.HORIZONTAL ? bounds.x + bounds.width / 2 >= location : bounds.y + bounds.height / 2 >= location)) continue;
            return i;
        }
        return count;
    }

    @Override
    public Dimension maximumLayoutSize(Container parent) {
        return this.layoutSize(parent, this.layout(), Size.MAXIMUM);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.layoutSize(parent, this.layout(), Size.PREFERRED);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.layoutSize(parent, this.layout(), Size.MINIMUM);
    }

    private Dimension layoutSize(Container parent, Wrapper[][] content, Size size) {
        int height;
        int width;
        block8: {
            int i;
            block7: {
                int i2;
                this.spans.reset(false);
                width = 0;
                height = 0;
                if (this.orientation != Orientation.HORIZONTAL) break block7;
                int index = 0;
                for (Wrapper[] column : content) {
                    Dimension dim = this.layoutSize(index++, column, size);
                    width = Math.max(width, dim.width);
                    height += dim.height;
                }
                for (i2 = 0; i2 <= content.length; ++i2) {
                    height += this.spans.getColumn(i2);
                }
                if (!this.useScrollbars) break block8;
                for (i2 = 0; i2 < content.length; ++i2) {
                    Component bar = this.getScrollbar(i2);
                    if (bar == null) continue;
                    height += size.get((Component)bar).height;
                }
                break block8;
            }
            int index = 0;
            for (Wrapper[] column : content) {
                Dimension dim = this.layoutSize(index++, column, size);
                height = Math.max(height, dim.height);
                width += dim.width;
            }
            for (i = 0; i <= content.length; ++i) {
                width += this.spans.getColumn(i);
            }
            if (this.useScrollbars) {
                for (i = 0; i < content.length; ++i) {
                    Component bar = this.getScrollbar(i);
                    if (bar == null) continue;
                    width += size.get((Component)bar).width;
                }
            }
        }
        return new Dimension(width, height);
    }

    private Dimension layoutSize(int columnIndex, Wrapper[] column, Size size) {
        int width = 0;
        int height = 0;
        if (this.orientation == Orientation.HORIZONTAL) {
            for (Wrapper item : column) {
                item.reset(size);
                Dimension dim = item.required;
                width += dim.width;
                height = Math.max(dim.height, height);
            }
            for (int i = 0; i <= column.length; ++i) {
                width += this.spans.getLine(columnIndex, i);
            }
        } else {
            for (Wrapper item : column) {
                item.reset(size);
                Dimension dim = item.required;
                height += dim.height;
                width = Math.max(dim.width, width);
            }
            for (int i = 0; i <= column.length; ++i) {
                height += this.spans.getLine(columnIndex, i);
            }
        }
        return new Dimension(width, height);
    }

    public void addListener(ToolbarGridLayoutManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ToolbarGridLayoutManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void layoutContainer(Container parent) {
        Wrapper[][] components = this.layout();
        Dimension available = parent.getSize();
        Dimension preferred = this.layoutSize(parent, components, Size.PREFERRED);
        if (preferred.width <= available.width && preferred.height <= available.height) {
            this.layout(parent, components, preferred, available, Size.PREFERRED);
        } else {
            this.layout(parent, components, this.layoutSize(parent, components, Size.MINIMUM), available, Size.MINIMUM);
        }
        for (ToolbarGridLayoutManagerListener listener : this.listeners) {
            listener.didLayout(parent);
        }
    }

    protected void layout(Container parent, Wrapper[][] components, Dimension required, Dimension available, Size size) {
        if (components.length == 0 || available.width < 1 || available.height < 1) {
            return;
        }
        Dimension[] columns = new Dimension[components.length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = this.layoutSize(i, components[i], size);
        }
        if (this.orientation == Orientation.HORIZONTAL) {
            int i;
            double factor = (double)available.height / (double)required.height;
            if (factor < 1.0) {
                int sum = 0;
                int n = columns.length - 1;
                for (i = 0; i < n; ++i) {
                    columns[i].height = (int)(factor * (double)columns[i].height);
                    sum += columns[i].height;
                    sum += (int)(factor * (double)this.spans.getColumn(i));
                }
                columns[columns.length - 1].height = Math.min(available.height - (sum += (int)(factor * (double)this.spans.getColumn(columns.length))), columns[columns.length - 1].height);
            } else {
                factor = 1.0;
            }
            int y = 0;
            for (i = 0; i < columns.length; ++i) {
                y = (int)((double)y + (double)this.spans.getColumn(i) * factor);
                this.layout(components[i], i, columns[i], available, y);
                y += columns[i].height;
                Component bar = this.getScrollbar(i);
                if (bar == null) continue;
                int barSize = (int)((double)size.get((Component)bar).height * factor);
                bar.setBounds(0, y, available.width, barSize);
                y += barSize;
            }
        } else {
            int i;
            double factor = (double)available.width / (double)required.width;
            if (factor < 1.0) {
                int sum = 0;
                int n = columns.length - 1;
                for (i = 0; i < n; ++i) {
                    columns[i].width = (int)(factor * (double)columns[i].width);
                    sum += columns[i].width;
                    sum += (int)(factor * (double)this.spans.getColumn(i));
                }
                columns[columns.length - 1].width = Math.min(available.width - (sum += (int)(factor * (double)this.spans.getColumn(columns.length))), columns[columns.length - 1].width);
            } else {
                factor = 1.0;
            }
            int x = 0;
            for (i = 0; i < columns.length; ++i) {
                x = (int)((double)x + (double)this.spans.getColumn(i) * factor);
                this.layout(components[i], i, columns[i], available, x);
                x += columns[i].width;
                Component bar = this.getScrollbar(i);
                if (bar == null) continue;
                int barSize = (int)((double)size.get((Component)bar).width * factor);
                bar.setBounds(x, 0, barSize, available.height);
                x += barSize;
            }
        }
    }

    private void layout(Wrapper[] column, int columnIndex, Dimension required, Dimension available, int startPoint) {
        if (this.orientation == Orientation.HORIZONTAL) {
            double factor = (double)available.width / (double)required.width;
            if (factor < 1.0) {
                if (this.useScrollbars) {
                    factor = 1.0;
                    this.setShowScrollbar(columnIndex, true);
                } else {
                    int sum = 0;
                    int n = column.length - 1;
                    for (int i = 0; i < n; ++i) {
                        Dimension dim = column[i].required;
                        dim.width = (int)((double)dim.width * factor);
                        sum += dim.width;
                    }
                    column[column.length - 1].required.width = available.width - sum;
                }
            } else {
                factor = 1.0;
                if (this.useScrollbars) {
                    this.setShowScrollbar(columnIndex, false);
                }
            }
            int x = -this.getScrollbarValue(columnIndex, required.width, available.width);
            int y = startPoint;
            for (int i = 0; i < column.length; ++i) {
                x = (int)((double)x + (double)this.spans.getLine(columnIndex, i) * factor);
                column[i].component.setBounds(x, y, column[i].required.width, required.height);
                x += column[i].required.width;
            }
        } else {
            double factor = (double)available.height / (double)required.height;
            if (factor < 1.0) {
                if (this.useScrollbars) {
                    factor = 1.0;
                    this.setShowScrollbar(columnIndex, true);
                } else {
                    int sum = 0;
                    int n = column.length - 1;
                    for (int i = 0; i < n; ++i) {
                        Dimension dim = column[i].required;
                        dim.height = (int)((double)dim.height * factor);
                        sum += dim.height;
                    }
                    column[column.length - 1].required.height = available.height - sum;
                }
            } else {
                factor = 1.0;
                if (this.useScrollbars) {
                    this.setShowScrollbar(columnIndex, false);
                }
            }
            int x = startPoint;
            int y = -this.getScrollbarValue(columnIndex, required.height, available.height);
            for (int i = 0; i < column.length; ++i) {
                y = (int)((double)y + (double)this.spans.getLine(columnIndex, i) * factor);
                column[i].component.setBounds(x, y, required.width, column[i].required.height);
                y += column[i].required.height;
            }
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.cachedComponents = null;
    }

    public Rectangle getBounds(int column, int line) {
        Wrapper[][] cells = this.layout();
        if (column < 0 || column >= cells.length) {
            throw new IllegalArgumentException("column out of bounds: " + column);
        }
        if (line < 0 || line >= cells[column].length) {
            throw new IllegalArgumentException("line out of bounds: " + line);
        }
        return cells[column][line].getBounds();
    }

    public Rectangle getScreenBounds(int column, int line) {
        Wrapper[][] cells = this.layout();
        if (column < 0 || column >= cells.length) {
            throw new IllegalArgumentException("column out of bounds: " + column);
        }
        if (line < 0 || line >= cells[column].length) {
            throw new IllegalArgumentException("line out of bounds: " + line);
        }
        return cells[column][line].getScreenBounds();
    }

    public Rectangle getBounds(int column) {
        Wrapper[][] cells = this.layout();
        return this.getBounds(column, cells);
    }

    public Rectangle getScreenBounds(int column) {
        Wrapper[][] cells = this.layout();
        return this.getScreenBounds(column, cells);
    }

    private Rectangle getBounds(int column, Wrapper[][] cells) {
        if (column < 0 || column >= cells.length) {
            throw new IllegalArgumentException("column out of bounds: " + column);
        }
        Rectangle result = null;
        for (Wrapper cell : cells[column]) {
            result = result == null ? cell.getBounds() : result.union(cell.getBounds());
        }
        int left = this.spans.getLine(column, 0);
        if (this.orientation == Orientation.HORIZONTAL) {
            result.x -= left;
            result.width += left;
        } else {
            result.y -= left;
            result.height += left;
        }
        int lines = cells[column].length;
        if (lines > 0) {
            int right = this.spans.getLine(column, lines);
            if (this.orientation == Orientation.HORIZONTAL) {
                result.width += right;
            } else {
                result.height += right;
            }
        }
        return result;
    }

    private Rectangle getScreenBounds(int column, Wrapper[][] cells) {
        if (column < 0 || column >= cells.length) {
            throw new IllegalArgumentException("column out of bounds: " + column);
        }
        Rectangle result = null;
        for (Wrapper cell : cells[column]) {
            result = result == null ? cell.getScreenBounds() : result.union(cell.getScreenBounds());
        }
        return result;
    }

    public Rectangle getGapBounds(int column, boolean includeScrollBars) {
        Component bar;
        Wrapper[][] cells = this.layout();
        Rectangle left = column == 0 ? new Rectangle(0, 0, 0, 0) : this.getBounds(column - 1, cells);
        Rectangle right = null;
        if (column == cells.length) {
            right = new Rectangle(0, 0, 0, 0);
            if (this.orientation == Orientation.HORIZONTAL) {
                right.y = this.parent.getHeight();
            } else {
                right.x = this.parent.getWidth();
            }
        } else {
            right = this.getBounds(column, cells);
        }
        if (left == null || right == null) {
            return null;
        }
        if (this.orientation == Orientation.HORIZONTAL) {
            Component bar2;
            int x = Math.min(left.x, right.x);
            int y = left.y + left.height;
            int width = Math.max(left.x + left.width, right.x + right.width) - x;
            int height = right.y - y;
            if (!includeScrollBars && column > 0 && (bar2 = this.getScrollbar(column - 1)) != null) {
                x += bar2.getWidth();
                width -= bar2.getWidth();
            }
            return new Rectangle(x, y, width, height);
        }
        int x = left.x + left.width;
        int y = Math.min(left.y, right.y);
        int width = right.x - x;
        int height = Math.max(left.y + left.height, right.y + right.height) - y;
        if (!includeScrollBars && column > 0 && (bar = this.getScrollbar(column - 1)) != null) {
            x += bar.getWidth();
            width -= bar.getWidth();
        }
        return new Rectangle(x, y, width, height);
    }

    public Rectangle getGapBounds(int column, int line) {
        Wrapper[][] cells = this.layout();
        int gap = this.spans.getLine(column, line);
        if (this.orientation == Orientation.HORIZONTAL) {
            int y = Integer.MAX_VALUE;
            int height = 0;
            for (Wrapper cell : cells[column]) {
                Rectangle bounds = cell.getBounds();
                y = Math.min(y, bounds.y);
                height = Math.max(height, y - bounds.y + bounds.height);
            }
            if (line == 0) {
                return new Rectangle(cells[column][line].getBounds().x - gap, y, gap, height);
            }
            Rectangle rectangle = cells[column][line - 1].getBounds();
            return new Rectangle(rectangle.x + rectangle.width, y, gap, height);
        }
        int x = Integer.MAX_VALUE;
        int width = 0;
        for (Wrapper cell : cells[column]) {
            Rectangle bounds = cell.getBounds();
            x = Math.min(x, bounds.x);
            width = Math.max(width, x - bounds.x + bounds.width);
        }
        if (line == 0) {
            return new Rectangle(x, cells[column][line].getBounds().y - gap, width, gap);
        }
        Rectangle rectangle = cells[column][line - 1].getBounds();
        return new Rectangle(x, rectangle.y + rectangle.height, width, gap);
    }

    protected class Wrapper {
        public Component component;
        public Dimension required;
        private Size size;

        public Wrapper(Component component) {
            this.component = component;
        }

        public void reset(Size size) {
            if (this.size != size) {
                this.size = size;
                this.required = new Dimension(size.get(this.component));
            }
        }

        public Rectangle getBounds() {
            return this.component.getBounds();
        }

        public Rectangle getScreenBounds() {
            Rectangle bounds = this.component.getBounds();
            Point origin = bounds.getLocation();
            SwingUtilities.convertPointToScreen(origin, this.component);
            Rectangle screenBounds = new Rectangle(origin, new Dimension(bounds.width, bounds.height));
            return screenBounds;
        }
    }

    private static enum Size {
        MAXIMUM,
        MINIMUM,
        PREFERRED;


        public Dimension get(Component component) {
            switch (this) {
                case MAXIMUM: {
                    return component.getMaximumSize();
                }
                case MINIMUM: {
                    return component.getMinimumSize();
                }
                case PREFERRED: {
                    return component.getPreferredSize();
                }
            }
            throw new IllegalStateException();
        }
    }
}

