/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.layer;

import bibliothek.gui.DockStation;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.station.layer.DockStationDropLayer;
import bibliothek.gui.dock.station.layer.LayerPriority;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public class SideSnapDropLayer
implements DockStationDropLayer {
    private final ToolbarGroupDockStation station;
    private LayerPriority priority = LayerPriority.OUTSIDE_LOW;

    public SideSnapDropLayer(ToolbarGroupDockStation station) {
        this.station = station;
    }

    public LayerPriority getPriority() {
        return this.priority;
    }

    public void setPriority(LayerPriority priority) {
        this.priority = priority;
    }

    public boolean canCompare(DockStationDropLayer level) {
        return false;
    }

    public int compare(DockStationDropLayer level) {
        return 0;
    }

    public Component getComponent() {
        return this.station.getComponent();
    }

    public DockStation getStation() {
        return this.station;
    }

    public DockStationDropLayer modify(DockStationDropLayer child) {
        return child;
    }

    public boolean contains(int x, int y) {
        if (!this.station.isAllowSideSnap()) {
            return false;
        }
        Point point = new Point(x, y);
        SwingUtilities.convertPointFromScreen(point, this.getComponent());
        Rectangle bounds = this.getComponent().getBounds();
        if (bounds.contains(point)) {
            return false;
        }
        int size = this.station.getBorderSideSnapSize();
        Rectangle extendedBounds = new Rectangle();
        extendedBounds.setBounds(bounds.x - size, bounds.y - size, bounds.width + size * 2, bounds.height + size * 2);
        return extendedBounds.contains(point);
    }
}

