/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar.group;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ToolbarGroupDockStation;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.PlaceholderMapping;
import bibliothek.gui.dock.station.toolbar.group.ToolbarGroupProperty;
import bibliothek.gui.dock.station.toolbar.layout.DockablePlaceholderToolbarGrid;
import bibliothek.util.Path;

public class ToolbarGroupPlaceholderMapping
implements PlaceholderMapping {
    private ToolbarGroupDockStation station;
    private DockablePlaceholderToolbarGrid<?> grid;

    public ToolbarGroupPlaceholderMapping(ToolbarGroupDockStation station, DockablePlaceholderToolbarGrid<?> grid) {
        this.station = station;
        this.grid = grid;
    }

    public ToolbarGroupDockStation getStation() {
        return this.station;
    }

    public void addPlaceholder(Dockable dockable, Path placeholder) {
        if (placeholder == null) {
            throw new IllegalArgumentException("placeholder must not be null");
        }
        int column = this.grid.getColumn(dockable);
        if (column == -1) {
            throw new IllegalArgumentException("unable to find column of dockable");
        }
        int line = this.grid.getLine(column, dockable);
        if (line == -1) {
            throw new IllegalArgumentException("unable to find line of dockable");
        }
        this.grid.addPlaceholder(column, line, placeholder);
    }

    public boolean hasPlaceholder(Path placeholder) {
        return this.grid.hasPlaceholder(placeholder);
    }

    public void removePlaceholder(Path placeholder) {
        this.grid.removePlaceholder(placeholder);
    }

    public Dockable getDockableAt(Path placeholder) {
        Object item = this.grid.get(placeholder);
        if (item == null) {
            return null;
        }
        return (Dockable)item.asDockable();
    }

    public DockableProperty getLocationAt(Path placeholder) {
        int column = this.grid.getColumn(placeholder);
        if (column == -1) {
            return null;
        }
        int line = this.grid.getLine(placeholder);
        if (line == -1) {
            return null;
        }
        return new ToolbarGroupProperty(column, line, placeholder);
    }
}

