/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ToolbarProperty
extends AbstractDockableProperty {
    private int index;
    private Path placeholder;

    public ToolbarProperty() {
    }

    public ToolbarProperty(int index, Path placeholder) {
        this.index = index;
        this.placeholder = placeholder;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[index=" + this.index + ", placeholder=" + this.placeholder + ", successor=" + this.getSuccessor() + "]";
    }

    public DockableProperty copy() {
        ToolbarProperty copy = new ToolbarProperty(this.index, this.placeholder);
        DockableProperty successor = this.getSuccessor();
        if (successor != null) {
            copy.setSuccessor(successor.copy());
        }
        return copy;
    }

    public int getIndex() {
        return this.index;
    }

    public Path getPlaceholder() {
        return this.placeholder;
    }

    public String getFactoryID() {
        return "ToolbarPropertyFactory";
    }

    public void store(DataOutputStream out) throws IOException {
        Version.write((DataOutputStream)out, (Version)Version.VERSION_1_1_1);
        out.writeInt(this.index);
        if (this.placeholder == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.placeholder.toString());
        }
    }

    public void load(DataInputStream in) throws IOException {
        Version version = Version.read((DataInputStream)in);
        if (!version.equals((Object)Version.VERSION_1_1_1)) {
            throw new IOException("data from an unknown version: " + version);
        }
        this.index = in.readInt();
        this.placeholder = in.readBoolean() ? new Path(in.readUTF()) : null;
    }

    public void store(XElement element) {
        element.addElement("index").setInt(this.index);
        if (this.placeholder != null) {
            element.addElement("placeholder").setString(this.placeholder.toString());
        }
    }

    public void load(XElement element) {
        XElement xindex = element.getElement("index");
        XElement xplaceholder = element.getElement("placeholder");
        if (xindex != null) {
            this.index = xindex.getInt();
        }
        this.placeholder = xplaceholder != null ? new Path(xplaceholder.getString()) : null;
    }
}

