/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PerspectivePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.toolbar.ListDockableStationPerspective;
import bibliothek.gui.dock.station.toolbar.ToolbarDockStationLayout;
import bibliothek.gui.dock.station.toolbar.ToolbarProperty;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.util.Path;
import java.util.Map;

public class ToolbarDockPerspective
extends ListDockableStationPerspective {
    private ExpandedState state = ExpandedState.SHRUNK;

    public ToolbarDockPerspective() {
        this.setDockables((PerspectivePlaceholderList<PerspectiveDockable>)new PerspectivePlaceholderList());
    }

    public ToolbarDockPerspective(ToolbarDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        this.read(layout, children);
    }

    public void read(ToolbarDockStationLayout layout, final Map<Integer, PerspectiveDockable> children) {
        PerspectivePlaceholderList dockables = new PerspectivePlaceholderList();
        this.setExpandedState(layout.getState());
        dockables.read(layout.getPlaceholders(), (PlaceholderListItemConverter)new PlaceholderListItemAdapter<PerspectiveDockable, PerspectiveDockable>(){

            public PerspectiveDockable convert(ConvertedPlaceholderListItem item) {
                if (children == null) {
                    return null;
                }
                int id = item.getInt("id");
                PerspectiveDockable dockable = (PerspectiveDockable)children.get(id);
                dockable.setParent((PerspectiveStation)ToolbarDockPerspective.this);
                return dockable;
            }
        });
        this.setDockables((PerspectivePlaceholderList<PerspectiveDockable>)dockables);
    }

    public PlaceholderMap getPlaceholders(final Map<PerspectiveDockable, Integer> children) {
        return this.getDockables().toMap((PlaceholderListItemConverter)new PlaceholderListItemAdapter<PerspectiveDockable, PerspectiveDockable>(){

            public ConvertedPlaceholderListItem convert(int index, PerspectiveDockable dockable) {
                Integer id = (Integer)children.get(dockable);
                if (id == null) {
                    return null;
                }
                ConvertedPlaceholderListItem item = new ConvertedPlaceholderListItem();
                item.putInt("id", id.intValue());
                item.putInt("index", index);
                Path placeholder = dockable.getPlaceholder();
                if (placeholder != null) {
                    item.putString("placeholder", placeholder.toString());
                    item.setPlaceholder(placeholder);
                }
                return item;
            }
        });
    }

    public String getFactoryID() {
        return "ToolbarDockStationFactory";
    }

    public void setExpandedState(ExpandedState state) {
        if (state == null) {
            throw new IllegalArgumentException("state must not be null");
        }
        this.state = state;
    }

    public ExpandedState getExpandedState() {
        return this.state;
    }

    @Override
    protected DockableProperty getDockableProperty(int index, Path placeholder, PerspectiveDockable child, PerspectiveDockable target) {
        return new ToolbarProperty(index, placeholder);
    }
}

