/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.ToolbarContainerDockStation;
import bibliothek.gui.dock.layout.DockLayoutInfo;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.DockablePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.toolbar.DefaultToolbarContainerConverter;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerConverter;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerDockPerspective;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerDockStationLayout;
import bibliothek.gui.dock.station.toolbar.ToolbarContainerProperty;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class ToolbarContainerDockStationFactory
implements DockFactory<ToolbarContainerDockStation, ToolbarContainerDockPerspective, ToolbarContainerDockStationLayout> {
    public static final String ID = "ToolbarContainerDockStationFactory";

    public String getID() {
        return ID;
    }

    protected ToolbarContainerConverter createConverter() {
        return new DefaultToolbarContainerConverter();
    }

    public ToolbarContainerDockStationLayout getLayout(ToolbarContainerDockStation element, Map<Dockable, Integer> children) {
        return new ToolbarContainerDockStationLayout(element.getPlaceholders(children));
    }

    public ToolbarContainerDockStationLayout getPerspectiveLayout(ToolbarContainerDockPerspective element, Map<PerspectiveDockable, Integer> children) {
        PlaceholderMap map = this.createConverter().getPlaceholders(element, children);
        return new ToolbarContainerDockStationLayout(map);
    }

    public void setLayout(ToolbarContainerDockStation element, ToolbarContainerDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        element.setPlaceholders(layout.getPlaceholders(), children);
    }

    public void setLayout(ToolbarContainerDockStation element, ToolbarContainerDockStationLayout layout, PlaceholderStrategy placeholders) {
    }

    public void write(ToolbarContainerDockStationLayout layout, DataOutputStream out) throws IOException {
        Version.write((DataOutputStream)out, (Version)Version.VERSION_1_1_1);
        layout.getPlaceholders().write(out);
    }

    public void write(ToolbarContainerDockStationLayout layout, XElement element) {
        layout.getPlaceholders().write(element.addElement("placeholders"));
    }

    public ToolbarContainerDockStationLayout read(DataInputStream in, PlaceholderStrategy placeholders) throws IOException {
        Version version = Version.read((DataInputStream)in);
        version.checkCurrent();
        PlaceholderMap map = new PlaceholderMap(in, placeholders);
        map.setPlaceholderStrategy(null);
        return new ToolbarContainerDockStationLayout(map);
    }

    public ToolbarContainerDockStationLayout read(XElement element, PlaceholderStrategy placeholders) {
        XElement xplaceholders = element.getElement("placeholders");
        PlaceholderMap map = new PlaceholderMap(xplaceholders, placeholders);
        map.setPlaceholderStrategy(null);
        return new ToolbarContainerDockStationLayout(map);
    }

    public void estimateLocations(ToolbarContainerDockStationLayout layout, final LocationEstimationMap children) {
        PlaceholderMap map = layout.getPlaceholders();
        if (!map.getFormat().equals((Object)new Path("dock.ToolbarContainerStation"))) {
            throw new IllegalArgumentException("unknown type: " + map.getFormat());
        }
        PlaceholderMap list = map.getMap(map.newKey("content", new Path[0]), "list");
        DockablePlaceholderList.simulatedRead((PlaceholderMap)list, (PlaceholderListItemConverter)new PlaceholderListItemAdapter<Dockable, Dockable>(){

            public Dockable convert(ConvertedPlaceholderListItem item) {
                int id = item.getInt("id");
                int index = item.getInt("index");
                Path placeholder = null;
                if (item.contains("placeholder")) {
                    placeholder = new Path(item.getString("placeholder"));
                }
                children.setLocation(id, (DockableProperty)new ToolbarContainerProperty(index, placeholder));
                int n = children.getSubChildCount(id);
                for (int i = 0; i < n; ++i) {
                    DockLayoutInfo info = children.getSubChild(id, i);
                    info.setLocation((DockableProperty)new ToolbarContainerProperty(index, info.getPlaceholder()));
                }
                return null;
            }
        });
    }

    public ToolbarContainerDockStation layout(ToolbarContainerDockStationLayout layout, Map<Integer, Dockable> children, PlaceholderStrategy placeholders) {
        ToolbarContainerDockStation station = this.createStation();
        this.setLayout(station, layout, children, placeholders);
        return station;
    }

    public ToolbarContainerDockStation layout(ToolbarContainerDockStationLayout layout, PlaceholderStrategy placeholders) {
        ToolbarContainerDockStation station = this.createStation();
        this.setLayout(station, layout, placeholders);
        return station;
    }

    public ToolbarContainerDockPerspective layoutPerspective(ToolbarContainerDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        return new ToolbarContainerDockPerspective(layout, children);
    }

    public void layoutPerspective(ToolbarContainerDockPerspective perspective, ToolbarContainerDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
        perspective.read(layout, children);
    }

    protected ToolbarContainerDockStation createStation() {
        return new ToolbarContainerDockStation(ToolbarContainerDockStation.DEFAULT_ORIENTATION);
    }
}

