/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.toolbar;

import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.support.PerspectivePlaceholderList;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.util.Path;

public abstract class ListDockableStationPerspective
implements PerspectiveStation,
PerspectiveDockable {
    private PerspectiveStation parent;
    private PerspectivePlaceholderList<PerspectiveDockable> dockables = new PerspectivePlaceholderList();

    public ListDockableStationPerspective() {
    }

    public ListDockableStationPerspective(PerspectiveDockable[] children) {
        for (PerspectiveDockable child : children) {
            DockUtilities.ensureTreeValidity((PerspectiveStation)this, (PerspectiveDockable)child);
            child.setParent((PerspectiveStation)this);
            this.dockables.dockables().add((Object)child);
        }
    }

    public PerspectiveStation asStation() {
        return this;
    }

    public PerspectiveDockable asDockable() {
        return this;
    }

    public int getDockableCount() {
        return this.dockables.dockables().size();
    }

    public PerspectiveDockable getDockable(int index) {
        return (PerspectiveDockable)this.dockables.dockables().get(index);
    }

    public int indexOf(PerspectiveDockable dockable) {
        return this.dockables.dockables().indexOf((Object)dockable);
    }

    public void add(PerspectiveDockable dockable) {
        DockUtilities.ensureTreeValidity((PerspectiveStation)this, (PerspectiveDockable)dockable);
        this.dockables.dockables().add((Object)dockable);
        dockable.setParent((PerspectiveStation)this);
    }

    public void add(int index, PerspectiveDockable dockable) {
        DockUtilities.ensureTreeValidity((PerspectiveStation)this, (PerspectiveDockable)dockable);
        this.dockables.dockables().add(index, (Object)dockable);
        dockable.setParent((PerspectiveStation)this);
    }

    public PerspectivePlaceholderList<PerspectiveDockable> getDockables() {
        return this.dockables;
    }

    protected void setDockables(PerspectivePlaceholderList<PerspectiveDockable> dockables) {
        this.dockables = dockables;
    }

    public DockableProperty getDockableProperty(PerspectiveDockable child, PerspectiveDockable target) {
        int index = this.dockables.dockables().indexOf((Object)child);
        Path placeholder = null;
        placeholder = target != null ? target.getPlaceholder() : child.getPlaceholder();
        return this.getDockableProperty(index, placeholder, child, target);
    }

    protected abstract DockableProperty getDockableProperty(int var1, Path var2, PerspectiveDockable var3, PerspectiveDockable var4);

    public PlaceholderMap getPlaceholders() {
        return this.dockables.toMap();
    }

    public void setPlaceholders(PlaceholderMap placeholders) {
        if (this.getDockableCount() > 0) {
            throw new IllegalStateException("there are already children on this station");
        }
        this.dockables = new PerspectivePlaceholderList(placeholders);
    }

    public PerspectiveDockable remove(int index) {
        PerspectiveDockable dockable = this.getDockable(index);
        this.dockables.remove(index);
        dockable.setParent(null);
        return dockable;
    }

    public boolean remove(PerspectiveDockable dockable) {
        int index = this.indexOf(dockable);
        if (index == -1) {
            return false;
        }
        this.dockables.remove(index);
        dockable.setParent(null);
        return true;
    }

    public void replace(PerspectiveDockable oldDockable, PerspectiveDockable newDockable) {
        int index = this.dockables.dockables().indexOf((Object)oldDockable);
        if (index < 0) {
            throw new IllegalArgumentException("oldDockable is not child of this station");
        }
        DockUtilities.ensureTreeValidity((PerspectiveStation)this, (PerspectiveDockable)newDockable);
        this.dockables.remove(index);
        this.dockables.dockables().add(index, (Object)newDockable);
        oldDockable.setParent(null);
        newDockable.setParent((PerspectiveStation)this);
    }

    public Path getPlaceholder() {
        return null;
    }

    public PerspectiveStation getParent() {
        return this.parent;
    }

    public void setParent(PerspectiveStation parent) {
        this.parent = parent;
    }
}

