/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station;

import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.station.OrientationObserver;
import bibliothek.gui.dock.station.OrientedDockStation;
import bibliothek.gui.dock.station.OrientingDockStationEvent;
import bibliothek.gui.dock.station.OrientingDockStationListener;
import java.util.ArrayList;
import java.util.List;

public class ToolbarTabDockStation
extends StackDockStation
implements OrientedDockStation {
    private List<OrientingDockStationListener> listeners = new ArrayList<OrientingDockStationListener>(5);
    private Orientation orientation = Orientation.VERTICAL;

    public ToolbarTabDockStation() {
        this.setSmallMinimumSize(false);
        this.setTitleIcon(null);
        new OrientationObserver((Dockable)this){

            @Override
            protected void orientationChanged(Orientation current) {
                if (current != null) {
                    ToolbarTabDockStation.this.setOrientation(current);
                }
            }
        };
    }

    public String getFactoryID() {
        return "ToolbarTabDockStation";
    }

    @Override
    public Orientation getOrientationOf(Dockable child) {
        return this.orientation;
    }

    @Override
    public void addOrientingDockStationListener(OrientingDockStationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeOrientingDockStationListener(OrientingDockStationListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setOrientation(Orientation orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            OrientingDockStationEvent event = new OrientingDockStationEvent(this);
            for (OrientingDockStationListener listener : this.listeners.toArray(new OrientingDockStationListener[this.listeners.size()])) {
                listener.changed(event);
            }
        }
    }

    @Override
    public Orientation getOrientation() {
        return this.orientation;
    }
}

