/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.Orientation;
import bibliothek.gui.dock.ToolbarItem;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.component.DockComponentRoot;
import bibliothek.gui.dock.component.DockComponentRootHandler;
import bibliothek.gui.dock.dockable.AbstractDockable;
import bibliothek.gui.dock.dockable.DockableBackgroundComponent;
import bibliothek.gui.dock.dockable.DockableIcon;
import bibliothek.gui.dock.station.OrientationObserver;
import bibliothek.gui.dock.station.toolbar.ToolbarStrategy;
import bibliothek.gui.dock.toolbar.expand.ExpandableStateController;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItem;
import bibliothek.gui.dock.toolbar.expand.ExpandableToolbarItemListener;
import bibliothek.gui.dock.toolbar.expand.ExpandedState;
import bibliothek.gui.dock.toolbar.item.ComponentItem;
import bibliothek.gui.dock.toolbar.item.DockActionItem;
import bibliothek.gui.dock.util.BackgroundAlgorithm;
import bibliothek.gui.dock.util.BackgroundPanel;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.SilentPropertyValue;
import bibliothek.gui.dock.util.Transparency;
import bibliothek.gui.dock.util.icon.DockIcon;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.event.MouseInputListener;

public class ToolbarItemDockable
extends AbstractDockable
implements ExpandableToolbarItem {
    private BackgroundPanel content;
    private CardLayout contentLayout;
    private final List<ExpandableToolbarItemListener> expandableListeners = new ArrayList<ExpandableToolbarItemListener>();
    private ExpandedState state = ExpandedState.SHRUNK;
    private final ToolbarItem[] items = new ToolbarItem[ExpandedState.values().length];
    private final List<MouseInputListener> mouseListeners = new ArrayList<MouseInputListener>();
    private Orientation orientation = Orientation.HORIZONTAL;
    private Background background = new Background();

    public ToolbarItemDockable() {
        this((ToolbarItem)null, null, null);
    }

    public ToolbarItemDockable(Icon icon) {
        this((ToolbarItem)null, null, icon);
    }

    public ToolbarItemDockable(String title) {
        this((ToolbarItem)null, title, null);
    }

    public ToolbarItemDockable(DockAction action) {
        this(action, null, null);
    }

    public ToolbarItemDockable(Component component) {
        this(component, null, null);
    }

    public ToolbarItemDockable(ToolbarItem item) {
        this(item, null, null);
    }

    public ToolbarItemDockable(DockAction action, Icon icon) {
        this(action, null, icon);
    }

    public ToolbarItemDockable(Component component, Icon icon) {
        this(component, null, icon);
    }

    public ToolbarItemDockable(ToolbarItem item, Icon icon) {
        this(item, null, icon);
    }

    public ToolbarItemDockable(DockAction action, String title) {
        this(action, title, null);
    }

    public ToolbarItemDockable(Component component, String title) {
        this(component, title, null);
    }

    public ToolbarItemDockable(ToolbarItem item, String title) {
        this(item, title, null);
    }

    public ToolbarItemDockable(DockAction action, String title, Icon icon) {
        super(PropertyKey.DOCKABLE_TITLE, PropertyKey.DOCKABLE_TOOLTIP);
        this.init(title, icon);
        this.setAction(action, ExpandedState.SHRUNK);
    }

    public ToolbarItemDockable(Component component, String title, Icon icon) {
        super(PropertyKey.DOCKABLE_TITLE, PropertyKey.DOCKABLE_TOOLTIP);
        this.init(title, icon);
        this.setComponent(component, ExpandedState.SHRUNK);
    }

    public ToolbarItemDockable(ToolbarItem item, String title, Icon icon) {
        super(PropertyKey.DOCKABLE_TITLE, PropertyKey.DOCKABLE_TOOLTIP);
        this.init(title, icon);
        this.setItem(item, ExpandedState.SHRUNK);
    }

    private void init(String title, Icon icon) {
        this.contentLayout = new CardLayout(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Dimension preferredLayoutSize(Container parent) {
                Object object = parent.getTreeLock();
                synchronized (object) {
                    ToolbarItem current = ToolbarItemDockable.this.getNearestComponent(ToolbarItemDockable.this.state);
                    if (current == null) {
                        return new Dimension(10, 10);
                    }
                    return current.getComponent().getPreferredSize();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Dimension minimumLayoutSize(Container parent) {
                Object object = parent.getTreeLock();
                synchronized (object) {
                    ToolbarItem current = ToolbarItemDockable.this.getNearestComponent(ToolbarItemDockable.this.state);
                    if (current == null) {
                        return new Dimension(10, 10);
                    }
                    return current.getComponent().getMinimumSize();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Dimension maximumLayoutSize(Container parent) {
                Object object = parent.getTreeLock();
                synchronized (object) {
                    ToolbarItem current = ToolbarItemDockable.this.getNearestComponent(ToolbarItemDockable.this.state);
                    if (current == null) {
                        return new Dimension(10, 10);
                    }
                    return current.getComponent().getMaximumSize();
                }
            }
        };
        this.content = new ConfiguredBackgroundPanel((LayoutManager)this.contentLayout, Transparency.SOLID);
        this.content.setFocusable(false);
        this.content.setFocusTraversalPolicyProvider(true);
        this.content.setFocusTraversalPolicy((FocusTraversalPolicy)new LayoutFocusTraversalPolicy());
        this.content.setBackground((BackgroundAlgorithm)this.background);
        new ExpandableStateController(this);
        new OrientationObserver(this){

            @Override
            protected void orientationChanged(Orientation current) {
                ToolbarItemDockable.this.orientation = current;
                for (ToolbarItem item : ToolbarItemDockable.this.items) {
                    if (item == null) continue;
                    item.setOrientation(current);
                }
            }
        };
        this.setTitleIcon(icon);
        this.setTitleText(title);
    }

    protected DockComponentRootHandler createRootHandler() {
        return new DockComponentRootHandler((DockComponentRoot)this){

            protected DockComponentRootHandler.TraverseResult shouldTraverse(Component component) {
                if (component == ToolbarItemDockable.this.content) {
                    return DockComponentRootHandler.TraverseResult.EXCLUDE_CHILDREN;
                }
                return DockComponentRootHandler.TraverseResult.INCLUDE_CHILDREN;
            }
        };
    }

    private ToolbarItem getNearestComponent(ExpandedState state) {
        int index;
        if (this.getController() == null) {
            return null;
        }
        for (index = state.ordinal(); index >= 0; --index) {
            if (this.items[index] == null) continue;
            return this.items[index];
        }
        for (index = state.ordinal() + 1; index < this.items.length; ++index) {
            if (this.items[index] == null) continue;
            return this.items[index];
        }
        return null;
    }

    private ExpandedState getNearestState(ExpandedState state) {
        ToolbarItem nearest = this.getNearestComponent(state);
        if (nearest == null) {
            return null;
        }
        for (ExpandedState next : ExpandedState.values()) {
            if (this.items[next.ordinal()] != nearest) continue;
            return next;
        }
        return null;
    }

    public void addMouseInputListener(MouseInputListener listener) {
        super.addMouseInputListener(listener);
        this.mouseListeners.add(listener);
        ToolbarItem item = this.getCurrentItem();
        if (item != null) {
            item.addMouseInputListener(listener);
        }
    }

    public void removeMouseInputListener(MouseInputListener listener) {
        super.removeMouseInputListener(listener);
        this.mouseListeners.remove(listener);
        ToolbarItem item = this.getCurrentItem();
        if (item != null) {
            item.removeMouseInputListener(listener);
        }
    }

    public void setAction(DockAction action, ExpandedState state) {
        if (action == null) {
            this.setItem(null, state);
        } else {
            this.setItem(new DockActionItem(action), state);
        }
    }

    public void setComponent(Component component, ExpandedState state) {
        if (component == null) {
            this.setItem(null, state);
        } else {
            this.setItem(new ComponentItem(component), state);
        }
    }

    public void setItem(ToolbarItem item, ExpandedState state) {
        boolean newEnabled;
        if (item != null) {
            item.setOrientation(this.orientation);
        }
        ToolbarItem previous = this.items[state.ordinal()];
        boolean enabled = this.isEnabled(state);
        if (previous != item) {
            if (item != null) {
                item.setDockable(this);
            }
            if (this.getController() == null) {
                this.items[state.ordinal()] = item;
            } else {
                ExpandedState nearest;
                ToolbarItem current = this.getCurrentItem();
                if (current != null && current == previous) {
                    current.setSelected(false);
                    for (MouseInputListener listener : this.mouseListeners) {
                        current.removeMouseInputListener(listener);
                    }
                }
                if (previous != null) {
                    this.content.remove(previous.getComponent());
                    previous.unbind();
                    previous.setController(null);
                }
                this.items[state.ordinal()] = item;
                if (item != null) {
                    item.setController(this.getController());
                    item.bind();
                    this.content.add(item.getComponent(), (Object)state.toString());
                    current = this.getCurrentItem();
                    if (current != null && current == item) {
                        current.setSelected(true);
                        for (MouseInputListener listener : this.mouseListeners) {
                            current.addMouseInputListener(listener);
                        }
                    } else {
                        item.setSelected(false);
                    }
                }
                if ((nearest = this.getNearestState(this.state)) != null) {
                    this.contentLayout.show((Container)this.content, nearest.toString());
                    this.content.revalidate();
                }
            }
            if (previous != null) {
                previous.setDockable(null);
            }
        }
        if ((newEnabled = this.isEnabled(state)) != enabled) {
            for (ExpandableToolbarItemListener listener : this.expandableListeners.toArray(new ExpandableToolbarItemListener[this.expandableListeners.size()])) {
                listener.enablementChanged(this, state, newEnabled);
            }
        }
    }

    public void setController(DockController controller) {
        if (this.getController() != controller) {
            Object item;
            Object current;
            if (this.getController() != null) {
                current = this.getCurrentItem();
                if (current != null) {
                    for (MouseInputListener listener : this.mouseListeners) {
                        current.removeMouseInputListener(listener);
                    }
                }
                ToolbarItem[] toolbarItemArray = this.items;
                int listener = toolbarItemArray.length;
                for (int i = 0; i < listener; ++i) {
                    item = toolbarItemArray[i];
                    if (item == null) continue;
                    this.content.remove(item.getComponent());
                    item.unbind();
                    item.setController(null);
                }
            }
            super.setController(controller);
            this.background.setController(controller);
            if (controller != null) {
                for (ExpandedState state : ExpandedState.values()) {
                    item = this.items[state.ordinal()];
                    if (item == null) continue;
                    item.setController(controller);
                    item.bind();
                    this.content.add(item.getComponent(), (Object)state.toString());
                }
                current = this.getCurrentItem();
                if (current != null) {
                    for (MouseInputListener listener : this.mouseListeners) {
                        current.addMouseInputListener(listener);
                    }
                }
            }
            this.forceState(this.state);
        }
    }

    @Override
    public void setExpandedState(ExpandedState state) {
        if (this.state != state) {
            this.forceState(state);
        }
    }

    private void forceState(ExpandedState state) {
        ExpandedState nearest;
        ExpandedState oldState = this.state;
        ToolbarItem oldItem = this.getCurrentItem();
        this.state = state;
        ToolbarItem newItem = this.getCurrentItem();
        if (oldItem != newItem) {
            if (oldItem != null) {
                oldItem.setSelected(false);
                for (MouseInputListener listener : this.mouseListeners) {
                    oldItem.removeMouseInputListener(listener);
                }
            }
            if (newItem != null) {
                newItem.setSelected(true);
                for (MouseInputListener listener : this.mouseListeners) {
                    newItem.addMouseInputListener(listener);
                }
            }
        }
        if ((nearest = this.getNearestState(state)) != null) {
            this.contentLayout.show((Container)this.content, nearest.toString());
        }
        this.content.revalidate();
        if (oldState != state) {
            for (ExpandableToolbarItemListener listener : this.expandableListeners.toArray(new ExpandableToolbarItemListener[this.expandableListeners.size()])) {
                listener.changed(this, oldState, state);
            }
        }
    }

    private ToolbarItem getCurrentItem() {
        return this.getNearestComponent(this.state);
    }

    @Override
    public boolean isEnabled(ExpandedState state) {
        return this.items[state.ordinal()] != null;
    }

    @Override
    public ExpandedState getExpandedState() {
        return this.state;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public Component getComponent() {
        return this.content;
    }

    @Override
    public void addExpandableListener(ExpandableToolbarItemListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.expandableListeners.add(listener);
    }

    @Override
    public void removeExpandableListener(ExpandableToolbarItemListener listener) {
        this.expandableListeners.remove(listener);
    }

    public DockStation asDockStation() {
        return null;
    }

    public String getFactoryID() {
        return "ToolbarItemDockableFactory";
    }

    protected DockIcon createTitleIcon() {
        return new DockableIcon("dockable.default", this){

            protected void changed(Icon oldValue, Icon newValue) {
                ToolbarItemDockable.this.fireTitleIconChanged(oldValue, newValue);
            }
        };
    }

    public boolean accept(DockStation station) {
        SilentPropertyValue value = new SilentPropertyValue(ToolbarStrategy.STRATEGY, this.getController());
        ToolbarStrategy strategy = (ToolbarStrategy)value.getValue();
        value.setProperties((DockController)null);
        return strategy.isToolbarGroupPartParent(station, this, false);
    }

    public boolean accept(DockStation base, Dockable neighbour) {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '@' + Integer.toHexString(this.hashCode());
    }

    private class Background
    extends BackgroundAlgorithm
    implements DockableBackgroundComponent {
        public Background() {
            super(DockableBackgroundComponent.KIND, "dock.background.dockable.toolbar");
        }

        public Component getComponent() {
            return this.getDockable().getComponent();
        }

        public Dockable getDockable() {
            return ToolbarItemDockable.this;
        }
    }
}

